/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MatchableInvocation;
import org.mockito.verification.VerificationMode;

public class Only
implements VerificationMode {
    @Override
    public void verify(VerificationData data) {
        MatchableInvocation target = data.getTarget();
        List<Invocation> invocations = data.getAllInvocations();
        List<Invocation> chunk = InvocationsFinder.findInvocations(invocations, target);
        if (invocations.size() != 1 && !chunk.isEmpty()) {
            Invocation unverified = InvocationsFinder.findFirstUnverified(invocations);
            throw Reporter.noMoreInteractionsWanted(unverified, invocations);
        }
        if (invocations.size() != 1 || chunk.isEmpty()) {
            throw Reporter.wantedButNotInvoked(target);
        }
        InvocationMarker.markVerified(chunk.get(0), target);
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

