#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Features.Transforms.Basis import Basis

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1484975071.534305
__CHEETAH_genTimestamp__ = 'Sat Jan 21 16:04:31 2017'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-2.2.3/xpdeint/Features/Transforms/EPBasis.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Feb  4 18:39:07 2012'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class EPBasis(Basis):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(EPBasis, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def transformFunctionStart(self, **KWS):



        ## CHEETAH: generated from @def transformFunctionStart at line 28, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''static ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 29, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 29, col 8.
        write(u''' *_mmt_matrix_forward_even = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 30, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 30, col 8.
        write(u''' *_mmt_matrix_forward_odd  = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 31, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 31, col 8.
        write(u''' *_mmt_matrix_backward_even = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 32, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 32, col 8.
        write(u''' *_mmt_matrix_backward_odd  = NULL;
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimReps(self, forwardDimRep, backwardDimRep, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimReps($forwardDimRep, $backwardDimRep) at line 36, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''long _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 37, col 12
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 37, col 12.
        write(u''' = (''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # u'${forwardDimRep.globalLattice}' on line 37, col 37
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.globalLattice}')) # from line 37, col 37.
        write(u''' + 1)/2;
long _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 38, col 11
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 38, col 11.
        write(u''' = ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # u'${forwardDimRep.globalLattice}' on line 38, col 35
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.globalLattice}')) # from line 38, col 35.
        write(u'''/2;
long _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 39, col 12
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 39, col 12.
        write(u''' = (''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # u'${backwardDimRep.globalLattice}' on line 39, col 38
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.globalLattice}')) # from line 39, col 38.
        write(u''' + 1)/2;
long _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 40, col 11
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 40, col 11.
        write(u''' = ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # u'${backwardDimRep.globalLattice}' on line 40, col 36
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.globalLattice}')) # from line 40, col 36.
        write(u'''/2;
_mmt_matrix_forward_even = (''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 41, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 41, col 29.
        write(u''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 41, col 62
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 41, col 62.
        write(u''') * _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 41, col 83
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 41, col 83.
        write(u''' * _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 41, col 113
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 41, col 113.
        write(u''');
_mmt_matrix_forward_odd  = (''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 42, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 42, col 29.
        write(u''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 42, col 62
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 42, col 62.
        write(u''') * _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 42, col 82
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 42, col 82.
        write(u''' * _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 42, col 111
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 42, col 111.
        write(u''');
_mmt_matrix_backward_even = (''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 43, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 43, col 30.
        write(u''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 43, col 63
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 43, col 63.
        write(u''') * _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 43, col 84
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 43, col 84.
        write(u''' * _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 43, col 115
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 43, col 115.
        write(u''');
_mmt_matrix_backward_odd  = (''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 44, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 44, col 30.
        write(u''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # u'$matrixType' on line 44, col 63
        if _v is not None: write(_filter(_v, rawExpr=u'$matrixType')) # from line 44, col 63.
        write(u''') * _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 44, col 83
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 44, col 83.
        write(u''' * _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 44, col 113
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 44, col 113.
        write(u''');

for (long _i0 = 0; _i0 < _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 46, col 32
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 46, col 32.
        write(u'''; _i0++) {
  long __i0 = ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # u'${forwardDimRep.globalLattice}' on line 47, col 15
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.globalLattice}')) # from line 47, col 15.
        write(u''' - 1 - _i0;
  ''')
        _v = VFFSL(SL,"transformMatricesForwardDimConstantsAtIndex",False)(forwardDimRep, backwardDimRep, '__i0') # u"${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '__i0'), autoIndent=True}" on line 48, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '__i0'), autoIndent=True}")) # from line 48, col 3.
        write(u'''  for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # u'${backwardDimRep.globalLattice}' on line 49, col 28
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.globalLattice}')) # from line 49, col 28.
        write(u'''; _i1++) {
    ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndices",False)(forwardDimRep, backwardDimRep, '_i0', '_i1') # u"${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}" on line 50, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}")) # from line 50, col 5.
        write(u'''  }
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 55, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''if (''')
        _v = VFFSL(SL,"backwardIndex",True) # u'${backwardIndex}' on line 57, col 5
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardIndex}')) # from line 57, col 5.
        write(u''' & 1) {
  // ''')
        _v = VFFSL(SL,"backwardIndex",True) # u'${backwardIndex}' on line 58, col 6
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardIndex}')) # from line 58, col 6.
        write(u''' is odd
  if (''')
        _v = VFFSL(SL,"forwardIndex",True) # u'${forwardIndex}' on line 59, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardIndex}')) # from line 59, col 7.
        write(u''' < _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 59, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 59, col 30.
        write(u''') {
    ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndicesOfKind",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd') # u"${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd'), autoIndent=True}" on line 60, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd'), autoIndent=True}")) # from line 60, col 5.
        write(u'''  }
} else {
  // ''')
        _v = VFFSL(SL,"backwardIndex",True) # u'${backwardIndex}' on line 63, col 6
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardIndex}')) # from line 63, col 6.
        write(u''' is even
  ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndicesOfKind",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even') # u"${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even'), autoIndent=True}" on line 64, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even'), autoIndent=True}")) # from line 64, col 3.
        write(u'''}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndicesOfKind(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, kind, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndicesOfKind($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex, $kind) at line 69, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        logicalForwardIndex = '_' + forwardIndex
        logicalBackwardIndex = backwardIndex
        actualBackwardIndex = '_' + backwardIndex
        if kind == 'even': # generated from line 74, col 3
            actualForwardIndex = forwardIndex
        else: # generated from line 76, col 3
            actualForwardIndex = ''.join([u'(_odd_',str(VFFSL(SL,"forwardDimRep.name",True)),u' -1 - ',str(VFFSL(SL,"forwardIndex",True)),u')'])
        write(u'''long ''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # u'${actualBackwardIndex}' on line 79, col 6
        if _v is not None: write(_filter(_v, rawExpr=u'${actualBackwardIndex}')) # from line 79, col 6.
        write(u''' = ''')
        _v = VFFSL(SL,"backwardIndex",True) # u'${backwardIndex}' on line 79, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardIndex}')) # from line 79, col 31.
        write(u'''/2;
_mmt_matrix_forward_''')
        _v = VFFSL(SL,"kind",True) # u'${kind}' on line 80, col 21
        if _v is not None: write(_filter(_v, rawExpr=u'${kind}')) # from line 80, col 21.
        write(u'''[''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # u'${actualBackwardIndex}' on line 80, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'${actualBackwardIndex}')) # from line 80, col 29.
        write(u''' * _''')
        _v = VFFSL(SL,"kind",True) # u'${kind}' on line 80, col 55
        if _v is not None: write(_filter(_v, rawExpr=u'${kind}')) # from line 80, col 55.
        write(u'''_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # u'${forwardDimRep.name}' on line 80, col 63
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardDimRep.name}')) # from line 80, col 63.
        write(u''' + ''')
        _v = VFFSL(SL,"actualForwardIndex",True) # u'${actualForwardIndex}' on line 80, col 87
        if _v is not None: write(_filter(_v, rawExpr=u'${actualForwardIndex}')) # from line 80, col 87.
        write(u'''] = \\
  ''')
        _v = VFFSL(SL,"forwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex) # u'${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}' on line 81, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}')) # from line 81, col 3.
        write(u''';
_mmt_matrix_backward_''')
        _v = VFFSL(SL,"kind",True) # u'${kind}' on line 82, col 22
        if _v is not None: write(_filter(_v, rawExpr=u'${kind}')) # from line 82, col 22.
        write(u'''[''')
        _v = VFFSL(SL,"actualForwardIndex",True) # u'${actualForwardIndex}' on line 82, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'${actualForwardIndex}')) # from line 82, col 30.
        write(u''' * _''')
        _v = VFFSL(SL,"kind",True) # u'${kind}' on line 82, col 55
        if _v is not None: write(_filter(_v, rawExpr=u'${kind}')) # from line 82, col 55.
        write(u'''_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # u'${backwardDimRep.name}' on line 82, col 63
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardDimRep.name}')) # from line 82, col 63.
        write(u''' + ''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # u'${actualBackwardIndex}' on line 82, col 88
        if _v is not None: write(_filter(_v, rawExpr=u'${actualBackwardIndex}')) # from line 82, col 88.
        write(u'''] = \\
  ''')
        _v = VFFSL(SL,"backwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex) # u'${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}' on line 83, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}')) # from line 83, col 3.
        write(u''';
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performTransform(self, sourceDimRep, destDimRep, dir=None, **KWS):



        ## CHEETAH: generated from @def performTransform($sourceDimRep, $destDimRep, $dir = None) at line 87, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if dir == 'forward': # generated from line 89, col 3
            _v = VFFSL(SL,"performForwardTransform",False)(sourceDimRep, destDimRep) # u'${performForwardTransform(sourceDimRep, destDimRep)}' on line 90, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${performForwardTransform(sourceDimRep, destDimRep)}')) # from line 90, col 1.
        else: # generated from line 91, col 3
            _v = VFFSL(SL,"performBackwardTransform",False)(sourceDimRep, destDimRep) # u'${performBackwardTransform(sourceDimRep, destDimRep)}' on line 92, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${performBackwardTransform(sourceDimRep, destDimRep)}')) # from line 92, col 1.
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performForwardTransform(self, sourceDimRep, destDimRep, **KWS):



        ## CHEETAH: generated from @def performForwardTransform($sourceDimRep, $destDimRep) at line 96, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        blasTypeChar = {'real': {'single': 's', 'double': 'd'}, 'complex': {'single': 'c', 'double': 'z'}}[self.matrixType][VFFSL(SL,"precision",True)]
        alphaBetaPrefix = {'real': '', 'complex': '&'}[self.matrixType]
        matMultFunction = 'cblas_%sgemm' % blasTypeChar
        write(u'''// Loop to create symmetric and antisymmetric components.
''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 102, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 102, col 1.
        write(u''' _temp;
long outerOffset = _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 103, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 103, col 42.
        write(u''';
for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 104, col 26
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 104, col 26.
        write(u'''/2; _i1++) {
  ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 105, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 105, col 3.
        write(u'''* __restrict__ _low = &source_data[outerOffset + _i1 * innerLoopSize];
  ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 106, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 106, col 3.
        write(u'''* __restrict__ _high = &source_data[outerOffset + (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 106, col 67
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 106, col 67.
        write(u''' - 1 - _i1) * innerLoopSize];
  for (long _i2 = 0; _i2 < innerLoopSize; _i2++) {
    _temp = _low[_i2];
    _low[_i2] += _high[_i2];  // _low stores the symmetric component
    _high[_i2] -= _temp; // _high stores the antisymmetric component
  }
}
const ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 113, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 113, col 7.
        write(u''' alpha = 1.0;
const ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 114, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 114, col 7.
        write(u''' beta = 0.0;

// Symmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # u'${matMultFunction}' on line 117, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matMultFunction}')) # from line 117, col 1.
        write(u'''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 118, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 118, col 14.
        write(u'''+1)/2,
            /* nelem */ innerLoopSize,
            (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 120, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 120, col 14.
        write(u'''+1)/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 121, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 121, col 25.
        write(u'''alpha,
            /* A */ _mmt_matrix_forward_even, (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 122, col 48
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 122, col 48.
        write(u'''+1)/2,
            /* B */ source_data + _i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 123, col 41
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 123, col 41.
        write(u''' * innerLoopSize,
                    innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 125, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 125, col 24.
        write(u'''beta,
            /* C */ dest_data + _i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 126, col 39
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 126, col 39.
        write(u''' * innerLoopSize,
            2 * innerLoopSize);
// Antisymmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # u'${matMultFunction}' on line 129, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matMultFunction}')) # from line 129, col 1.
        write(u'''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 130, col 13
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 130, col 13.
        write(u'''/2,
            /* nelem */ innerLoopSize,
            ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 132, col 13
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 132, col 13.
        write(u'''/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 133, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 133, col 25.
        write(u'''alpha,
            /* A */ _mmt_matrix_forward_odd, ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 134, col 46
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 134, col 46.
        write(u'''/2,
            /* B */ source_data + (_i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 135, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 135, col 42.
        write(u''' + (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 135, col 75
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 135, col 75.
        write(u'''+1)/2) * innerLoopSize,
                    innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 137, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 137, col 24.
        write(u'''beta,
            /* C */ dest_data + (_i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 138, col 40
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 138, col 40.
        write(u''' + 1) * innerLoopSize,
            2 * innerLoopSize);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performBackwardTransform(self, sourceDimRep, destDimRep, **KWS):



        ## CHEETAH: generated from @def performBackwardTransform($sourceDimRep, $destDimRep) at line 143, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        blasTypeChar = {'real': {'single': 's', 'double': 'd'}, 'complex': {'single': 'c', 'double': 'z'}}[self.matrixType][VFFSL(SL,"precision",True)]
        alphaBetaPrefix = {'real': '', 'complex': '&'}[self.matrixType]
        matMultFunction = 'cblas_%sgemm' % blasTypeChar
        write(u'''const ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 148, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 148, col 7.
        write(u''' alpha = 1.0;
const ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 149, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 149, col 7.
        write(u''' beta = 0.0;

// Symmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # u'${matMultFunction}' on line 152, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matMultFunction}')) # from line 152, col 1.
        write(u'''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 153, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 153, col 14.
        write(u'''+1)/2,
            /* nelem */ innerLoopSize,
            (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 155, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 155, col 14.
        write(u'''+1)/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 156, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 156, col 25.
        write(u'''alpha,
            /* A */ _mmt_matrix_backward_even, (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 157, col 49
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 157, col 49.
        write(u'''+1)/2,
            /* B */ source_data + _i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 158, col 41
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 158, col 41.
        write(u''' * innerLoopSize,
                    2 * innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 160, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 160, col 24.
        write(u'''beta,
            /* C */ dest_data + _i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 161, col 39
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 161, col 39.
        write(u''' * innerLoopSize,
            innerLoopSize);
// Antisymmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # u'${matMultFunction}' on line 164, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matMultFunction}')) # from line 164, col 1.
        write(u'''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 165, col 13
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 165, col 13.
        write(u'''/2,
            /* nelem */ innerLoopSize,
            ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 167, col 13
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 167, col 13.
        write(u'''/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 168, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 168, col 25.
        write(u'''alpha,
            /* A */ _mmt_matrix_backward_odd, ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 169, col 47
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 169, col 47.
        write(u'''/2,
            /* B */ source_data + (_i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # u'${sourceDimRep.globalLattice}' on line 170, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'${sourceDimRep.globalLattice}')) # from line 170, col 42.
        write(u''' + 1) * innerLoopSize,
                    2 * innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # u'${alphaBetaPrefix}' on line 172, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${alphaBetaPrefix}')) # from line 172, col 24.
        write(u'''beta,
            /* C */ dest_data + (_i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 173, col 40
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 173, col 40.
        write(u''' + (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 173, col 71
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 173, col 71.
        write(u'''+1)/2) * innerLoopSize,
            innerLoopSize);
// Loop to unravel symmetric and antisymmetric components.
''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 176, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 176, col 1.
        write(u''' _temp;
long outerOffset = _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 177, col 42
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 177, col 42.
        write(u''';
for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 178, col 26
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 178, col 26.
        write(u'''/2; _i1++) {
  // _low stored the symmetric component
  ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 180, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 180, col 3.
        write(u'''* __restrict__ _low = &dest_data[outerOffset + _i1 * innerLoopSize];
  // _high stored the antisymmetric component
  ''')
        _v = VFFSL(SL,"matrixType",True) # u'${matrixType}' on line 182, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${matrixType}')) # from line 182, col 3.
        write(u'''* __restrict__ _high = &dest_data[outerOffset + (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # u'${destDimRep.globalLattice}' on line 182, col 65
        if _v is not None: write(_filter(_v, rawExpr=u'${destDimRep.globalLattice}')) # from line 182, col 65.
        write(u''' - 1 - _i1) * innerLoopSize];
  for (long _i2 = 0; _i2 < innerLoopSize; _i2++) {
    _temp = _low[_i2];
    // _low is the negative domain
    _low[_i2] -= _high[_i2];
    // _high is the positive domain
    _high[_i2] += _temp;
  }
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # EPBasis.tmpl
        # 
        # Base class for a Basis where each basis function has definite parity
        # and the parity alternates between successive basis functions.
        # Bases inheriting from this class will use the faster Parity Matrix Multiplication Transform (PMMT).
        # 
        # Created by Graham Dennis on 2008-12-27.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''








''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_EPBasis= 'writeBody'

## END CLASS DEFINITION

if not hasattr(EPBasis, '_initCheetahAttributes'):
    templateAPIClass = getattr(EPBasis, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(EPBasis)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=EPBasis()).run()


