/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_output.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_output.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_OUTPUT_H
#define XMDS_OUTPUT_H

#include <xmds_element.h>
#include <xmds_moment_group.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsOutput
// *****************************************************************************
// *****************************************************************************

//! Class which organises data output of simulation
class xmdsOutput : public xmdsElement {

  public :

    //! Constructor of xmdsOutput object
    xmdsOutput(
         const xmdsSimulation *const yourSimulation,
         const bool& yourVerboseMode);

  //! Destructor
  ~xmdsOutput();

  //! Process elements defined in output section of xmds file
  void processElement(
                      const Element *const yourElement);

  //! Sets the point in the input file to split
  void setInFileSplitPoint(
                           const unsigned long& inFileSplitPoint);

  //! Determines the number of moment groups for output
  unsigned long nMomentGroups() const;

  //! Return the output file name
  XMLString getOutputFileName() const;

  //! Creates an xmdsMomentGroup object
  const xmdsMomentGroup* momentGroup(
                                     const unsigned long& index) const;

  //! Adds samples to the output samples list
  void addSamples(
                  const list<unsigned long>& samplesList) const;

  //! Sets up the final geometry to use for output
  void finaliseGeometry();

  //! Assigns the active vector pointers in the list of moment groups
  void assignActiveVectorPointers(
                                  FILE *const outfile,
                                  const char *const tempVectorName) const;

  //! Writes the FFTW plan creation calls to file
  void writePlanCreationCalls(
                              FILE *const outfile,
                              const bool& useFFTWMeasure,
                              const bool& useWisdom) const;

  //! Writes the FFTW plan deletion calls to file
  void writePlanDeletionCalls(
                              FILE *const outfile) const;

  private :

    XMLString               myOutputFileName;    //!< The output filename
  list<xmdsMomentGroup*>  myMomentGroupsList;  //!< The list of output moment groups
  unsigned long           myInFileSplitPoint;  //!< The point at which to split the input file
  bool                    bpEnabledFlag;       //!< Whether or not breakpoints are enabled

  //! Write the output prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Write the output routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Create an xmds moment group object
  xmdsMomentGroup* createxmdsMomentGroup();

};

#endif // XMDS_OUTPUT_H
