/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_element.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_element.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_ELEMENT_H
#define XMDS_ELEMENT_H

#include <xmds_utils.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsElement
// *****************************************************************************
// *****************************************************************************

class xmdsSimulation;

//! Class representing an element in an xmds simulation
class xmdsElement :     public xmdsUtility {

  public :

    //! Constructor of xmdsElement object
    xmdsElement(
    const xmdsSimulation *const yourSimulation,
    const bool& yourVerboseMode);

  ~xmdsElement();  //!< xmdsElement destructor

  // This was in protected!
  //! Returns the xmds simulation
  const xmdsSimulation* simulation() const;

  protected :

    //! Writes the defines of output C++ code
    virtual void writeDefines(
            FILE *const outfile) const;

  //! Writes the global variables to output C++ code
  virtual void writeGlobals(
                            FILE *const outfile) const;

  //! Writes the prototypes of the C++ code
  virtual void writePrototypes(
                               FILE *const outfile) const;

  //! Writes the routines of the xmds C++ code
  virtual void writeRoutines(
                             FILE *const outfile) const;

  //! Adds a child
  void addChild(
                const xmdsElement *const newChild);

  //! Determines if output is verbose
  bool verbose() const;

  private :

    const xmdsSimulation *const mySimulation;  //!< The main simulation object
  const bool myVerbose;                      //!< Variable describing if the output should be verbose or not
  list<const xmdsElement*> myChildList;      //!< List of child elements

  //! Parse the XMLString inString and generate the output list of XML strings outXMLStringList
  void parseXMLString(
                      const XMLString *const inString,
                      list<XMLString>& outXMLStringList);
};

#endif // XMDS_ELEMENT_H
