//
//  Copyright (C) 1999 by
//  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
// DESCRIPTION:
//  Thing frame/state LUT,
//  generated by multigen utilitiy.
//  This one is the original DOOM version, preserved.
//  BOOM changes include commenting and addition of predefined lumps
//  for providing things that aren't in the IWAD without sending a
//  separate must-use wad file around with the EXE.
//
//-----------------------------------------------------------------------------

#include "info.h"

#include <stddef.h>

#include "doomtype.h"
#include "m_fixed.h"
#include "p_mobj.h"
#include "sounds.h"
#include "w_wad.h"

// ********************************************************************
// Sprite names
// ********************************************************************
// This is the list of sprite 4-character prefixes.  They are searched
// through, with a NULL entry terminating the list.  In DOOM originally
// this NULL entry was missing, and coincidentally the next thing in
// memory was the dummy state_t[] entry that started with zero bytes.
// killough 1/17/98: add an explicit NULL entry.
// NUMSPRITES is an enum from info.h where all these are listed
// as SPR_xxxx

char *original_sprnames[NUMSPRITES+1] = {
  "TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
  "MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
  "PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
  "SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
  "HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
  "PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
  "BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
  "SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
  "ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
  "LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
  "POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
  "COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
  "COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
  "HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2",
  "TNT1", // invisible sprite                                 phares 3/9/98

  "DOGS", // killough 7/19/98: Marine's best friend :)

  "PLS1", // killough 7/19/98: first  of two plasma fireballs in the beta
  "PLS2", // killough 7/19/98: second of two plasma fireballs in the beta
  "BON3", // killough 7/11/98: evil sceptre in the beta version
  "BON4", // killough 7/11/98: unholy bible in the beta version

  "BLD2", // [FG] blood splats from Doom Retro, unsused in Woof!

  // [FG] 100 extra sprite names to use in dehacked patches
  "SP00", "SP01", "SP02", "SP03", "SP04", "SP05", "SP06", "SP07", "SP08", "SP09",
  "SP10", "SP11", "SP12", "SP13", "SP14", "SP15", "SP16", "SP17", "SP18", "SP19",
  "SP20", "SP21", "SP22", "SP23", "SP24", "SP25", "SP26", "SP27", "SP28", "SP29",
  "SP30", "SP31", "SP32", "SP33", "SP34", "SP35", "SP36", "SP37", "SP38", "SP39",
  "SP40", "SP41", "SP42", "SP43", "SP44", "SP45", "SP46", "SP47", "SP48", "SP49",
  "SP50", "SP51", "SP52", "SP53", "SP54", "SP55", "SP56", "SP57", "SP58", "SP59",
  "SP60", "SP61", "SP62", "SP63", "SP64", "SP65", "SP66", "SP67", "SP68", "SP69",
  "SP70", "SP71", "SP72", "SP73", "SP74", "SP75", "SP76", "SP77", "SP78", "SP79",
  "SP80", "SP81", "SP82", "SP83", "SP84", "SP85", "SP86", "SP87", "SP88", "SP89",
  "SP90", "SP91", "SP92", "SP93", "SP94", "SP95", "SP96", "SP97", "SP98", "SP99",

  NULL
};

#include "p_action.h"

// ********************************************************************
// State or "frame" information
// ********************************************************************
// Each of the states, otherwise known as "frames", is outlined
// here.  The data in each element of the array is the way it is
// initialized, with sprite names identified by their enumerator
// value such as SPR_SHTG.  These correlate to the above sprite
// array so don't change them around unless you understand what
// you're doing.
//
// The commented name beginning with S_ at the end of each line
// is there to help figure out where the next-frame pointer is
// pointing.  These are also additionally identified in info.h
// as enumerated values.  From a change-and-recompile point of
// view this is fairly workable, but it adds a lot to the effort
// when trying to change things externally.  See also the d_deh.c
// parts where frame rewiring is done for more details and the
// extended way a BEX file can handle this.
//
// killough 11/98: cleaned up, since we don't need to accomodate C++

state_t original_states[NUMSTATES] = {
  {SPR_TROO,0,-1,{NULL},S_NULL},  // S_NULL
  {SPR_SHTG,4,0,{.p2 = A_Light0},S_NULL}, // S_LIGHTDONE
  {SPR_PUNG,0,1,{.p2 = A_WeaponReady},S_PUNCH}, // S_PUNCH
  {SPR_PUNG,0,1,{.p2 = A_Lower},S_PUNCHDOWN}, // S_PUNCHDOWN
  {SPR_PUNG,0,1,{.p2 = A_Raise},S_PUNCHUP}, // S_PUNCHUP
  {SPR_PUNG,1,4,{NULL},S_PUNCH2},   // S_PUNCH1
  {SPR_PUNG,2,4,{.p2 = A_Punch},S_PUNCH3},  // S_PUNCH2
  {SPR_PUNG,3,5,{NULL},S_PUNCH4},   // S_PUNCH3
  {SPR_PUNG,2,4,{NULL},S_PUNCH5},   // S_PUNCH4
  {SPR_PUNG,1,5,{.p2 = A_ReFire},S_PUNCH},  // S_PUNCH5
  {SPR_PISG,0,1,{.p2 = A_WeaponReady},S_PISTOL},// S_PISTOL
  {SPR_PISG,0,1,{.p2 = A_Lower},S_PISTOLDOWN},  // S_PISTOLDOWN
  {SPR_PISG,0,1,{.p2 = A_Raise},S_PISTOLUP},  // S_PISTOLUP
  {SPR_PISG,0,4,{NULL},S_PISTOL2},  // S_PISTOL1
  {SPR_PISG,1,6,{.p2 = A_FirePistol},S_PISTOL3},// S_PISTOL2
  {SPR_PISG,2,4,{NULL},S_PISTOL4},  // S_PISTOL3
  {SPR_PISG,1,5,{.p2 = A_ReFire},S_PISTOL}, // S_PISTOL4
  {SPR_PISF,0|FF_FULLBRIGHT,7,{.p2 = A_Light1},S_LIGHTDONE},  // S_PISTOLFLASH
  {SPR_SHTG,0,1,{.p2 = A_WeaponReady},S_SGUN},  // S_SGUN
  {SPR_SHTG,0,1,{.p2 = A_Lower},S_SGUNDOWN},  // S_SGUNDOWN
  {SPR_SHTG,0,1,{.p2 = A_Raise},S_SGUNUP},  // S_SGUNUP
  {SPR_SHTG,0,3,{NULL},S_SGUN2},  // S_SGUN1
  {SPR_SHTG,0,7,{.p2 = A_FireShotgun},S_SGUN3}, // S_SGUN2
  {SPR_SHTG,1,5,{NULL},S_SGUN4},  // S_SGUN3
  {SPR_SHTG,2,5,{NULL},S_SGUN5},  // S_SGUN4
  {SPR_SHTG,3,4,{NULL},S_SGUN6},  // S_SGUN5
  {SPR_SHTG,2,5,{NULL},S_SGUN7},  // S_SGUN6
  {SPR_SHTG,1,5,{NULL},S_SGUN8},  // S_SGUN7
  {SPR_SHTG,0,3,{NULL},S_SGUN9},  // S_SGUN8
  {SPR_SHTG,0,7,{.p2 = A_ReFire},S_SGUN}, // S_SGUN9
  {SPR_SHTF,0|FF_FULLBRIGHT,4,{.p2 = A_Light1},S_SGUNFLASH2}, // S_SGUNFLASH1
  {SPR_SHTF,1|FF_FULLBRIGHT,3,{.p2 = A_Light2},S_LIGHTDONE},  // S_SGUNFLASH2
  {SPR_SHT2,0,1,{.p2 = A_WeaponReady},S_DSGUN}, // S_DSGUN
  {SPR_SHT2,0,1,{.p2 = A_Lower},S_DSGUNDOWN}, // S_DSGUNDOWN
  {SPR_SHT2,0,1,{.p2 = A_Raise},S_DSGUNUP}, // S_DSGUNUP
  {SPR_SHT2,0,3,{NULL},S_DSGUN2}, // S_DSGUN1

  // killough 9/5/98: make SSG lighting flash more uniform along super shotgun:

  {SPR_SHT2,0|FF_FULLBRIGHT /* killough */,7,{.p2 = A_FireShotgun2},S_DSGUN3}, // S_DSGUN2
  {SPR_SHT2,1,7,{NULL},S_DSGUN4}, // S_DSGUN3
  {SPR_SHT2,2,7,{.p2 = A_CheckReload},S_DSGUN5},  // S_DSGUN4
  {SPR_SHT2,3,7,{.p2 = A_OpenShotgun2},S_DSGUN6}, // S_DSGUN5
  {SPR_SHT2,4,7,{NULL},S_DSGUN7}, // S_DSGUN6
  {SPR_SHT2,5,7,{.p2 = A_LoadShotgun2},S_DSGUN8}, // S_DSGUN7
  {SPR_SHT2,6,6,{NULL},S_DSGUN9}, // S_DSGUN8
  {SPR_SHT2,7,6,{.p2 = A_CloseShotgun2},S_DSGUN10}, // S_DSGUN9
  {SPR_SHT2,0,5,{.p2 = A_ReFire},S_DSGUN},  // S_DSGUN10
  {SPR_SHT2,1,7,{NULL},S_DSNR2},  // S_DSNR1
  {SPR_SHT2,0,3,{NULL},S_DSGUNDOWN},  // S_DSNR2

#ifdef MBF_STRICT
  // killough 8/20/98: reduce first SSG flash frame one tic, to fix
  // Doom II SSG flash bug, in which SSG raises before flash finishes

  {SPR_SHT2,8|FF_FULLBRIGHT,4/*killough*/,{.p2 = A_Light1},S_DSGUNFLASH2}, // S_DSGUNFLASH1
#else
  {SPR_SHT2,8|FF_FULLBRIGHT,5,{.p2 = A_Light1},S_DSGUNFLASH2}, // S_DSGUNFLASH1
#endif
  {SPR_SHT2,9|FF_FULLBRIGHT,4,{.p2 = A_Light2},S_LIGHTDONE},  // S_DSGUNFLASH2
  {SPR_CHGG,0,1,{.p2 = A_WeaponReady},S_CHAIN}, // S_CHAIN
  {SPR_CHGG,0,1,{.p2 = A_Lower},S_CHAINDOWN}, // S_CHAINDOWN
  {SPR_CHGG,0,1,{.p2 = A_Raise},S_CHAINUP}, // S_CHAINUP
  {SPR_CHGG,0,4,{.p2 = A_FireCGun},S_CHAIN2}, // S_CHAIN1
  {SPR_CHGG,1,4,{.p2 = A_FireCGun},S_CHAIN3}, // S_CHAIN2
  {SPR_CHGG,1,0,{.p2 = A_ReFire},S_CHAIN},  // S_CHAIN3
  {SPR_CHGF,0|FF_FULLBRIGHT,5,{.p2 = A_Light1},S_LIGHTDONE},  // S_CHAINFLASH1
  {SPR_CHGF,1|FF_FULLBRIGHT,5,{.p2 = A_Light2},S_LIGHTDONE},  // S_CHAINFLASH2
  {SPR_MISG,0,1,{.p2 = A_WeaponReady},S_MISSILE}, // S_MISSILE
  {SPR_MISG,0,1,{.p2 = A_Lower},S_MISSILEDOWN}, // S_MISSILEDOWN
  {SPR_MISG,0,1,{.p2 = A_Raise},S_MISSILEUP}, // S_MISSILEUP
  {SPR_MISG,1,8,{.p2 = A_GunFlash},S_MISSILE2}, // S_MISSILE1
  {SPR_MISG,1,12,{.p2 = A_FireMissile},S_MISSILE3}, // S_MISSILE2
  {SPR_MISG,1,0,{.p2 = A_ReFire},S_MISSILE},  // S_MISSILE3
  {SPR_MISF,0|FF_FULLBRIGHT,3,{.p2 = A_Light1},S_MISSILEFLASH2},  // S_MISSILEFLASH1
  {SPR_MISF,1|FF_FULLBRIGHT,4,{NULL},S_MISSILEFLASH3},  // S_MISSILEFLASH2
  {SPR_MISF,2|FF_FULLBRIGHT,4,{.p2 = A_Light2},S_MISSILEFLASH4},  // S_MISSILEFLASH3
  {SPR_MISF,3|FF_FULLBRIGHT,4,{.p2 = A_Light2},S_LIGHTDONE},  // S_MISSILEFLASH4
  {SPR_SAWG,2,4,{.p2 = A_WeaponReady},S_SAWB},  // S_SAW
  {SPR_SAWG,3,4,{.p2 = A_WeaponReady},S_SAW}, // S_SAWB
  {SPR_SAWG,2,1,{.p2 = A_Lower},S_SAWDOWN}, // S_SAWDOWN
  {SPR_SAWG,2,1,{.p2 = A_Raise},S_SAWUP}, // S_SAWUP
  {SPR_SAWG,0,4,{.p2 = A_Saw},S_SAW2}, // S_SAW1
  {SPR_SAWG,1,4,{.p2 = A_Saw},S_SAW3},  // S_SAW2
  {SPR_SAWG,1,0,{.p2 = A_ReFire},S_SAW},  // S_SAW3
  {SPR_PLSG,0,1,{.p2 = A_WeaponReady},S_PLASMA},  // S_PLASMA
  {SPR_PLSG,0,1,{.p2 = A_Lower},S_PLASMADOWN},  // S_PLASMADOWN
  {SPR_PLSG,0,1,{.p2 = A_Raise},S_PLASMAUP},  // S_PLASMAUP
  {SPR_PLSG,0,3,{.p2 = A_FirePlasma},S_PLASMA2},  // S_PLASMA1
  {SPR_PLSG,1,20,{.p2 = A_ReFire},S_PLASMA},  // S_PLASMA2
  {SPR_PLSF,0|FF_FULLBRIGHT,4,{.p2 = A_Light1},S_LIGHTDONE},  // S_PLASMAFLASH1
  {SPR_PLSF,1|FF_FULLBRIGHT,4,{.p2 = A_Light1},S_LIGHTDONE},  // S_PLASMAFLASH2
  {SPR_BFGG,0,1,{.p2 = A_WeaponReady},S_BFG}, // S_BFG
  {SPR_BFGG,0,1,{.p2 = A_Lower},S_BFGDOWN}, // S_BFGDOWN
  {SPR_BFGG,0,1,{.p2 = A_Raise},S_BFGUP}, // S_BFGUP
  {SPR_BFGG,0,20,{.p2 = A_BFGsound},S_BFG2},  // S_BFG1
  {SPR_BFGG,1,10,{.p2 = A_GunFlash},S_BFG3},  // S_BFG2
  {SPR_BFGG,1,10,{.p2 = A_FireBFG},S_BFG4}, // S_BFG3
  {SPR_BFGG,1,20,{.p2 = A_ReFire},S_BFG}, // S_BFG4
  {SPR_BFGF,0|FF_FULLBRIGHT,11,{.p2 = A_Light1},S_BFGFLASH2}, // S_BFGFLASH1
  {SPR_BFGF,1|FF_FULLBRIGHT,6,{.p2 = A_Light2},S_LIGHTDONE},  // S_BFGFLASH2
  {SPR_BLUD,2,8,{NULL},S_BLOOD2}, // S_BLOOD1
  {SPR_BLUD,1,8,{NULL},S_BLOOD3}, // S_BLOOD2
  {SPR_BLUD,0,8,{NULL},S_NULL}, // S_BLOOD3
  {SPR_PUFF,0|FF_FULLBRIGHT,4,{NULL},S_PUFF2},  // S_PUFF1
  {SPR_PUFF,1,4,{NULL},S_PUFF3},  // S_PUFF2
  {SPR_PUFF,2,4,{NULL},S_PUFF4},  // S_PUFF3
  {SPR_PUFF,3,4,{NULL},S_NULL}, // S_PUFF4
  {SPR_BAL1,0|FF_FULLBRIGHT,4,{NULL},S_TBALL2}, // S_TBALL1
  {SPR_BAL1,1|FF_FULLBRIGHT,4,{NULL},S_TBALL1}, // S_TBALL2
  {SPR_BAL1,2|FF_FULLBRIGHT,6,{NULL},S_TBALLX2},  // S_TBALLX1
  {SPR_BAL1,3|FF_FULLBRIGHT,6,{NULL},S_TBALLX3},  // S_TBALLX2
  {SPR_BAL1,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_TBALLX3
  {SPR_BAL2,0|FF_FULLBRIGHT,4,{NULL},S_RBALL2}, // S_RBALL1
  {SPR_BAL2,1|FF_FULLBRIGHT,4,{NULL},S_RBALL1}, // S_RBALL2
  {SPR_BAL2,2|FF_FULLBRIGHT,6,{NULL},S_RBALLX2},  // S_RBALLX1
  {SPR_BAL2,3|FF_FULLBRIGHT,6,{NULL},S_RBALLX3},  // S_RBALLX2
  {SPR_BAL2,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_RBALLX3
  {SPR_PLSS,0|FF_FULLBRIGHT,6,{NULL},S_PLASBALL2},  // S_PLASBALL
  {SPR_PLSS,1|FF_FULLBRIGHT,6,{NULL},S_PLASBALL}, // S_PLASBALL2
  {SPR_PLSE,0|FF_FULLBRIGHT,4,{NULL},S_PLASEXP2}, // S_PLASEXP
  {SPR_PLSE,1|FF_FULLBRIGHT,4,{NULL},S_PLASEXP3}, // S_PLASEXP2
  {SPR_PLSE,2|FF_FULLBRIGHT,4,{NULL},S_PLASEXP4}, // S_PLASEXP3
  {SPR_PLSE,3|FF_FULLBRIGHT,4,{NULL},S_PLASEXP5}, // S_PLASEXP4
  {SPR_PLSE,4|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_PLASEXP5
  {SPR_MISL,0|FF_FULLBRIGHT,1,{NULL},S_ROCKET}, // S_ROCKET
  {SPR_BFS1,0|FF_FULLBRIGHT,4,{NULL},S_BFGSHOT2}, // S_BFGSHOT
  {SPR_BFS1,1|FF_FULLBRIGHT,4,{NULL},S_BFGSHOT},  // S_BFGSHOT2
  {SPR_BFE1,0|FF_FULLBRIGHT,8,{NULL},S_BFGLAND2}, // S_BFGLAND
  {SPR_BFE1,1|FF_FULLBRIGHT,8,{NULL},S_BFGLAND3}, // S_BFGLAND2
  {SPR_BFE1,2|FF_FULLBRIGHT,8,{.p1 = A_BFGSpray},S_BFGLAND4}, // S_BFGLAND3
  {SPR_BFE1,3|FF_FULLBRIGHT,8,{NULL},S_BFGLAND5}, // S_BFGLAND4
  {SPR_BFE1,4|FF_FULLBRIGHT,8,{NULL},S_BFGLAND6}, // S_BFGLAND5
  {SPR_BFE1,5|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_BFGLAND6
  {SPR_BFE2,0|FF_FULLBRIGHT,8,{NULL},S_BFGEXP2},  // S_BFGEXP
  {SPR_BFE2,1|FF_FULLBRIGHT,8,{NULL},S_BFGEXP3},  // S_BFGEXP2
  {SPR_BFE2,2|FF_FULLBRIGHT,8,{NULL},S_BFGEXP4},  // S_BFGEXP3
  {SPR_BFE2,3|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_BFGEXP4
  {SPR_MISL,1|FF_FULLBRIGHT,8,{.p1 = A_Explode},S_EXPLODE2},  // S_EXPLODE1
  {SPR_MISL,2|FF_FULLBRIGHT,6,{NULL},S_EXPLODE3}, // S_EXPLODE2
  {SPR_MISL,3|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_EXPLODE3
  {SPR_TFOG,0|FF_FULLBRIGHT,6,{NULL},S_TFOG01}, // S_TFOG
  {SPR_TFOG,1|FF_FULLBRIGHT,6,{NULL},S_TFOG02}, // S_TFOG01
  {SPR_TFOG,0|FF_FULLBRIGHT,6,{NULL},S_TFOG2},  // S_TFOG02
  {SPR_TFOG,1|FF_FULLBRIGHT,6,{NULL},S_TFOG3},  // S_TFOG2
  {SPR_TFOG,2|FF_FULLBRIGHT,6,{NULL},S_TFOG4},  // S_TFOG3
  {SPR_TFOG,3|FF_FULLBRIGHT,6,{NULL},S_TFOG5},  // S_TFOG4
  {SPR_TFOG,4|FF_FULLBRIGHT,6,{NULL},S_TFOG6},  // S_TFOG5
  {SPR_TFOG,5|FF_FULLBRIGHT,6,{NULL},S_TFOG7},  // S_TFOG6
  {SPR_TFOG,6|FF_FULLBRIGHT,6,{NULL},S_TFOG8},  // S_TFOG7
  {SPR_TFOG,7|FF_FULLBRIGHT,6,{NULL},S_TFOG9},  // S_TFOG8
  {SPR_TFOG,8|FF_FULLBRIGHT,6,{NULL},S_TFOG10}, // S_TFOG9
  {SPR_TFOG,9|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_TFOG10
  {SPR_IFOG,0|FF_FULLBRIGHT,6,{NULL},S_IFOG01}, // S_IFOG
  {SPR_IFOG,1|FF_FULLBRIGHT,6,{NULL},S_IFOG02}, // S_IFOG01
  {SPR_IFOG,0|FF_FULLBRIGHT,6,{NULL},S_IFOG2},  // S_IFOG02
  {SPR_IFOG,1|FF_FULLBRIGHT,6,{NULL},S_IFOG3},  // S_IFOG2
  {SPR_IFOG,2|FF_FULLBRIGHT,6,{NULL},S_IFOG4},  // S_IFOG3
  {SPR_IFOG,3|FF_FULLBRIGHT,6,{NULL},S_IFOG5},  // S_IFOG4
  {SPR_IFOG,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_IFOG5
  {SPR_PLAY,0,-1,{NULL},S_NULL},  // S_PLAY
  {SPR_PLAY,0,4,{NULL},S_PLAY_RUN2},  // S_PLAY_RUN1
  {SPR_PLAY,1,4,{NULL},S_PLAY_RUN3},  // S_PLAY_RUN2
  {SPR_PLAY,2,4,{NULL},S_PLAY_RUN4},  // S_PLAY_RUN3
  {SPR_PLAY,3,4,{NULL},S_PLAY_RUN1},  // S_PLAY_RUN4
  {SPR_PLAY,4,12,{NULL},S_PLAY},  // S_PLAY_ATK1
  {SPR_PLAY,5|FF_FULLBRIGHT,6,{NULL},S_PLAY_ATK1},  // S_PLAY_ATK2
  {SPR_PLAY,6,4,{NULL},S_PLAY_PAIN2}, // S_PLAY_PAIN
  {SPR_PLAY,6,4,{.p1 = A_Pain},S_PLAY}, // S_PLAY_PAIN2
  {SPR_PLAY,7,10,{NULL},S_PLAY_DIE2}, // S_PLAY_DIE1
  {SPR_PLAY,8,10,{.p1 = A_PlayerScream},S_PLAY_DIE3}, // S_PLAY_DIE2
  {SPR_PLAY,9,10,{.p1 = A_Fall},S_PLAY_DIE4}, // S_PLAY_DIE3
  {SPR_PLAY,10,10,{NULL},S_PLAY_DIE5},  // S_PLAY_DIE4
  {SPR_PLAY,11,10,{NULL},S_PLAY_DIE6},  // S_PLAY_DIE5
  {SPR_PLAY,12,10,{NULL},S_PLAY_DIE7},  // S_PLAY_DIE6
  {SPR_PLAY,13,-1,{NULL},S_NULL}, // S_PLAY_DIE7
  {SPR_PLAY,14,5,{NULL},S_PLAY_XDIE2},  // S_PLAY_XDIE1
  {SPR_PLAY,15,5,{.p1 = A_XScream},S_PLAY_XDIE3}, // S_PLAY_XDIE2
  {SPR_PLAY,16,5,{.p1 = A_Fall},S_PLAY_XDIE4},  // S_PLAY_XDIE3
  {SPR_PLAY,17,5,{NULL},S_PLAY_XDIE5},  // S_PLAY_XDIE4
  {SPR_PLAY,18,5,{NULL},S_PLAY_XDIE6},  // S_PLAY_XDIE5
  {SPR_PLAY,19,5,{NULL},S_PLAY_XDIE7},  // S_PLAY_XDIE6
  {SPR_PLAY,20,5,{NULL},S_PLAY_XDIE8},  // S_PLAY_XDIE7
  {SPR_PLAY,21,5,{NULL},S_PLAY_XDIE9},  // S_PLAY_XDIE8
  {SPR_PLAY,22,-1,{NULL},S_NULL}, // S_PLAY_XDIE9
  {SPR_POSS,0,10,{.p1 = A_Look},S_POSS_STND2},  // S_POSS_STND
  {SPR_POSS,1,10,{.p1 = A_Look},S_POSS_STND}, // S_POSS_STND2
  {SPR_POSS,0,4,{.p1 = A_Chase},S_POSS_RUN2}, // S_POSS_RUN1
  {SPR_POSS,0,4,{.p1 = A_Chase},S_POSS_RUN3}, // S_POSS_RUN2
  {SPR_POSS,1,4,{.p1 = A_Chase},S_POSS_RUN4}, // S_POSS_RUN3
  {SPR_POSS,1,4,{.p1 = A_Chase},S_POSS_RUN5}, // S_POSS_RUN4
  {SPR_POSS,2,4,{.p1 = A_Chase},S_POSS_RUN6}, // S_POSS_RUN5
  {SPR_POSS,2,4,{.p1 = A_Chase},S_POSS_RUN7}, // S_POSS_RUN6
  {SPR_POSS,3,4,{.p1 = A_Chase},S_POSS_RUN8}, // S_POSS_RUN7
  {SPR_POSS,3,4,{.p1 = A_Chase},S_POSS_RUN1}, // S_POSS_RUN8
  {SPR_POSS,4,10,{.p1 = A_FaceTarget},S_POSS_ATK2}, // S_POSS_ATK1
  {SPR_POSS,5,8,{.p1 = A_PosAttack},S_POSS_ATK3}, // S_POSS_ATK2
  {SPR_POSS,4,8,{NULL},S_POSS_RUN1},  // S_POSS_ATK3
  {SPR_POSS,6,3,{NULL},S_POSS_PAIN2}, // S_POSS_PAIN
  {SPR_POSS,6,3,{.p1 = A_Pain},S_POSS_RUN1},  // S_POSS_PAIN2
  {SPR_POSS,7,5,{NULL},S_POSS_DIE2},  // S_POSS_DIE1
  {SPR_POSS,8,5,{.p1 = A_Scream},S_POSS_DIE3},  // S_POSS_DIE2
  {SPR_POSS,9,5,{.p1 = A_Fall},S_POSS_DIE4},  // S_POSS_DIE3
  {SPR_POSS,10,5,{NULL},S_POSS_DIE5}, // S_POSS_DIE4
  {SPR_POSS,11,-1,{NULL},S_NULL}, // S_POSS_DIE5
  {SPR_POSS,12,5,{NULL},S_POSS_XDIE2},  // S_POSS_XDIE1
  {SPR_POSS,13,5,{.p1 = A_XScream},S_POSS_XDIE3}, // S_POSS_XDIE2
  {SPR_POSS,14,5,{.p1 = A_Fall},S_POSS_XDIE4},  // S_POSS_XDIE3
  {SPR_POSS,15,5,{NULL},S_POSS_XDIE5},  // S_POSS_XDIE4
  {SPR_POSS,16,5,{NULL},S_POSS_XDIE6},  // S_POSS_XDIE5
  {SPR_POSS,17,5,{NULL},S_POSS_XDIE7},  // S_POSS_XDIE6
  {SPR_POSS,18,5,{NULL},S_POSS_XDIE8},  // S_POSS_XDIE7
  {SPR_POSS,19,5,{NULL},S_POSS_XDIE9},  // S_POSS_XDIE8
  {SPR_POSS,20,-1,{NULL},S_NULL}, // S_POSS_XDIE9
  {SPR_POSS,10,5,{NULL},S_POSS_RAISE2}, // S_POSS_RAISE1
  {SPR_POSS,9,5,{NULL},S_POSS_RAISE3},  // S_POSS_RAISE2
  {SPR_POSS,8,5,{NULL},S_POSS_RAISE4},  // S_POSS_RAISE3
  {SPR_POSS,7,5,{NULL},S_POSS_RUN1},  // S_POSS_RAISE4
  {SPR_SPOS,0,10,{.p1 = A_Look},S_SPOS_STND2},  // S_SPOS_STND
  {SPR_SPOS,1,10,{.p1 = A_Look},S_SPOS_STND}, // S_SPOS_STND2
  {SPR_SPOS,0,3,{.p1 = A_Chase},S_SPOS_RUN2}, // S_SPOS_RUN1
  {SPR_SPOS,0,3,{.p1 = A_Chase},S_SPOS_RUN3}, // S_SPOS_RUN2
  {SPR_SPOS,1,3,{.p1 = A_Chase},S_SPOS_RUN4}, // S_SPOS_RUN3
  {SPR_SPOS,1,3,{.p1 = A_Chase},S_SPOS_RUN5}, // S_SPOS_RUN4
  {SPR_SPOS,2,3,{.p1 = A_Chase},S_SPOS_RUN6}, // S_SPOS_RUN5
  {SPR_SPOS,2,3,{.p1 = A_Chase},S_SPOS_RUN7}, // S_SPOS_RUN6
  {SPR_SPOS,3,3,{.p1 = A_Chase},S_SPOS_RUN8}, // S_SPOS_RUN7
  {SPR_SPOS,3,3,{.p1 = A_Chase},S_SPOS_RUN1}, // S_SPOS_RUN8
  {SPR_SPOS,4,10,{.p1 = A_FaceTarget},S_SPOS_ATK2}, // S_SPOS_ATK1
  {SPR_SPOS,5|FF_FULLBRIGHT,10,{.p1 = A_SPosAttack},S_SPOS_ATK3}, // S_SPOS_ATK2
  {SPR_SPOS,4,10,{NULL},S_SPOS_RUN1}, // S_SPOS_ATK3
  {SPR_SPOS,6,3,{NULL},S_SPOS_PAIN2}, // S_SPOS_PAIN
  {SPR_SPOS,6,3,{.p1 = A_Pain},S_SPOS_RUN1},  // S_SPOS_PAIN2
  {SPR_SPOS,7,5,{NULL},S_SPOS_DIE2},  // S_SPOS_DIE1
  {SPR_SPOS,8,5,{.p1 = A_Scream},S_SPOS_DIE3},  // S_SPOS_DIE2
  {SPR_SPOS,9,5,{.p1 = A_Fall},S_SPOS_DIE4},  // S_SPOS_DIE3
  {SPR_SPOS,10,5,{NULL},S_SPOS_DIE5}, // S_SPOS_DIE4
  {SPR_SPOS,11,-1,{NULL},S_NULL}, // S_SPOS_DIE5
  {SPR_SPOS,12,5,{NULL},S_SPOS_XDIE2},  // S_SPOS_XDIE1
  {SPR_SPOS,13,5,{.p1 = A_XScream},S_SPOS_XDIE3}, // S_SPOS_XDIE2
  {SPR_SPOS,14,5,{.p1 = A_Fall},S_SPOS_XDIE4},  // S_SPOS_XDIE3
  {SPR_SPOS,15,5,{NULL},S_SPOS_XDIE5},  // S_SPOS_XDIE4
  {SPR_SPOS,16,5,{NULL},S_SPOS_XDIE6},  // S_SPOS_XDIE5
  {SPR_SPOS,17,5,{NULL},S_SPOS_XDIE7},  // S_SPOS_XDIE6
  {SPR_SPOS,18,5,{NULL},S_SPOS_XDIE8},  // S_SPOS_XDIE7
  {SPR_SPOS,19,5,{NULL},S_SPOS_XDIE9},  // S_SPOS_XDIE8
  {SPR_SPOS,20,-1,{NULL},S_NULL}, // S_SPOS_XDIE9
  {SPR_SPOS,11,5,{NULL},S_SPOS_RAISE2}, // S_SPOS_RAISE1
  {SPR_SPOS,10,5,{NULL},S_SPOS_RAISE3}, // S_SPOS_RAISE2
  {SPR_SPOS,9,5,{NULL},S_SPOS_RAISE4},  // S_SPOS_RAISE3
  {SPR_SPOS,8,5,{NULL},S_SPOS_RAISE5},  // S_SPOS_RAISE4
  {SPR_SPOS,7,5,{NULL},S_SPOS_RUN1},  // S_SPOS_RAISE5
  {SPR_VILE,0,10,{.p1 = A_Look},S_VILE_STND2},  // S_VILE_STND
  {SPR_VILE,1,10,{.p1 = A_Look},S_VILE_STND}, // S_VILE_STND2
  {SPR_VILE,0,2,{.p1 = A_VileChase},S_VILE_RUN2}, // S_VILE_RUN1
  {SPR_VILE,0,2,{.p1 = A_VileChase},S_VILE_RUN3}, // S_VILE_RUN2
  {SPR_VILE,1,2,{.p1 = A_VileChase},S_VILE_RUN4}, // S_VILE_RUN3
  {SPR_VILE,1,2,{.p1 = A_VileChase},S_VILE_RUN5}, // S_VILE_RUN4
  {SPR_VILE,2,2,{.p1 = A_VileChase},S_VILE_RUN6}, // S_VILE_RUN5
  {SPR_VILE,2,2,{.p1 = A_VileChase},S_VILE_RUN7}, // S_VILE_RUN6
  {SPR_VILE,3,2,{.p1 = A_VileChase},S_VILE_RUN8}, // S_VILE_RUN7
  {SPR_VILE,3,2,{.p1 = A_VileChase},S_VILE_RUN9}, // S_VILE_RUN8
  {SPR_VILE,4,2,{.p1 = A_VileChase},S_VILE_RUN10},  // S_VILE_RUN9
  {SPR_VILE,4,2,{.p1 = A_VileChase},S_VILE_RUN11},  // S_VILE_RUN10
  {SPR_VILE,5,2,{.p1 = A_VileChase},S_VILE_RUN12},  // S_VILE_RUN11
  {SPR_VILE,5,2,{.p1 = A_VileChase},S_VILE_RUN1}, // S_VILE_RUN12
  {SPR_VILE,6|FF_FULLBRIGHT,0,{.p1 = A_VileStart},S_VILE_ATK2}, // S_VILE_ATK1
  {SPR_VILE,6|FF_FULLBRIGHT,10,{.p1 = A_FaceTarget},S_VILE_ATK3}, // S_VILE_ATK2
  {SPR_VILE,7|FF_FULLBRIGHT,8,{.p1 = A_VileTarget},S_VILE_ATK4},  // S_VILE_ATK3
  {SPR_VILE,8|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK5},  // S_VILE_ATK4
  {SPR_VILE,9|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK6},  // S_VILE_ATK5
  {SPR_VILE,10|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK7},  // S_VILE_ATK6
  {SPR_VILE,11|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK8},  // S_VILE_ATK7
  {SPR_VILE,12|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK9},  // S_VILE_ATK8
  {SPR_VILE,13|FF_FULLBRIGHT,8,{.p1 = A_FaceTarget},S_VILE_ATK10}, // S_VILE_ATK9
  {SPR_VILE,14|FF_FULLBRIGHT,8,{.p1 = A_VileAttack},S_VILE_ATK11}, // S_VILE_ATK10
  {SPR_VILE,15|FF_FULLBRIGHT,20,{NULL},S_VILE_RUN1}, // S_VILE_ATK11
  {SPR_VILE,26|FF_FULLBRIGHT,10,{NULL},S_VILE_HEAL2},  // S_VILE_HEAL1
  {SPR_VILE,27|FF_FULLBRIGHT,10,{NULL},S_VILE_HEAL3},  // S_VILE_HEAL2
  {SPR_VILE,28|FF_FULLBRIGHT,10,{NULL},S_VILE_RUN1}, // S_VILE_HEAL3
  {SPR_VILE,16,5,{NULL},S_VILE_PAIN2},  // S_VILE_PAIN
  {SPR_VILE,16,5,{.p1 = A_Pain},S_VILE_RUN1}, // S_VILE_PAIN2
  {SPR_VILE,16,7,{NULL},S_VILE_DIE2}, // S_VILE_DIE1
  {SPR_VILE,17,7,{.p1 = A_Scream},S_VILE_DIE3},  // S_VILE_DIE2
  {SPR_VILE,18,7,{.p1 = A_Fall},S_VILE_DIE4}, // S_VILE_DIE3
  {SPR_VILE,19,7,{NULL},S_VILE_DIE5}, // S_VILE_DIE4
  {SPR_VILE,20,7,{NULL},S_VILE_DIE6}, // S_VILE_DIE5
  {SPR_VILE,21,7,{NULL},S_VILE_DIE7}, // S_VILE_DIE6
  {SPR_VILE,22,7,{NULL},S_VILE_DIE8}, // S_VILE_DIE7
  {SPR_VILE,23,5,{NULL},S_VILE_DIE9}, // S_VILE_DIE8
  {SPR_VILE,24,5,{NULL},S_VILE_DIE10},  // S_VILE_DIE9
  {SPR_VILE,25,-1,{NULL},S_NULL}, // S_VILE_DIE10
  {SPR_FIRE,0|FF_FULLBRIGHT,2,{.p1 = A_StartFire},S_FIRE2}, // S_FIRE1
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE3},  // S_FIRE2
  {SPR_FIRE,0|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE4},  // S_FIRE3
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE5},  // S_FIRE4
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{.p1 = A_FireCrackle},S_FIRE6}, // S_FIRE5
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE7},  // S_FIRE6
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE8},  // S_FIRE7
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE9},  // S_FIRE8
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE10}, // S_FIRE9
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE11}, // S_FIRE10
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE12}, // S_FIRE11
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE13}, // S_FIRE12
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE14}, // S_FIRE13
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE15}, // S_FIRE14
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE16}, // S_FIRE15
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE17}, // S_FIRE16
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE18}, // S_FIRE17
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE19}, // S_FIRE18
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{.p1 = A_FireCrackle},S_FIRE20},  // S_FIRE19
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE21}, // S_FIRE20
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE22}, // S_FIRE21
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE23}, // S_FIRE22
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE24}, // S_FIRE23
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE25}, // S_FIRE24
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE26}, // S_FIRE25
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE27}, // S_FIRE26
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE28}, // S_FIRE27
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE29}, // S_FIRE28
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_FIRE30}, // S_FIRE29
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{.p1 = A_Fire},S_NULL}, // S_FIRE30
  {SPR_PUFF,1,4,{NULL},S_SMOKE2}, // S_SMOKE1
  {SPR_PUFF,2,4,{NULL},S_SMOKE3}, // S_SMOKE2
  {SPR_PUFF,1,4,{NULL},S_SMOKE4}, // S_SMOKE3
  {SPR_PUFF,2,4,{NULL},S_SMOKE5}, // S_SMOKE4
  {SPR_PUFF,3,4,{NULL},S_NULL}, // S_SMOKE5
  {SPR_FATB,0|FF_FULLBRIGHT,2,{.p1 = A_Tracer},S_TRACER2},  // S_TRACER
  {SPR_FATB,1|FF_FULLBRIGHT,2,{.p1 = A_Tracer},S_TRACER}, // S_TRACER2
  {SPR_FBXP,0|FF_FULLBRIGHT,8,{NULL},S_TRACEEXP2},  // S_TRACEEXP1
  {SPR_FBXP,1|FF_FULLBRIGHT,6,{NULL},S_TRACEEXP3},  // S_TRACEEXP2
  {SPR_FBXP,2|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_TRACEEXP3
  {SPR_SKEL,0,10,{.p1 = A_Look},S_SKEL_STND2},  // S_SKEL_STND
  {SPR_SKEL,1,10,{.p1 = A_Look},S_SKEL_STND}, // S_SKEL_STND2
  {SPR_SKEL,0,2,{.p1 = A_Chase},S_SKEL_RUN2}, // S_SKEL_RUN1
  {SPR_SKEL,0,2,{.p1 = A_Chase},S_SKEL_RUN3}, // S_SKEL_RUN2
  {SPR_SKEL,1,2,{.p1 = A_Chase},S_SKEL_RUN4}, // S_SKEL_RUN3
  {SPR_SKEL,1,2,{.p1 = A_Chase},S_SKEL_RUN5}, // S_SKEL_RUN4
  {SPR_SKEL,2,2,{.p1 = A_Chase},S_SKEL_RUN6}, // S_SKEL_RUN5
  {SPR_SKEL,2,2,{.p1 = A_Chase},S_SKEL_RUN7}, // S_SKEL_RUN6
  {SPR_SKEL,3,2,{.p1 = A_Chase},S_SKEL_RUN8}, // S_SKEL_RUN7
  {SPR_SKEL,3,2,{.p1 = A_Chase},S_SKEL_RUN9}, // S_SKEL_RUN8
  {SPR_SKEL,4,2,{.p1 = A_Chase},S_SKEL_RUN10},  // S_SKEL_RUN9
  {SPR_SKEL,4,2,{.p1 = A_Chase},S_SKEL_RUN11},  // S_SKEL_RUN10
  {SPR_SKEL,5,2,{.p1 = A_Chase},S_SKEL_RUN12},  // S_SKEL_RUN11
  {SPR_SKEL,5,2,{.p1 = A_Chase},S_SKEL_RUN1}, // S_SKEL_RUN12
  {SPR_SKEL,6,0,{.p1 = A_FaceTarget},S_SKEL_FIST2}, // S_SKEL_FIST1
  {SPR_SKEL,6,6,{.p1 = A_SkelWhoosh},S_SKEL_FIST3}, // S_SKEL_FIST2
  {SPR_SKEL,7,6,{.p1 = A_FaceTarget},S_SKEL_FIST4}, // S_SKEL_FIST3
  {SPR_SKEL,8,6,{.p1 = A_SkelFist},S_SKEL_RUN1},  // S_SKEL_FIST4
  {SPR_SKEL,9|FF_FULLBRIGHT,0,{.p1 = A_FaceTarget},S_SKEL_MISS2}, // S_SKEL_MISS1
  {SPR_SKEL,9|FF_FULLBRIGHT,10,{.p1 = A_FaceTarget},S_SKEL_MISS3},  // S_SKEL_MISS2
  {SPR_SKEL,10,10,{.p1 = A_SkelMissile},S_SKEL_MISS4},  // S_SKEL_MISS3
  {SPR_SKEL,10,10,{.p1 = A_FaceTarget},S_SKEL_RUN1},  // S_SKEL_MISS4
  {SPR_SKEL,11,5,{NULL},S_SKEL_PAIN2},  // S_SKEL_PAIN
  {SPR_SKEL,11,5,{.p1 = A_Pain},S_SKEL_RUN1}, // S_SKEL_PAIN2
  {SPR_SKEL,11,7,{NULL},S_SKEL_DIE2}, // S_SKEL_DIE1
  {SPR_SKEL,12,7,{NULL},S_SKEL_DIE3}, // S_SKEL_DIE2
  {SPR_SKEL,13,7,{.p1 = A_Scream},S_SKEL_DIE4}, // S_SKEL_DIE3
  {SPR_SKEL,14,7,{.p1 = A_Fall},S_SKEL_DIE5}, // S_SKEL_DIE4
  {SPR_SKEL,15,7,{NULL},S_SKEL_DIE6}, // S_SKEL_DIE5
  {SPR_SKEL,16,-1,{NULL},S_NULL}, // S_SKEL_DIE6
  {SPR_SKEL,16,5,{NULL},S_SKEL_RAISE2}, // S_SKEL_RAISE1
  {SPR_SKEL,15,5,{NULL},S_SKEL_RAISE3}, // S_SKEL_RAISE2
  {SPR_SKEL,14,5,{NULL},S_SKEL_RAISE4}, // S_SKEL_RAISE3
  {SPR_SKEL,13,5,{NULL},S_SKEL_RAISE5}, // S_SKEL_RAISE4
  {SPR_SKEL,12,5,{NULL},S_SKEL_RAISE6}, // S_SKEL_RAISE5
  {SPR_SKEL,11,5,{NULL},S_SKEL_RUN1}, // S_SKEL_RAISE6
  {SPR_MANF,0|FF_FULLBRIGHT,4,{NULL},S_FATSHOT2}, // S_FATSHOT1
  {SPR_MANF,1|FF_FULLBRIGHT,4,{NULL},S_FATSHOT1}, // S_FATSHOT2
  {SPR_MISL,1|FF_FULLBRIGHT,8,{NULL},S_FATSHOTX2},  // S_FATSHOTX1
  {SPR_MISL,2|FF_FULLBRIGHT,6,{NULL},S_FATSHOTX3},  // S_FATSHOTX2
  {SPR_MISL,3|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_FATSHOTX3
  {SPR_FATT,0,15,{.p1 = A_Look},S_FATT_STND2},  // S_FATT_STND
  {SPR_FATT,1,15,{.p1 = A_Look},S_FATT_STND}, // S_FATT_STND2
  {SPR_FATT,0,4,{.p1 = A_Chase},S_FATT_RUN2}, // S_FATT_RUN1
  {SPR_FATT,0,4,{.p1 = A_Chase},S_FATT_RUN3}, // S_FATT_RUN2
  {SPR_FATT,1,4,{.p1 = A_Chase},S_FATT_RUN4}, // S_FATT_RUN3
  {SPR_FATT,1,4,{.p1 = A_Chase},S_FATT_RUN5}, // S_FATT_RUN4
  {SPR_FATT,2,4,{.p1 = A_Chase},S_FATT_RUN6}, // S_FATT_RUN5
  {SPR_FATT,2,4,{.p1 = A_Chase},S_FATT_RUN7}, // S_FATT_RUN6
  {SPR_FATT,3,4,{.p1 = A_Chase},S_FATT_RUN8}, // S_FATT_RUN7
  {SPR_FATT,3,4,{.p1 = A_Chase},S_FATT_RUN9}, // S_FATT_RUN8
  {SPR_FATT,4,4,{.p1 = A_Chase},S_FATT_RUN10},  // S_FATT_RUN9
  {SPR_FATT,4,4,{.p1 = A_Chase},S_FATT_RUN11},  // S_FATT_RUN10
  {SPR_FATT,5,4,{.p1 = A_Chase},S_FATT_RUN12},  // S_FATT_RUN11
  {SPR_FATT,5,4,{.p1 = A_Chase},S_FATT_RUN1}, // S_FATT_RUN12
  {SPR_FATT,6,20,{.p1 = A_FatRaise},S_FATT_ATK2}, // S_FATT_ATK1
  {SPR_FATT,7|FF_FULLBRIGHT,10,{.p1 = A_FatAttack1},S_FATT_ATK3}, // S_FATT_ATK2
  {SPR_FATT,8,5,{.p1 = A_FaceTarget},S_FATT_ATK4},  // S_FATT_ATK3
  {SPR_FATT,6,5,{.p1 = A_FaceTarget},S_FATT_ATK5},  // S_FATT_ATK4
  {SPR_FATT,7|FF_FULLBRIGHT,10,{.p1 = A_FatAttack2},S_FATT_ATK6}, // S_FATT_ATK5
  {SPR_FATT,8,5,{.p1 = A_FaceTarget},S_FATT_ATK7},  // S_FATT_ATK6
  {SPR_FATT,6,5,{.p1 = A_FaceTarget},S_FATT_ATK8},  // S_FATT_ATK7
  {SPR_FATT,7|FF_FULLBRIGHT,10,{.p1 = A_FatAttack3},S_FATT_ATK9}, // S_FATT_ATK8
  {SPR_FATT,8,5,{.p1 = A_FaceTarget},S_FATT_ATK10}, // S_FATT_ATK9
  {SPR_FATT,6,5,{.p1 = A_FaceTarget},S_FATT_RUN1},  // S_FATT_ATK10
  {SPR_FATT,9,3,{NULL},S_FATT_PAIN2}, // S_FATT_PAIN
  {SPR_FATT,9,3,{.p1 = A_Pain},S_FATT_RUN1},  // S_FATT_PAIN2
  {SPR_FATT,10,6,{NULL},S_FATT_DIE2}, // S_FATT_DIE1
  {SPR_FATT,11,6,{.p1 = A_Scream},S_FATT_DIE3}, // S_FATT_DIE2
  {SPR_FATT,12,6,{.p1 = A_Fall},S_FATT_DIE4}, // S_FATT_DIE3
  {SPR_FATT,13,6,{NULL},S_FATT_DIE5}, // S_FATT_DIE4
  {SPR_FATT,14,6,{NULL},S_FATT_DIE6}, // S_FATT_DIE5
  {SPR_FATT,15,6,{NULL},S_FATT_DIE7}, // S_FATT_DIE6
  {SPR_FATT,16,6,{NULL},S_FATT_DIE8}, // S_FATT_DIE7
  {SPR_FATT,17,6,{NULL},S_FATT_DIE9}, // S_FATT_DIE8
  {SPR_FATT,18,6,{NULL},S_FATT_DIE10},  // S_FATT_DIE9
  {SPR_FATT,19,-1,{.p1 = A_BossDeath},S_NULL},  // S_FATT_DIE10
  {SPR_FATT,17,5,{NULL},S_FATT_RAISE2}, // S_FATT_RAISE1
  {SPR_FATT,16,5,{NULL},S_FATT_RAISE3}, // S_FATT_RAISE2
  {SPR_FATT,15,5,{NULL},S_FATT_RAISE4}, // S_FATT_RAISE3
  {SPR_FATT,14,5,{NULL},S_FATT_RAISE5}, // S_FATT_RAISE4
  {SPR_FATT,13,5,{NULL},S_FATT_RAISE6}, // S_FATT_RAISE5
  {SPR_FATT,12,5,{NULL},S_FATT_RAISE7}, // S_FATT_RAISE6
  {SPR_FATT,11,5,{NULL},S_FATT_RAISE8}, // S_FATT_RAISE7
  {SPR_FATT,10,5,{NULL},S_FATT_RUN1}, // S_FATT_RAISE8
  {SPR_CPOS,0,10,{.p1 = A_Look},S_CPOS_STND2},  // S_CPOS_STND
  {SPR_CPOS,1,10,{.p1 = A_Look},S_CPOS_STND}, // S_CPOS_STND2
  {SPR_CPOS,0,3,{.p1 = A_Chase},S_CPOS_RUN2}, // S_CPOS_RUN1
  {SPR_CPOS,0,3,{.p1 = A_Chase},S_CPOS_RUN3}, // S_CPOS_RUN2
  {SPR_CPOS,1,3,{.p1 = A_Chase},S_CPOS_RUN4}, // S_CPOS_RUN3
  {SPR_CPOS,1,3,{.p1 = A_Chase},S_CPOS_RUN5}, // S_CPOS_RUN4
  {SPR_CPOS,2,3,{.p1 = A_Chase},S_CPOS_RUN6}, // S_CPOS_RUN5
  {SPR_CPOS,2,3,{.p1 = A_Chase},S_CPOS_RUN7}, // S_CPOS_RUN6
  {SPR_CPOS,3,3,{.p1 = A_Chase},S_CPOS_RUN8}, // S_CPOS_RUN7
  {SPR_CPOS,3,3,{.p1 = A_Chase},S_CPOS_RUN1}, // S_CPOS_RUN8
  {SPR_CPOS,4,10,{.p1 = A_FaceTarget},S_CPOS_ATK2}, // S_CPOS_ATK1
  {SPR_CPOS,5|FF_FULLBRIGHT,4,{.p1 = A_CPosAttack},S_CPOS_ATK3},  // S_CPOS_ATK2
  {SPR_CPOS,4|FF_FULLBRIGHT,4,{.p1 = A_CPosAttack},S_CPOS_ATK4},  // S_CPOS_ATK3
  {SPR_CPOS,5,1,{.p1 = A_CPosRefire},S_CPOS_ATK2},  // S_CPOS_ATK4
  {SPR_CPOS,6,3,{NULL},S_CPOS_PAIN2}, // S_CPOS_PAIN
  {SPR_CPOS,6,3,{.p1 = A_Pain},S_CPOS_RUN1},  // S_CPOS_PAIN2
  {SPR_CPOS,7,5,{NULL},S_CPOS_DIE2},  // S_CPOS_DIE1
  {SPR_CPOS,8,5,{.p1 = A_Scream},S_CPOS_DIE3},  // S_CPOS_DIE2
  {SPR_CPOS,9,5,{.p1 = A_Fall},S_CPOS_DIE4},  // S_CPOS_DIE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_DIE5}, // S_CPOS_DIE4
  {SPR_CPOS,11,5,{NULL},S_CPOS_DIE6}, // S_CPOS_DIE5
  {SPR_CPOS,12,5,{NULL},S_CPOS_DIE7}, // S_CPOS_DIE6
  {SPR_CPOS,13,-1,{NULL},S_NULL}, // S_CPOS_DIE7
  {SPR_CPOS,14,5,{NULL},S_CPOS_XDIE2},  // S_CPOS_XDIE1
  {SPR_CPOS,15,5,{.p1 = A_XScream},S_CPOS_XDIE3}, // S_CPOS_XDIE2
  {SPR_CPOS,16,5,{.p1 = A_Fall},S_CPOS_XDIE4},  // S_CPOS_XDIE3
  {SPR_CPOS,17,5,{NULL},S_CPOS_XDIE5},  // S_CPOS_XDIE4
  {SPR_CPOS,18,5,{NULL},S_CPOS_XDIE6},  // S_CPOS_XDIE5
  {SPR_CPOS,19,-1,{NULL},S_NULL}, // S_CPOS_XDIE6
  {SPR_CPOS,13,5,{NULL},S_CPOS_RAISE2}, // S_CPOS_RAISE1
  {SPR_CPOS,12,5,{NULL},S_CPOS_RAISE3}, // S_CPOS_RAISE2
  {SPR_CPOS,11,5,{NULL},S_CPOS_RAISE4}, // S_CPOS_RAISE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_RAISE5}, // S_CPOS_RAISE4
  {SPR_CPOS,9,5,{NULL},S_CPOS_RAISE6},  // S_CPOS_RAISE5
  {SPR_CPOS,8,5,{NULL},S_CPOS_RAISE7},  // S_CPOS_RAISE6
  {SPR_CPOS,7,5,{NULL},S_CPOS_RUN1},  // S_CPOS_RAISE7
  {SPR_TROO,0,10,{.p1 = A_Look},S_TROO_STND2},  // S_TROO_STND
  {SPR_TROO,1,10,{.p1 = A_Look},S_TROO_STND}, // S_TROO_STND2
  {SPR_TROO,0,3,{.p1 = A_Chase},S_TROO_RUN2}, // S_TROO_RUN1
  {SPR_TROO,0,3,{.p1 = A_Chase},S_TROO_RUN3}, // S_TROO_RUN2
  {SPR_TROO,1,3,{.p1 = A_Chase},S_TROO_RUN4}, // S_TROO_RUN3
  {SPR_TROO,1,3,{.p1 = A_Chase},S_TROO_RUN5}, // S_TROO_RUN4
  {SPR_TROO,2,3,{.p1 = A_Chase},S_TROO_RUN6}, // S_TROO_RUN5
  {SPR_TROO,2,3,{.p1 = A_Chase},S_TROO_RUN7}, // S_TROO_RUN6
  {SPR_TROO,3,3,{.p1 = A_Chase},S_TROO_RUN8}, // S_TROO_RUN7
  {SPR_TROO,3,3,{.p1 = A_Chase},S_TROO_RUN1}, // S_TROO_RUN8
  {SPR_TROO,4,8,{.p1 = A_FaceTarget},S_TROO_ATK2},  // S_TROO_ATK1
  {SPR_TROO,5,8,{.p1 = A_FaceTarget},S_TROO_ATK3},  // S_TROO_ATK2
  {SPR_TROO,6,6,{.p1 = A_TroopAttack},S_TROO_RUN1}, // S_TROO_ATK3
  {SPR_TROO,7,2,{NULL},S_TROO_PAIN2}, // S_TROO_PAIN
  {SPR_TROO,7,2,{.p1 = A_Pain},S_TROO_RUN1},  // S_TROO_PAIN2
  {SPR_TROO,8,8,{NULL},S_TROO_DIE2},  // S_TROO_DIE1
  {SPR_TROO,9,8,{.p1 = A_Scream},S_TROO_DIE3},  // S_TROO_DIE2
  {SPR_TROO,10,6,{NULL},S_TROO_DIE4}, // S_TROO_DIE3
  {SPR_TROO,11,6,{.p1 = A_Fall},S_TROO_DIE5}, // S_TROO_DIE4
  {SPR_TROO,12,-1,{NULL},S_NULL}, // S_TROO_DIE5
  {SPR_TROO,13,5,{NULL},S_TROO_XDIE2},  // S_TROO_XDIE1
  {SPR_TROO,14,5,{.p1 = A_XScream},S_TROO_XDIE3}, // S_TROO_XDIE2
  {SPR_TROO,15,5,{NULL},S_TROO_XDIE4},  // S_TROO_XDIE3
  {SPR_TROO,16,5,{.p1 = A_Fall},S_TROO_XDIE5},  // S_TROO_XDIE4
  {SPR_TROO,17,5,{NULL},S_TROO_XDIE6},  // S_TROO_XDIE5
  {SPR_TROO,18,5,{NULL},S_TROO_XDIE7},  // S_TROO_XDIE6
  {SPR_TROO,19,5,{NULL},S_TROO_XDIE8},  // S_TROO_XDIE7
  {SPR_TROO,20,-1,{NULL},S_NULL}, // S_TROO_XDIE8
  {SPR_TROO,12,8,{NULL},S_TROO_RAISE2}, // S_TROO_RAISE1
  {SPR_TROO,11,8,{NULL},S_TROO_RAISE3}, // S_TROO_RAISE2
  {SPR_TROO,10,6,{NULL},S_TROO_RAISE4}, // S_TROO_RAISE3
  {SPR_TROO,9,6,{NULL},S_TROO_RAISE5},  // S_TROO_RAISE4
  {SPR_TROO,8,6,{NULL},S_TROO_RUN1},  // S_TROO_RAISE5
  {SPR_SARG,0,10,{.p1 = A_Look},S_SARG_STND2},  // S_SARG_STND
  {SPR_SARG,1,10,{.p1 = A_Look},S_SARG_STND}, // S_SARG_STND2
  {SPR_SARG,0,2,{.p1 = A_Chase},S_SARG_RUN2}, // S_SARG_RUN1
  {SPR_SARG,0,2,{.p1 = A_Chase},S_SARG_RUN3}, // S_SARG_RUN2
  {SPR_SARG,1,2,{.p1 = A_Chase},S_SARG_RUN4}, // S_SARG_RUN3
  {SPR_SARG,1,2,{.p1 = A_Chase},S_SARG_RUN5}, // S_SARG_RUN4
  {SPR_SARG,2,2,{.p1 = A_Chase},S_SARG_RUN6}, // S_SARG_RUN5
  {SPR_SARG,2,2,{.p1 = A_Chase},S_SARG_RUN7}, // S_SARG_RUN6
  {SPR_SARG,3,2,{.p1 = A_Chase},S_SARG_RUN8}, // S_SARG_RUN7
  {SPR_SARG,3,2,{.p1 = A_Chase},S_SARG_RUN1}, // S_SARG_RUN8
  {SPR_SARG,4,8,{.p1 = A_FaceTarget},S_SARG_ATK2},  // S_SARG_ATK1
  {SPR_SARG,5,8,{.p1 = A_FaceTarget},S_SARG_ATK3},  // S_SARG_ATK2
  {SPR_SARG,6,8,{.p1 = A_SargAttack},S_SARG_RUN1},  // S_SARG_ATK3
  {SPR_SARG,7,2,{NULL},S_SARG_PAIN2}, // S_SARG_PAIN
  {SPR_SARG,7,2,{.p1 = A_Pain},S_SARG_RUN1},  // S_SARG_PAIN2
  {SPR_SARG,8,8,{NULL},S_SARG_DIE2},  // S_SARG_DIE1
  {SPR_SARG,9,8,{.p1 = A_Scream},S_SARG_DIE3},  // S_SARG_DIE2
  {SPR_SARG,10,4,{NULL},S_SARG_DIE4}, // S_SARG_DIE3
  {SPR_SARG,11,4,{.p1 = A_Fall},S_SARG_DIE5}, // S_SARG_DIE4
  {SPR_SARG,12,4,{NULL},S_SARG_DIE6}, // S_SARG_DIE5
  {SPR_SARG,13,-1,{NULL},S_NULL}, // S_SARG_DIE6
  {SPR_SARG,13,5,{NULL},S_SARG_RAISE2}, // S_SARG_RAISE1
  {SPR_SARG,12,5,{NULL},S_SARG_RAISE3}, // S_SARG_RAISE2
  {SPR_SARG,11,5,{NULL},S_SARG_RAISE4}, // S_SARG_RAISE3
  {SPR_SARG,10,5,{NULL},S_SARG_RAISE5}, // S_SARG_RAISE4
  {SPR_SARG,9,5,{NULL},S_SARG_RAISE6},  // S_SARG_RAISE5
  {SPR_SARG,8,5,{NULL},S_SARG_RUN1},  // S_SARG_RAISE6
  {SPR_HEAD,0,10,{.p1 = A_Look},S_HEAD_STND}, // S_HEAD_STND
  {SPR_HEAD,0,3,{.p1 = A_Chase},S_HEAD_RUN1}, // S_HEAD_RUN1
  {SPR_HEAD,1,5,{.p1 = A_FaceTarget},S_HEAD_ATK2},  // S_HEAD_ATK1
  {SPR_HEAD,2,5,{.p1 = A_FaceTarget},S_HEAD_ATK3},  // S_HEAD_ATK2
  {SPR_HEAD,3|FF_FULLBRIGHT,5,{.p1 = A_HeadAttack},S_HEAD_RUN1},  // S_HEAD_ATK3
  {SPR_HEAD,4,3,{NULL},S_HEAD_PAIN2}, // S_HEAD_PAIN
  {SPR_HEAD,4,3,{.p1 = A_Pain},S_HEAD_PAIN3}, // S_HEAD_PAIN2
  {SPR_HEAD,5,6,{NULL},S_HEAD_RUN1},  // S_HEAD_PAIN3
  {SPR_HEAD,6,8,{NULL},S_HEAD_DIE2},  // S_HEAD_DIE1
  {SPR_HEAD,7,8,{.p1 = A_Scream},S_HEAD_DIE3},  // S_HEAD_DIE2
  {SPR_HEAD,8,8,{NULL},S_HEAD_DIE4},  // S_HEAD_DIE3
  {SPR_HEAD,9,8,{NULL},S_HEAD_DIE5},  // S_HEAD_DIE4
  {SPR_HEAD,10,8,{.p1 = A_Fall},S_HEAD_DIE6}, // S_HEAD_DIE5
  {SPR_HEAD,11,-1,{NULL},S_NULL}, // S_HEAD_DIE6
  {SPR_HEAD,11,8,{NULL},S_HEAD_RAISE2}, // S_HEAD_RAISE1
  {SPR_HEAD,10,8,{NULL},S_HEAD_RAISE3}, // S_HEAD_RAISE2
  {SPR_HEAD,9,8,{NULL},S_HEAD_RAISE4},  // S_HEAD_RAISE3
  {SPR_HEAD,8,8,{NULL},S_HEAD_RAISE5},  // S_HEAD_RAISE4
  {SPR_HEAD,7,8,{NULL},S_HEAD_RAISE6},  // S_HEAD_RAISE5
  {SPR_HEAD,6,8,{NULL},S_HEAD_RUN1},  // S_HEAD_RAISE6
  {SPR_BAL7,0|FF_FULLBRIGHT,4,{NULL},S_BRBALL2},  // S_BRBALL1
  {SPR_BAL7,1|FF_FULLBRIGHT,4,{NULL},S_BRBALL1},  // S_BRBALL2
  {SPR_BAL7,2|FF_FULLBRIGHT,6,{NULL},S_BRBALLX2}, // S_BRBALLX1
  {SPR_BAL7,3|FF_FULLBRIGHT,6,{NULL},S_BRBALLX3}, // S_BRBALLX2
  {SPR_BAL7,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_BRBALLX3
  {SPR_BOSS,0,10,{.p1 = A_Look},S_BOSS_STND2},  // S_BOSS_STND
  {SPR_BOSS,1,10,{.p1 = A_Look},S_BOSS_STND}, // S_BOSS_STND2
  {SPR_BOSS,0,3,{.p1 = A_Chase},S_BOSS_RUN2}, // S_BOSS_RUN1
  {SPR_BOSS,0,3,{.p1 = A_Chase},S_BOSS_RUN3}, // S_BOSS_RUN2
  {SPR_BOSS,1,3,{.p1 = A_Chase},S_BOSS_RUN4}, // S_BOSS_RUN3
  {SPR_BOSS,1,3,{.p1 = A_Chase},S_BOSS_RUN5}, // S_BOSS_RUN4
  {SPR_BOSS,2,3,{.p1 = A_Chase},S_BOSS_RUN6}, // S_BOSS_RUN5
  {SPR_BOSS,2,3,{.p1 = A_Chase},S_BOSS_RUN7}, // S_BOSS_RUN6
  {SPR_BOSS,3,3,{.p1 = A_Chase},S_BOSS_RUN8}, // S_BOSS_RUN7
  {SPR_BOSS,3,3,{.p1 = A_Chase},S_BOSS_RUN1}, // S_BOSS_RUN8
  {SPR_BOSS,4,8,{.p1 = A_FaceTarget},S_BOSS_ATK2},  // S_BOSS_ATK1
  {SPR_BOSS,5,8,{.p1 = A_FaceTarget},S_BOSS_ATK3},  // S_BOSS_ATK2
  {SPR_BOSS,6,8,{.p1 = A_BruisAttack},S_BOSS_RUN1}, // S_BOSS_ATK3
  {SPR_BOSS,7,2,{NULL},S_BOSS_PAIN2}, // S_BOSS_PAIN
  {SPR_BOSS,7,2,{.p1 = A_Pain},S_BOSS_RUN1},  // S_BOSS_PAIN2
  {SPR_BOSS,8,8,{NULL},S_BOSS_DIE2},  // S_BOSS_DIE1
  {SPR_BOSS,9,8,{.p1 = A_Scream},S_BOSS_DIE3},  // S_BOSS_DIE2
  {SPR_BOSS,10,8,{NULL},S_BOSS_DIE4}, // S_BOSS_DIE3
  {SPR_BOSS,11,8,{.p1 = A_Fall},S_BOSS_DIE5}, // S_BOSS_DIE4
  {SPR_BOSS,12,8,{NULL},S_BOSS_DIE6}, // S_BOSS_DIE5
  {SPR_BOSS,13,8,{NULL},S_BOSS_DIE7}, // S_BOSS_DIE6
  {SPR_BOSS,14,-1,{.p1 = A_BossDeath},S_NULL},  // S_BOSS_DIE7
  {SPR_BOSS,14,8,{NULL},S_BOSS_RAISE2}, // S_BOSS_RAISE1
  {SPR_BOSS,13,8,{NULL},S_BOSS_RAISE3}, // S_BOSS_RAISE2
  {SPR_BOSS,12,8,{NULL},S_BOSS_RAISE4}, // S_BOSS_RAISE3
  {SPR_BOSS,11,8,{NULL},S_BOSS_RAISE5}, // S_BOSS_RAISE4
  {SPR_BOSS,10,8,{NULL},S_BOSS_RAISE6}, // S_BOSS_RAISE5
  {SPR_BOSS,9,8,{NULL},S_BOSS_RAISE7},  // S_BOSS_RAISE6
  {SPR_BOSS,8,8,{NULL},S_BOSS_RUN1},  // S_BOSS_RAISE7
  {SPR_BOS2,0,10,{.p1 = A_Look},S_BOS2_STND2},  // S_BOS2_STND
  {SPR_BOS2,1,10,{.p1 = A_Look},S_BOS2_STND}, // S_BOS2_STND2
  {SPR_BOS2,0,3,{.p1 = A_Chase},S_BOS2_RUN2}, // S_BOS2_RUN1
  {SPR_BOS2,0,3,{.p1 = A_Chase},S_BOS2_RUN3}, // S_BOS2_RUN2
  {SPR_BOS2,1,3,{.p1 = A_Chase},S_BOS2_RUN4}, // S_BOS2_RUN3
  {SPR_BOS2,1,3,{.p1 = A_Chase},S_BOS2_RUN5}, // S_BOS2_RUN4
  {SPR_BOS2,2,3,{.p1 = A_Chase},S_BOS2_RUN6}, // S_BOS2_RUN5
  {SPR_BOS2,2,3,{.p1 = A_Chase},S_BOS2_RUN7}, // S_BOS2_RUN6
  {SPR_BOS2,3,3,{.p1 = A_Chase},S_BOS2_RUN8}, // S_BOS2_RUN7
  {SPR_BOS2,3,3,{.p1 = A_Chase},S_BOS2_RUN1}, // S_BOS2_RUN8
  {SPR_BOS2,4,8,{.p1 = A_FaceTarget},S_BOS2_ATK2},  // S_BOS2_ATK1
  {SPR_BOS2,5,8,{.p1 = A_FaceTarget},S_BOS2_ATK3},  // S_BOS2_ATK2
  {SPR_BOS2,6,8,{.p1 = A_BruisAttack},S_BOS2_RUN1}, // S_BOS2_ATK3
  {SPR_BOS2,7,2,{NULL},S_BOS2_PAIN2}, // S_BOS2_PAIN
  {SPR_BOS2,7,2,{.p1 = A_Pain},S_BOS2_RUN1},  // S_BOS2_PAIN2
  {SPR_BOS2,8,8,{NULL},S_BOS2_DIE2},  // S_BOS2_DIE1
  {SPR_BOS2,9,8,{.p1 = A_Scream},S_BOS2_DIE3},  // S_BOS2_DIE2
  {SPR_BOS2,10,8,{NULL},S_BOS2_DIE4}, // S_BOS2_DIE3
  {SPR_BOS2,11,8,{.p1 = A_Fall},S_BOS2_DIE5}, // S_BOS2_DIE4
  {SPR_BOS2,12,8,{NULL},S_BOS2_DIE6}, // S_BOS2_DIE5
  {SPR_BOS2,13,8,{NULL},S_BOS2_DIE7}, // S_BOS2_DIE6
  {SPR_BOS2,14,-1,{NULL},S_NULL}, // S_BOS2_DIE7
  {SPR_BOS2,14,8,{NULL},S_BOS2_RAISE2}, // S_BOS2_RAISE1
  {SPR_BOS2,13,8,{NULL},S_BOS2_RAISE3}, // S_BOS2_RAISE2
  {SPR_BOS2,12,8,{NULL},S_BOS2_RAISE4}, // S_BOS2_RAISE3
  {SPR_BOS2,11,8,{NULL},S_BOS2_RAISE5}, // S_BOS2_RAISE4
  {SPR_BOS2,10,8,{NULL},S_BOS2_RAISE6}, // S_BOS2_RAISE5
  {SPR_BOS2,9,8,{NULL},S_BOS2_RAISE7},  // S_BOS2_RAISE6
  {SPR_BOS2,8,8,{NULL},S_BOS2_RUN1},  // S_BOS2_RAISE7
  {SPR_SKUL,0|FF_FULLBRIGHT,10,{.p1 = A_Look},S_SKULL_STND2}, // S_SKULL_STND
  {SPR_SKUL,1|FF_FULLBRIGHT,10,{.p1 = A_Look},S_SKULL_STND},  // S_SKULL_STND2
  {SPR_SKUL,0|FF_FULLBRIGHT,6,{.p1 = A_Chase},S_SKULL_RUN2},  // S_SKULL_RUN1
  {SPR_SKUL,1|FF_FULLBRIGHT,6,{.p1 = A_Chase},S_SKULL_RUN1},  // S_SKULL_RUN2
  {SPR_SKUL,2|FF_FULLBRIGHT,10,{.p1 = A_FaceTarget},S_SKULL_ATK2},  // S_SKULL_ATK1
  {SPR_SKUL,3|FF_FULLBRIGHT,4,{.p1 = A_SkullAttack},S_SKULL_ATK3},  // S_SKULL_ATK2
  {SPR_SKUL,2|FF_FULLBRIGHT,4,{NULL},S_SKULL_ATK4}, // S_SKULL_ATK3
  {SPR_SKUL,3|FF_FULLBRIGHT,4,{NULL},S_SKULL_ATK3}, // S_SKULL_ATK4
  {SPR_SKUL,4|FF_FULLBRIGHT,3,{NULL},S_SKULL_PAIN2},  // S_SKULL_PAIN
  {SPR_SKUL,4|FF_FULLBRIGHT,3,{.p1 = A_Pain},S_SKULL_RUN1}, // S_SKULL_PAIN2
  {SPR_SKUL,5|FF_FULLBRIGHT,6,{NULL},S_SKULL_DIE2}, // S_SKULL_DIE1
  {SPR_SKUL,6|FF_FULLBRIGHT,6,{.p1 = A_Scream},S_SKULL_DIE3}, // S_SKULL_DIE2
  {SPR_SKUL,7|FF_FULLBRIGHT,6,{NULL},S_SKULL_DIE4}, // S_SKULL_DIE3
  {SPR_SKUL,8|FF_FULLBRIGHT,6,{.p1 = A_Fall},S_SKULL_DIE5}, // S_SKULL_DIE4
  {SPR_SKUL,9,6,{NULL},S_SKULL_DIE6}, // S_SKULL_DIE5
  {SPR_SKUL,10,6,{NULL},S_NULL},  // S_SKULL_DIE6
  {SPR_SPID,0,10,{.p1 = A_Look},S_SPID_STND2},  // S_SPID_STND
  {SPR_SPID,1,10,{.p1 = A_Look},S_SPID_STND}, // S_SPID_STND2
  {SPR_SPID,0,3,{.p1 = A_Metal},S_SPID_RUN2}, // S_SPID_RUN1
  {SPR_SPID,0,3,{.p1 = A_Chase},S_SPID_RUN3}, // S_SPID_RUN2
  {SPR_SPID,1,3,{.p1 = A_Chase},S_SPID_RUN4}, // S_SPID_RUN3
  {SPR_SPID,1,3,{.p1 = A_Chase},S_SPID_RUN5}, // S_SPID_RUN4
  {SPR_SPID,2,3,{.p1 = A_Metal},S_SPID_RUN6}, // S_SPID_RUN5
  {SPR_SPID,2,3,{.p1 = A_Chase},S_SPID_RUN7}, // S_SPID_RUN6
  {SPR_SPID,3,3,{.p1 = A_Chase},S_SPID_RUN8}, // S_SPID_RUN7
  {SPR_SPID,3,3,{.p1 = A_Chase},S_SPID_RUN9}, // S_SPID_RUN8
  {SPR_SPID,4,3,{.p1 = A_Metal},S_SPID_RUN10},  // S_SPID_RUN9
  {SPR_SPID,4,3,{.p1 = A_Chase},S_SPID_RUN11},  // S_SPID_RUN10
  {SPR_SPID,5,3,{.p1 = A_Chase},S_SPID_RUN12},  // S_SPID_RUN11
  {SPR_SPID,5,3,{.p1 = A_Chase},S_SPID_RUN1}, // S_SPID_RUN12
  {SPR_SPID,0|FF_FULLBRIGHT,20,{.p1 = A_FaceTarget},S_SPID_ATK2}, // S_SPID_ATK1
  {SPR_SPID,6|FF_FULLBRIGHT,4,{.p1 = A_SPosAttack},S_SPID_ATK3},  // S_SPID_ATK2
  {SPR_SPID,7|FF_FULLBRIGHT,4,{.p1 = A_SPosAttack},S_SPID_ATK4},  // S_SPID_ATK3
  {SPR_SPID,7|FF_FULLBRIGHT,1,{.p1 = A_SpidRefire},S_SPID_ATK2},  // S_SPID_ATK4
  {SPR_SPID,8,3,{NULL},S_SPID_PAIN2}, // S_SPID_PAIN
  {SPR_SPID,8,3,{.p1 = A_Pain},S_SPID_RUN1},  // S_SPID_PAIN2
  {SPR_SPID,9,20,{.p1 = A_Scream},S_SPID_DIE2}, // S_SPID_DIE1
  {SPR_SPID,10,10,{.p1 = A_Fall},S_SPID_DIE3},  // S_SPID_DIE2
  {SPR_SPID,11,10,{NULL},S_SPID_DIE4},  // S_SPID_DIE3
  {SPR_SPID,12,10,{NULL},S_SPID_DIE5},  // S_SPID_DIE4
  {SPR_SPID,13,10,{NULL},S_SPID_DIE6},  // S_SPID_DIE5
  {SPR_SPID,14,10,{NULL},S_SPID_DIE7},  // S_SPID_DIE6
  {SPR_SPID,15,10,{NULL},S_SPID_DIE8},  // S_SPID_DIE7
  {SPR_SPID,16,10,{NULL},S_SPID_DIE9},  // S_SPID_DIE8
  {SPR_SPID,17,10,{NULL},S_SPID_DIE10}, // S_SPID_DIE9
  {SPR_SPID,18,30,{NULL},S_SPID_DIE11}, // S_SPID_DIE10
  {SPR_SPID,18,-1,{.p1 = A_BossDeath},S_NULL},  // S_SPID_DIE11
  {SPR_BSPI,0,10,{.p1 = A_Look},S_BSPI_STND2},  // S_BSPI_STND
  {SPR_BSPI,1,10,{.p1 = A_Look},S_BSPI_STND}, // S_BSPI_STND2
  {SPR_BSPI,0,20,{NULL},S_BSPI_RUN1}, // S_BSPI_SIGHT
  {SPR_BSPI,0,3,{.p1 = A_BabyMetal},S_BSPI_RUN2}, // S_BSPI_RUN1
  {SPR_BSPI,0,3,{.p1 = A_Chase},S_BSPI_RUN3}, // S_BSPI_RUN2
  {SPR_BSPI,1,3,{.p1 = A_Chase},S_BSPI_RUN4}, // S_BSPI_RUN3
  {SPR_BSPI,1,3,{.p1 = A_Chase},S_BSPI_RUN5}, // S_BSPI_RUN4
  {SPR_BSPI,2,3,{.p1 = A_Chase},S_BSPI_RUN6}, // S_BSPI_RUN5
  {SPR_BSPI,2,3,{.p1 = A_Chase},S_BSPI_RUN7}, // S_BSPI_RUN6
  {SPR_BSPI,3,3,{.p1 = A_BabyMetal},S_BSPI_RUN8}, // S_BSPI_RUN7
  {SPR_BSPI,3,3,{.p1 = A_Chase},S_BSPI_RUN9}, // S_BSPI_RUN8
  {SPR_BSPI,4,3,{.p1 = A_Chase},S_BSPI_RUN10},  // S_BSPI_RUN9
  {SPR_BSPI,4,3,{.p1 = A_Chase},S_BSPI_RUN11},  // S_BSPI_RUN10
  {SPR_BSPI,5,3,{.p1 = A_Chase},S_BSPI_RUN12},  // S_BSPI_RUN11
  {SPR_BSPI,5,3,{.p1 = A_Chase},S_BSPI_RUN1}, // S_BSPI_RUN12
  {SPR_BSPI,0|FF_FULLBRIGHT,20,{.p1 = A_FaceTarget},S_BSPI_ATK2}, // S_BSPI_ATK1
  {SPR_BSPI,6|FF_FULLBRIGHT,4,{.p1 = A_BspiAttack},S_BSPI_ATK3},  // S_BSPI_ATK2
  {SPR_BSPI,7|FF_FULLBRIGHT,4,{NULL},S_BSPI_ATK4},  // S_BSPI_ATK3
  {SPR_BSPI,7|FF_FULLBRIGHT,1,{.p1 = A_SpidRefire},S_BSPI_ATK2},  // S_BSPI_ATK4
  {SPR_BSPI,8,3,{NULL},S_BSPI_PAIN2}, // S_BSPI_PAIN
  {SPR_BSPI,8,3,{.p1 = A_Pain},S_BSPI_RUN1},  // S_BSPI_PAIN2
  {SPR_BSPI,9,20,{.p1 = A_Scream},S_BSPI_DIE2}, // S_BSPI_DIE1
  {SPR_BSPI,10,7,{.p1 = A_Fall},S_BSPI_DIE3}, // S_BSPI_DIE2
  {SPR_BSPI,11,7,{NULL},S_BSPI_DIE4}, // S_BSPI_DIE3
  {SPR_BSPI,12,7,{NULL},S_BSPI_DIE5}, // S_BSPI_DIE4
  {SPR_BSPI,13,7,{NULL},S_BSPI_DIE6}, // S_BSPI_DIE5
  {SPR_BSPI,14,7,{NULL},S_BSPI_DIE7}, // S_BSPI_DIE6
  {SPR_BSPI,15,-1,{.p1 = A_BossDeath},S_NULL},  // S_BSPI_DIE7
  {SPR_BSPI,15,5,{NULL},S_BSPI_RAISE2}, // S_BSPI_RAISE1
  {SPR_BSPI,14,5,{NULL},S_BSPI_RAISE3}, // S_BSPI_RAISE2
  {SPR_BSPI,13,5,{NULL},S_BSPI_RAISE4}, // S_BSPI_RAISE3
  {SPR_BSPI,12,5,{NULL},S_BSPI_RAISE5}, // S_BSPI_RAISE4
  {SPR_BSPI,11,5,{NULL},S_BSPI_RAISE6}, // S_BSPI_RAISE5
  {SPR_BSPI,10,5,{NULL},S_BSPI_RAISE7}, // S_BSPI_RAISE6
  {SPR_BSPI,9,5,{NULL},S_BSPI_RUN1},  // S_BSPI_RAISE7
  {SPR_APLS,0|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLAZ2},  // S_ARACH_PLAZ
  {SPR_APLS,1|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLAZ}, // S_ARACH_PLAZ2
  {SPR_APBX,0|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX2},  // S_ARACH_PLEX
  {SPR_APBX,1|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX3},  // S_ARACH_PLEX2
  {SPR_APBX,2|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX4},  // S_ARACH_PLEX3
  {SPR_APBX,3|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX5},  // S_ARACH_PLEX4
  {SPR_APBX,4|FF_FULLBRIGHT,5,{NULL},S_NULL}, // S_ARACH_PLEX5
  {SPR_CYBR,0,10,{.p1 = A_Look},S_CYBER_STND2}, // S_CYBER_STND
  {SPR_CYBR,1,10,{.p1 = A_Look},S_CYBER_STND},  // S_CYBER_STND2
  {SPR_CYBR,0,3,{.p1 = A_Hoof},S_CYBER_RUN2}, // S_CYBER_RUN1
  {SPR_CYBR,0,3,{.p1 = A_Chase},S_CYBER_RUN3},  // S_CYBER_RUN2
  {SPR_CYBR,1,3,{.p1 = A_Chase},S_CYBER_RUN4},  // S_CYBER_RUN3
  {SPR_CYBR,1,3,{.p1 = A_Chase},S_CYBER_RUN5},  // S_CYBER_RUN4
  {SPR_CYBR,2,3,{.p1 = A_Chase},S_CYBER_RUN6},  // S_CYBER_RUN5
  {SPR_CYBR,2,3,{.p1 = A_Chase},S_CYBER_RUN7},  // S_CYBER_RUN6
  {SPR_CYBR,3,3,{.p1 = A_Metal},S_CYBER_RUN8},  // S_CYBER_RUN7
  {SPR_CYBR,3,3,{.p1 = A_Chase},S_CYBER_RUN1},  // S_CYBER_RUN8
  {SPR_CYBR,4,6,{.p1 = A_FaceTarget},S_CYBER_ATK2}, // S_CYBER_ATK1
  {SPR_CYBR,5,12,{.p1 = A_CyberAttack},S_CYBER_ATK3}, // S_CYBER_ATK2
  {SPR_CYBR,4,12,{.p1 = A_FaceTarget},S_CYBER_ATK4},  // S_CYBER_ATK3
  {SPR_CYBR,5,12,{.p1 = A_CyberAttack},S_CYBER_ATK5}, // S_CYBER_ATK4
  {SPR_CYBR,4,12,{.p1 = A_FaceTarget},S_CYBER_ATK6},  // S_CYBER_ATK5
  {SPR_CYBR,5,12,{.p1 = A_CyberAttack},S_CYBER_RUN1}, // S_CYBER_ATK6
  {SPR_CYBR,6,10,{.p1 = A_Pain},S_CYBER_RUN1},  // S_CYBER_PAIN
  {SPR_CYBR,7,10,{NULL},S_CYBER_DIE2},  // S_CYBER_DIE1
  {SPR_CYBR,8,10,{.p1 = A_Scream},S_CYBER_DIE3},  // S_CYBER_DIE2
  {SPR_CYBR,9,10,{NULL},S_CYBER_DIE4},  // S_CYBER_DIE3
  {SPR_CYBR,10,10,{NULL},S_CYBER_DIE5}, // S_CYBER_DIE4
  {SPR_CYBR,11,10,{NULL},S_CYBER_DIE6}, // S_CYBER_DIE5
  {SPR_CYBR,12,10,{.p1 = A_Fall},S_CYBER_DIE7}, // S_CYBER_DIE6
  {SPR_CYBR,13,10,{NULL},S_CYBER_DIE8}, // S_CYBER_DIE7
  {SPR_CYBR,14,10,{NULL},S_CYBER_DIE9}, // S_CYBER_DIE8
  {SPR_CYBR,15,30,{NULL},S_CYBER_DIE10},  // S_CYBER_DIE9
  {SPR_CYBR,15,-1,{.p1 = A_BossDeath},S_NULL},  // S_CYBER_DIE10
  {SPR_PAIN,0,10,{.p1 = A_Look},S_PAIN_STND}, // S_PAIN_STND
  {SPR_PAIN,0,3,{.p1 = A_Chase},S_PAIN_RUN2}, // S_PAIN_RUN1
  {SPR_PAIN,0,3,{.p1 = A_Chase},S_PAIN_RUN3}, // S_PAIN_RUN2
  {SPR_PAIN,1,3,{.p1 = A_Chase},S_PAIN_RUN4}, // S_PAIN_RUN3
  {SPR_PAIN,1,3,{.p1 = A_Chase},S_PAIN_RUN5}, // S_PAIN_RUN4
  {SPR_PAIN,2,3,{.p1 = A_Chase},S_PAIN_RUN6}, // S_PAIN_RUN5
  {SPR_PAIN,2,3,{.p1 = A_Chase},S_PAIN_RUN1}, // S_PAIN_RUN6
  {SPR_PAIN,3,5,{.p1 = A_FaceTarget},S_PAIN_ATK2},  // S_PAIN_ATK1
  {SPR_PAIN,4,5,{.p1 = A_FaceTarget},S_PAIN_ATK3},  // S_PAIN_ATK2
  {SPR_PAIN,5|FF_FULLBRIGHT,5,{.p1 = A_FaceTarget},S_PAIN_ATK4},  // S_PAIN_ATK3
  {SPR_PAIN,5|FF_FULLBRIGHT,0,{.p1 = A_PainAttack},S_PAIN_RUN1},  // S_PAIN_ATK4
  {SPR_PAIN,6,6,{NULL},S_PAIN_PAIN2}, // S_PAIN_PAIN
  {SPR_PAIN,6,6,{.p1 = A_Pain},S_PAIN_RUN1},  // S_PAIN_PAIN2
  {SPR_PAIN,7|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE2},  // S_PAIN_DIE1
  {SPR_PAIN,8|FF_FULLBRIGHT,8,{.p1 = A_Scream},S_PAIN_DIE3},  // S_PAIN_DIE2
  {SPR_PAIN,9|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE4},  // S_PAIN_DIE3
  {SPR_PAIN,10|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE5},  // S_PAIN_DIE4
  {SPR_PAIN,11|FF_FULLBRIGHT,8,{.p1 = A_PainDie},S_PAIN_DIE6}, // S_PAIN_DIE5
  {SPR_PAIN,12|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_PAIN_DIE6
  {SPR_PAIN,12,8,{NULL},S_PAIN_RAISE2}, // S_PAIN_RAISE1
  {SPR_PAIN,11,8,{NULL},S_PAIN_RAISE3}, // S_PAIN_RAISE2
  {SPR_PAIN,10,8,{NULL},S_PAIN_RAISE4}, // S_PAIN_RAISE3
  {SPR_PAIN,9,8,{NULL},S_PAIN_RAISE5},  // S_PAIN_RAISE4
  {SPR_PAIN,8,8,{NULL},S_PAIN_RAISE6},  // S_PAIN_RAISE5
  {SPR_PAIN,7,8,{NULL},S_PAIN_RUN1},  // S_PAIN_RAISE6
  {SPR_SSWV,0,10,{.p1 = A_Look},S_SSWV_STND2},  // S_SSWV_STND
  {SPR_SSWV,1,10,{.p1 = A_Look},S_SSWV_STND}, // S_SSWV_STND2
  {SPR_SSWV,0,3,{.p1 = A_Chase},S_SSWV_RUN2}, // S_SSWV_RUN1
  {SPR_SSWV,0,3,{.p1 = A_Chase},S_SSWV_RUN3}, // S_SSWV_RUN2
  {SPR_SSWV,1,3,{.p1 = A_Chase},S_SSWV_RUN4}, // S_SSWV_RUN3
  {SPR_SSWV,1,3,{.p1 = A_Chase},S_SSWV_RUN5}, // S_SSWV_RUN4
  {SPR_SSWV,2,3,{.p1 = A_Chase},S_SSWV_RUN6}, // S_SSWV_RUN5
  {SPR_SSWV,2,3,{.p1 = A_Chase},S_SSWV_RUN7}, // S_SSWV_RUN6
  {SPR_SSWV,3,3,{.p1 = A_Chase},S_SSWV_RUN8}, // S_SSWV_RUN7
  {SPR_SSWV,3,3,{.p1 = A_Chase},S_SSWV_RUN1}, // S_SSWV_RUN8
  {SPR_SSWV,4,10,{.p1 = A_FaceTarget},S_SSWV_ATK2}, // S_SSWV_ATK1
  {SPR_SSWV,5,10,{.p1 = A_FaceTarget},S_SSWV_ATK3}, // S_SSWV_ATK2
  {SPR_SSWV,6|FF_FULLBRIGHT,4,{.p1 = A_CPosAttack},S_SSWV_ATK4},  // S_SSWV_ATK3
  {SPR_SSWV,5,6,{.p1 = A_FaceTarget},S_SSWV_ATK5},  // S_SSWV_ATK4
  {SPR_SSWV,6|FF_FULLBRIGHT,4,{.p1 = A_CPosAttack},S_SSWV_ATK6},  // S_SSWV_ATK5
  {SPR_SSWV,5,1,{.p1 = A_CPosRefire},S_SSWV_ATK2},  // S_SSWV_ATK6
  {SPR_SSWV,7,3,{NULL},S_SSWV_PAIN2}, // S_SSWV_PAIN
  {SPR_SSWV,7,3,{.p1 = A_Pain},S_SSWV_RUN1},  // S_SSWV_PAIN2
  {SPR_SSWV,8,5,{NULL},S_SSWV_DIE2},  // S_SSWV_DIE1
  {SPR_SSWV,9,5,{.p1 = A_Scream},S_SSWV_DIE3},  // S_SSWV_DIE2
  {SPR_SSWV,10,5,{.p1 = A_Fall},S_SSWV_DIE4}, // S_SSWV_DIE3
  {SPR_SSWV,11,5,{NULL},S_SSWV_DIE5}, // S_SSWV_DIE4
  {SPR_SSWV,12,-1,{NULL},S_NULL}, // S_SSWV_DIE5
  {SPR_SSWV,13,5,{NULL},S_SSWV_XDIE2},  // S_SSWV_XDIE1
  {SPR_SSWV,14,5,{.p1 = A_XScream},S_SSWV_XDIE3}, // S_SSWV_XDIE2
  {SPR_SSWV,15,5,{.p1 = A_Fall},S_SSWV_XDIE4},  // S_SSWV_XDIE3
  {SPR_SSWV,16,5,{NULL},S_SSWV_XDIE5},  // S_SSWV_XDIE4
  {SPR_SSWV,17,5,{NULL},S_SSWV_XDIE6},  // S_SSWV_XDIE5
  {SPR_SSWV,18,5,{NULL},S_SSWV_XDIE7},  // S_SSWV_XDIE6
  {SPR_SSWV,19,5,{NULL},S_SSWV_XDIE8},  // S_SSWV_XDIE7
  {SPR_SSWV,20,5,{NULL},S_SSWV_XDIE9},  // S_SSWV_XDIE8
  {SPR_SSWV,21,-1,{NULL},S_NULL}, // S_SSWV_XDIE9
  {SPR_SSWV,12,5,{NULL},S_SSWV_RAISE2}, // S_SSWV_RAISE1
  {SPR_SSWV,11,5,{NULL},S_SSWV_RAISE3}, // S_SSWV_RAISE2
  {SPR_SSWV,10,5,{NULL},S_SSWV_RAISE4}, // S_SSWV_RAISE3
  {SPR_SSWV,9,5,{NULL},S_SSWV_RAISE5},  // S_SSWV_RAISE4
  {SPR_SSWV,8,5,{NULL},S_SSWV_RUN1},  // S_SSWV_RAISE5
  {SPR_KEEN,0,-1,{NULL},S_KEENSTND},  // S_KEENSTND
  {SPR_KEEN,0,6,{NULL},S_COMMKEEN2},  // S_COMMKEEN
  {SPR_KEEN,1,6,{NULL},S_COMMKEEN3},  // S_COMMKEEN2
  {SPR_KEEN,2,6,{.p1 = A_Scream},S_COMMKEEN4},  // S_COMMKEEN3
  {SPR_KEEN,3,6,{NULL},S_COMMKEEN5},  // S_COMMKEEN4
  {SPR_KEEN,4,6,{NULL},S_COMMKEEN6},  // S_COMMKEEN5
  {SPR_KEEN,5,6,{NULL},S_COMMKEEN7},  // S_COMMKEEN6
  {SPR_KEEN,6,6,{NULL},S_COMMKEEN8},  // S_COMMKEEN7
  {SPR_KEEN,7,6,{NULL},S_COMMKEEN9},  // S_COMMKEEN8
  {SPR_KEEN,8,6,{NULL},S_COMMKEEN10}, // S_COMMKEEN9
  {SPR_KEEN,9,6,{NULL},S_COMMKEEN11}, // S_COMMKEEN10
  {SPR_KEEN,10,6,{.p1 = A_KeenDie},S_COMMKEEN12},// S_COMMKEEN11
  {SPR_KEEN,11,-1,{NULL},S_NULL},   // S_COMMKEEN12
  {SPR_KEEN,12,4,{NULL},S_KEENPAIN2}, // S_KEENPAIN
  {SPR_KEEN,12,8,{.p1 = A_Pain},S_KEENSTND},  // S_KEENPAIN2
  {SPR_BBRN,0,-1,{NULL},S_NULL},    // S_BRAIN
  {SPR_BBRN,1,36,{.p1 = A_BrainPain},S_BRAIN},  // S_BRAIN_PAIN
  {SPR_BBRN,0,100,{.p1 = A_BrainScream},S_BRAIN_DIE2},  // S_BRAIN_DIE1
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE3},  // S_BRAIN_DIE2
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE4},  // S_BRAIN_DIE3
  {SPR_BBRN,0,-1,{.p1 = A_BrainDie},S_NULL},  // S_BRAIN_DIE4
  {SPR_SSWV,0,10,{.p1 = A_Look},S_BRAINEYE},  // S_BRAINEYE
  {SPR_SSWV,0,181,{.p1 = A_BrainAwake},S_BRAINEYE1},  // S_BRAINEYESEE
  {SPR_SSWV,0,150,{.p1 = A_BrainSpit},S_BRAINEYE1}, // S_BRAINEYE1
  {SPR_BOSF,0|FF_FULLBRIGHT,3,{.p1 = A_SpawnSound},S_SPAWN2}, // S_SPAWN1
  {SPR_BOSF,1|FF_FULLBRIGHT,3,{.p1 = A_SpawnFly},S_SPAWN3}, // S_SPAWN2
  {SPR_BOSF,2|FF_FULLBRIGHT,3,{.p1 = A_SpawnFly},S_SPAWN4}, // S_SPAWN3
  {SPR_BOSF,3|FF_FULLBRIGHT,3,{.p1 = A_SpawnFly},S_SPAWN1}, // S_SPAWN4
  {SPR_FIRE,0|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE2}, // S_SPAWNFIRE1
  {SPR_FIRE,1|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE3}, // S_SPAWNFIRE2
  {SPR_FIRE,2|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE4}, // S_SPAWNFIRE3
  {SPR_FIRE,3|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE5}, // S_SPAWNFIRE4
  {SPR_FIRE,4|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE6}, // S_SPAWNFIRE5
  {SPR_FIRE,5|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE7}, // S_SPAWNFIRE6
  {SPR_FIRE,6|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_SPAWNFIRE8}, // S_SPAWNFIRE7
  {SPR_FIRE,7|FF_FULLBRIGHT,4,{.p1 = A_Fire},S_NULL},   // S_SPAWNFIRE8
  {SPR_MISL,1|FF_FULLBRIGHT,10,{NULL},S_BRAINEXPLODE2}, // S_BRAINEXPLODE1
  {SPR_MISL,2|FF_FULLBRIGHT,10,{NULL},S_BRAINEXPLODE3}, // S_BRAINEXPLODE2
  {SPR_MISL,3|FF_FULLBRIGHT,10,{.p1 = A_BrainExplode},S_NULL},  // S_BRAINEXPLODE3
  {SPR_ARM1,0,6,{NULL},S_ARM1A},  // S_ARM1
  {SPR_ARM1,1|FF_FULLBRIGHT,7,{NULL},S_ARM1}, // S_ARM1A
  {SPR_ARM2,0,6,{NULL},S_ARM2A},  // S_ARM2
  {SPR_ARM2,1|FF_FULLBRIGHT,6,{NULL},S_ARM2}, // S_ARM2A
  {SPR_BAR1,0,6,{NULL},S_BAR2}, // S_BAR1
  {SPR_BAR1,1,6,{NULL},S_BAR1}, // S_BAR2
  {SPR_BEXP,0|FF_FULLBRIGHT,5,{NULL},S_BEXP2},  // S_BEXP
  {SPR_BEXP,1|FF_FULLBRIGHT,5,{.p1 = A_Scream},S_BEXP3},  // S_BEXP2
  {SPR_BEXP,2|FF_FULLBRIGHT,5,{NULL},S_BEXP4},  // S_BEXP3
  {SPR_BEXP,3|FF_FULLBRIGHT,10,{.p1 = A_Explode},S_BEXP5},  // S_BEXP4
  {SPR_BEXP,4|FF_FULLBRIGHT,10,{NULL},S_NULL},  // S_BEXP5
  {SPR_FCAN,0|FF_FULLBRIGHT,4,{NULL},S_BBAR2},  // S_BBAR1
  {SPR_FCAN,1|FF_FULLBRIGHT,4,{NULL},S_BBAR3},  // S_BBAR2
  {SPR_FCAN,2|FF_FULLBRIGHT,4,{NULL},S_BBAR1},  // S_BBAR3
  {SPR_BON1,0,6,{NULL},S_BON1A},  // S_BON1
  {SPR_BON1,1,6,{NULL},S_BON1B},  // S_BON1A
  {SPR_BON1,2,6,{NULL},S_BON1C},  // S_BON1B
  {SPR_BON1,3,6,{NULL},S_BON1D},  // S_BON1C
  {SPR_BON1,2,6,{NULL},S_BON1E},  // S_BON1D
  {SPR_BON1,1,6,{NULL},S_BON1}, // S_BON1E
  {SPR_BON2,0,6,{NULL},S_BON2A},  // S_BON2
  {SPR_BON2,1,6,{NULL},S_BON2B},  // S_BON2A
  {SPR_BON2,2,6,{NULL},S_BON2C},  // S_BON2B
  {SPR_BON2,3,6,{NULL},S_BON2D},  // S_BON2C
  {SPR_BON2,2,6,{NULL},S_BON2E},  // S_BON2D
  {SPR_BON2,1,6,{NULL},S_BON2}, // S_BON2E
  {SPR_BKEY,0,10,{NULL},S_BKEY2}, // S_BKEY
  {SPR_BKEY,1|FF_FULLBRIGHT,10,{NULL},S_BKEY},  // S_BKEY2
  {SPR_RKEY,0,10,{NULL},S_RKEY2}, // S_RKEY
  {SPR_RKEY,1|FF_FULLBRIGHT,10,{NULL},S_RKEY},  // S_RKEY2
  {SPR_YKEY,0,10,{NULL},S_YKEY2}, // S_YKEY
  {SPR_YKEY,1|FF_FULLBRIGHT,10,{NULL},S_YKEY},  // S_YKEY2
  {SPR_BSKU,0,10,{NULL},S_BSKULL2}, // S_BSKULL
  {SPR_BSKU,1|FF_FULLBRIGHT,10,{NULL},S_BSKULL},  // S_BSKULL2
  {SPR_RSKU,0,10,{NULL},S_RSKULL2}, // S_RSKULL
  {SPR_RSKU,1|FF_FULLBRIGHT,10,{NULL},S_RSKULL},  // S_RSKULL2
  {SPR_YSKU,0,10,{NULL},S_YSKULL2}, // S_YSKULL
  {SPR_YSKU,1|FF_FULLBRIGHT,10,{NULL},S_YSKULL},  // S_YSKULL2
  {SPR_STIM,0,-1,{NULL},S_NULL},  // S_STIM
  {SPR_MEDI,0,-1,{NULL},S_NULL},  // S_MEDI
  {SPR_SOUL,0|FF_FULLBRIGHT,6,{NULL},S_SOUL2},  // S_SOUL
  {SPR_SOUL,1|FF_FULLBRIGHT,6,{NULL},S_SOUL3},  // S_SOUL2
  {SPR_SOUL,2|FF_FULLBRIGHT,6,{NULL},S_SOUL4},  // S_SOUL3
  {SPR_SOUL,3|FF_FULLBRIGHT,6,{NULL},S_SOUL5},  // S_SOUL4
  {SPR_SOUL,2|FF_FULLBRIGHT,6,{NULL},S_SOUL6},  // S_SOUL5
  {SPR_SOUL,1|FF_FULLBRIGHT,6,{NULL},S_SOUL}, // S_SOUL6
  {SPR_PINV,0|FF_FULLBRIGHT,6,{NULL},S_PINV2},  // S_PINV
  {SPR_PINV,1|FF_FULLBRIGHT,6,{NULL},S_PINV3},  // S_PINV2
  {SPR_PINV,2|FF_FULLBRIGHT,6,{NULL},S_PINV4},  // S_PINV3
  {SPR_PINV,3|FF_FULLBRIGHT,6,{NULL},S_PINV}, // S_PINV4
  {SPR_PSTR,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_PSTR
  {SPR_PINS,0|FF_FULLBRIGHT,6,{NULL},S_PINS2},  // S_PINS
  {SPR_PINS,1|FF_FULLBRIGHT,6,{NULL},S_PINS3},  // S_PINS2
  {SPR_PINS,2|FF_FULLBRIGHT,6,{NULL},S_PINS4},  // S_PINS3
  {SPR_PINS,3|FF_FULLBRIGHT,6,{NULL},S_PINS}, // S_PINS4
  {SPR_MEGA,0|FF_FULLBRIGHT,6,{NULL},S_MEGA2},  // S_MEGA
  {SPR_MEGA,1|FF_FULLBRIGHT,6,{NULL},S_MEGA3},  // S_MEGA2
  {SPR_MEGA,2|FF_FULLBRIGHT,6,{NULL},S_MEGA4},  // S_MEGA3
  {SPR_MEGA,3|FF_FULLBRIGHT,6,{NULL},S_MEGA}, // S_MEGA4
  {SPR_SUIT,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_SUIT
  {SPR_PMAP,0|FF_FULLBRIGHT,6,{NULL},S_PMAP2},  // S_PMAP
  {SPR_PMAP,1|FF_FULLBRIGHT,6,{NULL},S_PMAP3},  // S_PMAP2
  {SPR_PMAP,2|FF_FULLBRIGHT,6,{NULL},S_PMAP4},  // S_PMAP3
  {SPR_PMAP,3|FF_FULLBRIGHT,6,{NULL},S_PMAP5},  // S_PMAP4
  {SPR_PMAP,2|FF_FULLBRIGHT,6,{NULL},S_PMAP6},  // S_PMAP5
  {SPR_PMAP,1|FF_FULLBRIGHT,6,{NULL},S_PMAP}, // S_PMAP6
  {SPR_PVIS,0|FF_FULLBRIGHT,6,{NULL},S_PVIS2},  // S_PVIS
  {SPR_PVIS,1,6,{NULL},S_PVIS}, // S_PVIS2
  {SPR_CLIP,0,-1,{NULL},S_NULL},  // S_CLIP
  {SPR_AMMO,0,-1,{NULL},S_NULL},  // S_AMMO
  {SPR_ROCK,0,-1,{NULL},S_NULL},  // S_ROCK
  {SPR_BROK,0,-1,{NULL},S_NULL},  // S_BROK
  {SPR_CELL,0,-1,{NULL},S_NULL},  // S_CELL
  {SPR_CELP,0,-1,{NULL},S_NULL},  // S_CELP
  {SPR_SHEL,0,-1,{NULL},S_NULL},  // S_SHEL
  {SPR_SBOX,0,-1,{NULL},S_NULL},  // S_SBOX
  {SPR_BPAK,0,-1,{NULL},S_NULL},  // S_BPAK
  {SPR_BFUG,0,-1,{NULL},S_NULL},  // S_BFUG
  {SPR_MGUN,0,-1,{NULL},S_NULL},  // S_MGUN
  {SPR_CSAW,0,-1,{NULL},S_NULL},  // S_CSAW
  {SPR_LAUN,0,-1,{NULL},S_NULL},  // S_LAUN
  {SPR_PLAS,0,-1,{NULL},S_NULL},  // S_PLAS
  {SPR_SHOT,0,-1,{NULL},S_NULL},  // S_SHOT
  {SPR_SGN2,0,-1,{NULL},S_NULL},  // S_SHOT2
  {SPR_COLU,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_COLU
  {SPR_SMT2,0,-1,{NULL},S_NULL},  // S_STALAG
  {SPR_GOR1,0,10,{NULL},S_BLOODYTWITCH2}, // S_BLOODYTWITCH
  {SPR_GOR1,1,15,{NULL},S_BLOODYTWITCH3}, // S_BLOODYTWITCH2
  {SPR_GOR1,2,8,{NULL},S_BLOODYTWITCH4},  // S_BLOODYTWITCH3
  {SPR_GOR1,1,6,{NULL},S_BLOODYTWITCH}, // S_BLOODYTWITCH4
  {SPR_PLAY,13,-1,{NULL},S_NULL}, // S_DEADTORSO
  {SPR_PLAY,18,-1,{NULL},S_NULL}, // S_DEADBOTTOM
  {SPR_POL2,0,-1,{NULL},S_NULL},  // S_HEADSONSTICK
  {SPR_POL5,0,-1,{NULL},S_NULL},  // S_GIBS
  {SPR_POL4,0,-1,{NULL},S_NULL},  // S_HEADONASTICK
  {SPR_POL3,0|FF_FULLBRIGHT,6,{NULL},S_HEADCANDLES2}, // S_HEADCANDLES
  {SPR_POL3,1|FF_FULLBRIGHT,6,{NULL},S_HEADCANDLES},  // S_HEADCANDLES2
  {SPR_POL1,0,-1,{NULL},S_NULL},  // S_DEADSTICK
  {SPR_POL6,0,6,{NULL},S_LIVESTICK2}, // S_LIVESTICK
  {SPR_POL6,1,8,{NULL},S_LIVESTICK},  // S_LIVESTICK2
  {SPR_GOR2,0,-1,{NULL},S_NULL},  // S_MEAT2
  {SPR_GOR3,0,-1,{NULL},S_NULL},  // S_MEAT3
  {SPR_GOR4,0,-1,{NULL},S_NULL},  // S_MEAT4
  {SPR_GOR5,0,-1,{NULL},S_NULL},  // S_MEAT5
  {SPR_SMIT,0,-1,{NULL},S_NULL},  // S_STALAGTITE
  {SPR_COL1,0,-1,{NULL},S_NULL},  // S_TALLGRNCOL
  {SPR_COL2,0,-1,{NULL},S_NULL},  // S_SHRTGRNCOL
  {SPR_COL3,0,-1,{NULL},S_NULL},  // S_TALLREDCOL
  {SPR_COL4,0,-1,{NULL},S_NULL},  // S_SHRTREDCOL
  {SPR_CAND,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_CANDLESTIK
  {SPR_CBRA,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_CANDELABRA
  {SPR_COL6,0,-1,{NULL},S_NULL},  // S_SKULLCOL
  {SPR_TRE1,0,-1,{NULL},S_NULL},  // S_TORCHTREE
  {SPR_TRE2,0,-1,{NULL},S_NULL},  // S_BIGTREE
  {SPR_ELEC,0,-1,{NULL},S_NULL},  // S_TECHPILLAR
  {SPR_CEYE,0|FF_FULLBRIGHT,6,{NULL},S_EVILEYE2}, // S_EVILEYE
  {SPR_CEYE,1|FF_FULLBRIGHT,6,{NULL},S_EVILEYE3}, // S_EVILEYE2
  {SPR_CEYE,2|FF_FULLBRIGHT,6,{NULL},S_EVILEYE4}, // S_EVILEYE3
  {SPR_CEYE,1|FF_FULLBRIGHT,6,{NULL},S_EVILEYE},  // S_EVILEYE4
  {SPR_FSKU,0|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL2},  // S_FLOATSKULL
  {SPR_FSKU,1|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL3},  // S_FLOATSKULL2
  {SPR_FSKU,2|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL}, // S_FLOATSKULL3
  {SPR_COL5,0,14,{NULL},S_HEARTCOL2}, // S_HEARTCOL
  {SPR_COL5,1,14,{NULL},S_HEARTCOL},  // S_HEARTCOL2
  {SPR_TBLU,0|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH2}, // S_BLUETORCH
  {SPR_TBLU,1|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH3}, // S_BLUETORCH2
  {SPR_TBLU,2|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH4}, // S_BLUETORCH3
  {SPR_TBLU,3|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH},  // S_BLUETORCH4
  {SPR_TGRN,0|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH2},  // S_GREENTORCH
  {SPR_TGRN,1|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH3},  // S_GREENTORCH2
  {SPR_TGRN,2|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH4},  // S_GREENTORCH3
  {SPR_TGRN,3|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH}, // S_GREENTORCH4
  {SPR_TRED,0|FF_FULLBRIGHT,4,{NULL},S_REDTORCH2},  // S_REDTORCH
  {SPR_TRED,1|FF_FULLBRIGHT,4,{NULL},S_REDTORCH3},  // S_REDTORCH2
  {SPR_TRED,2|FF_FULLBRIGHT,4,{NULL},S_REDTORCH4},  // S_REDTORCH3
  {SPR_TRED,3|FF_FULLBRIGHT,4,{NULL},S_REDTORCH}, // S_REDTORCH4
  {SPR_SMBT,0|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT2},  // S_BTORCHSHRT
  {SPR_SMBT,1|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT3},  // S_BTORCHSHRT2
  {SPR_SMBT,2|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT4},  // S_BTORCHSHRT3
  {SPR_SMBT,3|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT}, // S_BTORCHSHRT4
  {SPR_SMGT,0|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT2},  // S_GTORCHSHRT
  {SPR_SMGT,1|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT3},  // S_GTORCHSHRT2
  {SPR_SMGT,2|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT4},  // S_GTORCHSHRT3
  {SPR_SMGT,3|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT}, // S_GTORCHSHRT4
  {SPR_SMRT,0|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT2},  // S_RTORCHSHRT
  {SPR_SMRT,1|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT3},  // S_RTORCHSHRT2
  {SPR_SMRT,2|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT4},  // S_RTORCHSHRT3
  {SPR_SMRT,3|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT}, // S_RTORCHSHRT4
  {SPR_HDB1,0,-1,{NULL},S_NULL},  // S_HANGNOGUTS
  {SPR_HDB2,0,-1,{NULL},S_NULL},  // S_HANGBNOBRAIN
  {SPR_HDB3,0,-1,{NULL},S_NULL},  // S_HANGTLOOKDN
  {SPR_HDB4,0,-1,{NULL},S_NULL},  // S_HANGTSKULL
  {SPR_HDB5,0,-1,{NULL},S_NULL},  // S_HANGTLOOKUP
  {SPR_HDB6,0,-1,{NULL},S_NULL},  // S_HANGTNOBRAIN
  {SPR_POB1,0,-1,{NULL},S_NULL},  // S_COLONGIBS
  {SPR_POB2,0,-1,{NULL},S_NULL},  // S_SMALLPOOL
  {SPR_BRS1,0,-1,{NULL},S_NULL},    // S_BRAINSTEM
  {SPR_TLMP,0|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP2},  // S_TECHLAMP
  {SPR_TLMP,1|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP3},  // S_TECHLAMP2
  {SPR_TLMP,2|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP4},  // S_TECHLAMP3
  {SPR_TLMP,3|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP},   // S_TECHLAMP4
  {SPR_TLP2,0|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP2}, // S_TECH2LAMP
  {SPR_TLP2,1|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP3}, // S_TECH2LAMP2
  {SPR_TLP2,2|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP4}, // S_TECH2LAMP3
  {SPR_TLP2,3|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP},  // S_TECH2LAMP4

  {SPR_TNT1,0,-1,{NULL},S_TNT1},          // S_TNT1    // phares 3/8/98

  // killough 8/9/98: grenade
  {SPR_MISL,0|FF_FULLBRIGHT,1000,{.p1 = A_Die},S_GRENADE},      // S_GRENADE

  // killough 8/10/98: variable damage explosion
  {SPR_MISL,1|FF_FULLBRIGHT,4,{.p1 = A_Scream},S_DETONATE2},    // S_DETONATE
  {SPR_MISL,2|FF_FULLBRIGHT,6,{.p1 = A_Detonate},S_DETONATE3},  // S_DETONATE2
  {SPR_MISL,3|FF_FULLBRIGHT,10,{NULL},S_NULL},            // S_DETONATE3

  // killough 7/19/98: Marine's best friend :)
  {SPR_DOGS,0,10,{.p1 = A_Look},S_DOGS_STND2},  // S_DOGS_STND
  {SPR_DOGS,1,10,{.p1 = A_Look},S_DOGS_STND}, // S_DOGS_STND2
  {SPR_DOGS,0,2,{.p1 = A_Chase},S_DOGS_RUN2}, // S_DOGS_RUN1
  {SPR_DOGS,0,2,{.p1 = A_Chase},S_DOGS_RUN3}, // S_DOGS_RUN2
  {SPR_DOGS,1,2,{.p1 = A_Chase},S_DOGS_RUN4}, // S_DOGS_RUN3
  {SPR_DOGS,1,2,{.p1 = A_Chase},S_DOGS_RUN5}, // S_DOGS_RUN4
  {SPR_DOGS,2,2,{.p1 = A_Chase},S_DOGS_RUN6}, // S_DOGS_RUN5
  {SPR_DOGS,2,2,{.p1 = A_Chase},S_DOGS_RUN7}, // S_DOGS_RUN6
  {SPR_DOGS,3,2,{.p1 = A_Chase},S_DOGS_RUN8}, // S_DOGS_RUN7
  {SPR_DOGS,3,2,{.p1 = A_Chase},S_DOGS_RUN1}, // S_DOGS_RUN8
  {SPR_DOGS,4,8,{.p1 = A_FaceTarget},S_DOGS_ATK2},  // S_DOGS_ATK1
  {SPR_DOGS,5,8,{.p1 = A_FaceTarget},S_DOGS_ATK3},  // S_DOGS_ATK2
  {SPR_DOGS,6,8,{.p1 = A_SargAttack},S_DOGS_RUN1},  // S_DOGS_ATK3
  {SPR_DOGS,7,2,{NULL},S_DOGS_PAIN2}, // S_DOGS_PAIN
  {SPR_DOGS,7,2,{.p1 = A_Pain},S_DOGS_RUN1},  // S_DOGS_PAIN2
  {SPR_DOGS,8,8,{NULL},S_DOGS_DIE2},  // S_DOGS_DIE1
  {SPR_DOGS,9,8,{.p1 = A_Scream},S_DOGS_DIE3},  // S_DOGS_DIE2
  {SPR_DOGS,10,4,{NULL},S_DOGS_DIE4}, // S_DOGS_DIE3
  {SPR_DOGS,11,4,{.p1 = A_Fall},S_DOGS_DIE5}, // S_DOGS_DIE4
  {SPR_DOGS,12,4,{NULL},S_DOGS_DIE6}, // S_DOGS_DIE5
  {SPR_DOGS,13,-1,{NULL},S_NULL}, // S_DOGS_DIE6
  {SPR_DOGS,13,5,{NULL},S_DOGS_RAISE2}, // S_DOGS_RAISE1
  {SPR_DOGS,12,5,{NULL},S_DOGS_RAISE3}, // S_DOGS_RAISE2
  {SPR_DOGS,11,5,{NULL},S_DOGS_RAISE4}, // S_DOGS_RAISE3
  {SPR_DOGS,10,5,{NULL},S_DOGS_RAISE5}, // S_DOGS_RAISE4
  {SPR_DOGS,9,5,{NULL},S_DOGS_RAISE6},  // S_DOGS_RAISE5
  {SPR_DOGS,8,5,{NULL},S_DOGS_RUN1},  // S_DOGS_RAISE6

  // killough 7/11/98: beta BFG begins here
  // S_OLDBFG1

#define BFGDELAY 1
#define OLDBFG_1FRAMES(x) {SPR_BFGG,1,BFGDELAY,{.p2 = A_FireOldBFG},x+S_OLDBFG1+2},
#define OLDBFG_2FRAMES(x) OLDBFG_1FRAMES(x) OLDBFG_1FRAMES(x+1)
#define OLDBFG_4FRAMES(x) OLDBFG_2FRAMES(x) OLDBFG_2FRAMES(x+2)
#define OLDBFG_8FRAMES(x) OLDBFG_4FRAMES(x) OLDBFG_4FRAMES(x+4)
  {SPR_BFGG,0,10,{.p2 = A_BFGsound},S_OLDBFG1+1},  // S_OLDBFG1

  OLDBFG_8FRAMES(0)
  OLDBFG_8FRAMES(8)
  OLDBFG_8FRAMES(16) 
  OLDBFG_8FRAMES(24)
  OLDBFG_8FRAMES(32)

  {SPR_BFGG,1,0,{.p2 = A_Light0},S_OLDBFG43}, // S_OLDBFG42
  {SPR_BFGG,1,20,{.p2 = A_ReFire},S_BFG},   // S_OLDBFG43

  // killough 7/11/98: end of beta BFG

  // killough 7/19/98: First plasma fireball in the beta:
  {SPR_PLS1,0|FF_FULLBRIGHT,6,{NULL},S_PLS1BALL2},  // S_PLS1BALL
  {SPR_PLS1,1|FF_FULLBRIGHT,6,{NULL},S_PLS1BALL}, // S_PLS1BALL2
  {SPR_PLS1,2|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP2}, // S_PLS1EXP
  {SPR_PLS1,3|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP3}, // S_PLS1EXP2
  {SPR_PLS1,4|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP4}, // S_PLS1EXP3
  {SPR_PLS1,5|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP5}, // S_PLS1EXP4
  {SPR_PLS1,6|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_PLS1EXP5

  // killough 7/19/98: Second plasma fireball in the beta:
  {SPR_PLS2,0|FF_FULLBRIGHT,4,{NULL},S_PLS2BALL2}, // S_PLS2BALL
  {SPR_PLS2,1|FF_FULLBRIGHT,4,{NULL},S_PLS2BALL},  // S_PLS2BALL2
  {SPR_PLS2,2|FF_FULLBRIGHT,6,{NULL},S_PLS2BALLX2},  // S_PLS2BALLX1
  {SPR_PLS2,3|FF_FULLBRIGHT,6,{NULL},S_PLS2BALLX3},  // S_PLS2BALLX2
  {SPR_PLS2,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_PLS2BALLX3

  {SPR_BON3,0,6,{NULL},S_BON3},           // S_BON3  // killough 7/11/98:
  {SPR_BON4,0,6,{NULL},S_BON4},           // S_BON4  // beta bonus items

  // killough 10/98: beta lost souls attacked from a distance, 
  // animated with colors, and stayed in the air when killed.
  // This is an approximation, but I'm sure it can be improved.

  // spawnstate
  {SPR_SKUL,0,10,{.p1 = A_Look},S_BSKUL_STND},  // S_BSKUL_STND

  // chasestate
  {SPR_SKUL,1,5,{.p1 = A_Chase},S_BSKUL_RUN2},  // S_BSKUL_RUN1
  {SPR_SKUL,2,5,{.p1 = A_Chase},S_BSKUL_RUN3},  // S_BSKUL_RUN2
  {SPR_SKUL,3,5,{.p1 = A_Chase},S_BSKUL_RUN4},  // S_BSKUL_RUN3
  {SPR_SKUL,0,5,{.p1 = A_Chase},S_BSKUL_RUN1},  // S_BSKUL_RUN4

  // missilestate
  {SPR_SKUL,4,4,{.p1 = A_FaceTarget},S_BSKUL_ATK2},     // S_BSKUL_ATK1
  {SPR_SKUL,5,5,{.p1 = A_BetaSkullAttack},S_BSKUL_ATK3}, // S_BSKUL_ATK2
  {SPR_SKUL,5,4,{NULL},S_BSKUL_RUN1},              // S_BSKUL_ATK3

  // painstate
  {SPR_SKUL,6,4,{NULL},S_BSKUL_PAIN2},     // S_BSKUL_PAIN1
  {SPR_SKUL,7,2,{.p1 = A_Pain},S_BSKUL_RUN1},   // S_BSKUL_PAIN2
  {SPR_SKUL,8,4,{NULL},S_BSKUL_RUN1},      // S_BSKUL_PAIN3

  // deathstate
  {SPR_SKUL, 9,5,{NULL},S_BSKUL_DIE2},     // S_BSKUL_DIE1
  {SPR_SKUL,10,5,{NULL},S_BSKUL_DIE3},     // S_BSKUL_DIE2
  {SPR_SKUL,11,5,{NULL},S_BSKUL_DIE4},     // S_BSKUL_DIE3
  {SPR_SKUL,12,5,{NULL},S_BSKUL_DIE5},     // S_BSKUL_DIE4
  {SPR_SKUL,13,5,{.p1 = A_Scream},S_BSKUL_DIE6}, // S_BSKUL_DIE5
  {SPR_SKUL,14,5,{NULL},S_BSKUL_DIE7},     // S_BSKUL_DIE6
  {SPR_SKUL,15,5,{.p1 = A_Fall},S_BSKUL_DIE8},   // S_BSKUL_DIE7
  {SPR_SKUL,16,5,{.p1 = A_Stop},S_BSKUL_DIE8},   // S_BSKUL_DIE8

  // killough 10/98: mushroom effect
  {SPR_MISL,1|FF_FULLBRIGHT,8,{.p1 = A_Mushroom},S_EXPLODE2},  // S_MUSHROOM
};

// ********************************************************************
// Object "Thing" definitions
// ********************************************************************
// Now we get to the actual objects and their characteristics.  If
// you've seen Dehacked, much of this is where the Bits are set,
// commented below as "flags", as well as where you wire in which
// frames are the beginning frames for near and far attack, death,
// and such.  Sounds are hooked in here too, as well as how much
// mass, speed and so forth a Thing has.  Everything you ever wanted
// to know...
//
// Like all this other stuff, the MT_* entries are enumerated in info.h
//
// Note that these are all just indices of the elements involved, and
// not real pointers to them.  For example, the player's death sequence
// is S_PLAY_DIE1, which just evaluates to the index in the states[]
// array above, which actually knows what happens then and what the
// sprite looks like, if it makes noise or not, etc.
//
// Additional comments about each of the entries are located in info.h
// next to the mobjinfo_t structure definition.
//
// This goes on for the next 3000+ lines...

mobjinfo_t original_mobjinfo[NUMMOBJTYPES] = {
  {   // MT_PLAYER
    -1,   // doomednum
    S_PLAY,   // spawnstate
    100,    // spawnhealth
    S_PLAY_RUN1,    // seestate
    sfx_None,   // seesound
    0,    // reactiontime
    sfx_None,   // attacksound
    S_PLAY_PAIN,    // painstate
    255,    // painchance
    sfx_plpain,   // painsound
    S_NULL,   // meleestate
    S_PLAY_ATK1,    // missilestate
    S_PLAY_DIE1,    // deathstate
    S_PLAY_XDIE1,   // xdeathstate
    sfx_pldeth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,  // flags // killough 7/18/98
    S_NULL    // raisestate
  },
  
  {   // MT_POSSESSED
    3004,   // doomednum
    S_POSS_STND,    // spawnstate
    20,   // spawnhealth
    S_POSS_RUN1,    // seestate
    sfx_posit1,   // seesound
    8,    // reactiontime
    sfx_pistol,   // attacksound
    S_POSS_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_POSS_ATK1,    // missilestate
    S_POSS_DIE1,    // deathstate
    S_POSS_XDIE1,   // xdeathstate
    sfx_podth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_POSS_RAISE1   // raisestate
  },
  
  {   // MT_SHOTGUY
    9,    // doomednum
    S_SPOS_STND,    // spawnstate
    30,   // spawnhealth
    S_SPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SPOS_ATK1,    // missilestate
    S_SPOS_DIE1,    // deathstate
    S_SPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SPOS_RAISE1   // raisestate
  },
  
  {   // MT_VILE
    64,   // doomednum
    S_VILE_STND,    // spawnstate
    700,    // spawnhealth
    S_VILE_RUN1,    // seestate
    sfx_vilsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_VILE_PAIN,    // painstate
    10,   // painchance
    sfx_vipain,   // painsound
    0,    // meleestate
    S_VILE_ATK1,    // missilestate
    S_VILE_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_vildth,   // deathsound
    15,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_vilact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_FIRE
    -1,   // doomednum
    S_FIRE1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_UNDEAD
    66,   // doomednum
    S_SKEL_STND,    // spawnstate
    300,    // spawnhealth
    S_SKEL_RUN1,    // seestate
    sfx_skesit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SKEL_PAIN,    // painstate
    100,    // painchance
    sfx_popain,   // painsound
    S_SKEL_FIST1,   // meleestate
    S_SKEL_MISS1,   // missilestate
    S_SKEL_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_skedth,   // deathsound
    10,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_skeact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,  // flags
    S_SKEL_RAISE1   // raisestate
  },
  
  {   // MT_TRACER
    -1,   // doomednum
    S_TRACER,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_skeatk,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TRACEEXP1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    10*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SMOKE
    -1,   // doomednum
    S_SMOKE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_FATSO
    67,   // doomednum
    S_FATT_STND,    // spawnstate
    600,    // spawnhealth
    S_FATT_RUN1,    // seestate
    sfx_mansit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_FATT_PAIN,    // painstate
    80,   // painchance
    sfx_mnpain,   // painsound
    0,    // meleestate
    S_FATT_ATK1,    // missilestate
    S_FATT_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_mandth,   // deathsound
    8,    // speed
    48*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_FATT_RAISE1   // raisestate
  },
  
  {   // MT_FATSHOT
    -1,   // doomednum
    S_FATSHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FATSHOTX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    20*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags \\ killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUY
    65,   // doomednum
    S_CPOS_STND,    // spawnstate
    70,   // spawnhealth
    S_CPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_CPOS_ATK1,    // missilestate
    S_CPOS_DIE1,    // deathstate
    S_CPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_CPOS_RAISE1   // raisestate
  },
  
  {   // MT_TROOP
    3001,   // doomednum
    S_TROO_STND,    // spawnstate
    60,   // spawnhealth
    S_TROO_RUN1,    // seestate
    sfx_bgsit1,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_TROO_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    S_TROO_ATK1,    // meleestate
    S_TROO_ATK1,    // missilestate
    S_TROO_DIE1,    // deathstate
    S_TROO_XDIE1,   // xdeathstate
    sfx_bgdth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_bgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_TROO_RAISE1   // raisestate
  },
  
  {   // MT_SERGEANT
    3002,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_SHADOWS
    58,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,   // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_HEAD
    3005,   // doomednum
    S_HEAD_STND,    // spawnstate
    400,    // spawnhealth
    S_HEAD_RUN1,    // seestate
    sfx_cacsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_HEAD_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_HEAD_ATK1,    // missilestate
    S_HEAD_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_cacdth,   // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_HEAD_RAISE1   // raisestate
  },
  
  {   // MT_BRUISER
    3003,   // doomednum
    S_BOSS_STND,    // spawnstate
    1000,   // spawnhealth
    S_BOSS_RUN1,    // seestate
    sfx_brssit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOSS_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOSS_ATK1,    // meleestate
    S_BOSS_ATK1,    // missilestate
    S_BOSS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_brsdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOSS_RAISE1   // raisestate
  },
  
  {   // MT_BRUISERSHOT
    -1,   // doomednum
    S_BRBALL1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRBALLX1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    15*FRACUNIT,   // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_KNIGHT
    69,   // doomednum
    S_BOS2_STND,    // spawnstate
    500,    // spawnhealth
    S_BOS2_RUN1,    // seestate
    sfx_kntsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOS2_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOS2_ATK1,    // meleestate
    S_BOS2_ATK1,    // missilestate
    S_BOS2_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_kntdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOS2_RAISE1   // raisestate
  },

  {   // MT_SKULL
    3006,   // doomednum
    S_SKULL_STND,   // spawnstate
    100,    // spawnhealth
    S_SKULL_RUN1,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_sklatk,   // attacksound
    S_SKULL_PAIN,   // painstate
    256,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SKULL_ATK1,   // missilestate
    S_SKULL_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    8,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    50,   // mass
    3,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPIDER
    7,    // doomednum
    S_SPID_STND,    // spawnstate
    3000,   // spawnhealth
    S_SPID_RUN1,    // seestate
    sfx_spisit,   // seesound
    8,    // reactiontime
    sfx_shotgn,   // attacksound
    S_SPID_PAIN,    // painstate
    40,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SPID_ATK1,    // missilestate
    S_SPID_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_spidth,   // deathsound
    12,   // speed
    128*FRACUNIT,   // radius
    100*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BABY
    68,   // doomednum
    S_BSPI_STND,    // spawnstate
    500,    // spawnhealth
    S_BSPI_SIGHT,   // seestate
    sfx_bspsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BSPI_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_BSPI_ATK1,    // missilestate
    S_BSPI_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_bspdth,   // deathsound
    12,   // speed
    64*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    600,    // mass
    0,    // damage
    sfx_bspact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BSPI_RAISE1   // raisestate
  },
  
  {   // MT_CYBORG
    16,   // doomednum
    S_CYBER_STND,   // spawnstate
    4000,   // spawnhealth
    S_CYBER_RUN1,   // seestate
    sfx_cybsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CYBER_PAIN,   // painstate
    20,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_CYBER_ATK1,   // missilestate
    S_CYBER_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_cybdth,   // deathsound
    16,   // speed
    40*FRACUNIT,    // radius
    110*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PAIN
    71,   // doomednum
    S_PAIN_STND,    // spawnstate
    400,    // spawnhealth
    S_PAIN_RUN1,    // seestate
    sfx_pesit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_PAIN_PAIN,    // painstate
    128,    // painchance
    sfx_pepain,   // painsound
    0,    // meleestate
    S_PAIN_ATK1,    // missilestate
    S_PAIN_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pedth,    // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_PAIN_RAISE1   // raisestate
  },
  
  {   // MT_WOLFSS
    84,   // doomednum
    S_SSWV_STND,    // spawnstate
    50,   // spawnhealth
    S_SSWV_RUN1,    // seestate
    sfx_sssit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SSWV_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SSWV_ATK1,    // missilestate
    S_SSWV_DIE1,    // deathstate
    S_SSWV_XDIE1,   // xdeathstate
    sfx_ssdth,    // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SSWV_RAISE1   // raisestate
  },
  
  {   // MT_KEEN
    72,   // doomednum
    S_KEENSTND,   // spawnstate
    100,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_KEENPAIN,   // painstate
    256,    // painchance
    sfx_keenpn,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_COMMKEEN,   // deathstate
    S_NULL,   // xdeathstate
    sfx_keendt,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSBRAIN
    88,   // doomednum
    S_BRAIN,    // spawnstate
    250,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_BRAIN_PAIN,   // painstate
    255,    // painchance
    sfx_bospn,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRAIN_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_bosdth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSSPIT
    89,   // doomednum
    S_BRAINEYE,   // spawnstate
    1000,   // spawnhealth
    S_BRAINEYESEE,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSTARGET
    87,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNSHOT
    -1,   // doomednum
    S_SPAWN1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_bospit,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    32*FRACUNIT,    // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNFIRE
    -1,   // doomednum
    S_SPAWNFIRE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BARREL
    2035,   // doomednum
    S_BAR1,   // spawnstate
    20,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BEXP,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    42*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TROOPSHOT
    -1,   // doomednum
    S_TBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_HEADSHOT
    -1,   // doomednum
    S_RBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_RBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_ROCKET
    -1,   // doomednum
    S_ROCKET,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_EXPLODE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    20*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    20,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PLASMA
    -1,   // doomednum
    S_PLASBALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLASEXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BFG
    -1,   // doomednum
    S_BFGSHOT,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BFGLAND,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rxplod,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    100,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_ARACHPLAZ
    -1,   // doomednum
    S_ARACH_PLAZ,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ARACH_PLEX,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_PUFF
    -1,   // doomednum
    S_PUFF1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BLOOD
    -1,   // doomednum
    S_BLOOD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TFOG
    -1,   // doomednum
    S_TFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_IFOG
    -1,   // doomednum
    S_IFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_TELEPORTMAN
    14,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_EXTRABFG
    -1,   // doomednum
    S_BFGEXP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC0
    2018,   // doomednum
    S_ARM1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC1
    2019,   // doomednum
    S_ARM2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC2
    2014,   // doomednum
    S_BON1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC3
    2015,   // doomednum
    S_BON2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC4
    5,    // doomednum
    S_BKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC5
    13,   // doomednum
    S_RKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC6
    6,    // doomednum
    S_YKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC7
    39,   // doomednum
    S_YSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC8
    38,   // doomednum
    S_RSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC9
    40,   // doomednum
    S_BSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC10
    2011,   // doomednum
    S_STIM,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC11
    2012,   // doomednum
    S_MEDI,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC12
    2013,   // doomednum
    S_SOUL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags   // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_INV
    2022,   // doomednum
    S_PINV,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC13
    2023,   // doomednum
    S_PSTR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_INS
    2024,   // doomednum
    S_PINS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC14
    2025,   // doomednum
    S_SUIT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC15
    2026,   // doomednum
    S_PMAP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC16
    2045,   // doomednum
    S_PVIS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MEGA
    83,   // doomednum
    S_MEGA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CLIP
    2007,   // doomednum
    S_CLIP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC17
    2048,   // doomednum
    S_AMMO,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC18
    2010,   // doomednum
    S_ROCK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC19
    2046,   // doomednum
    S_BROK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC20
    2047,   // doomednum
    S_CELL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC21
    17,   // doomednum
    S_CELP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC22
    2008,   // doomednum
    S_SHEL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC23
    2049,   // doomednum
    S_SBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC24
    8,    // doomednum
    S_BPAK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC25
    2006,   // doomednum
    S_BFUG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUN
    2002,   // doomednum
    S_MGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC26
    2005,   // doomednum
    S_CSAW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC27
    2003,   // doomednum
    S_LAUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC28
    2004,   // doomednum
    S_PLAS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SHOTGUN
    2001,   // doomednum
    S_SHOT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SUPERSHOTGUN
    82,   // doomednum
    S_SHOT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC29
    85,   // doomednum
    S_TECHLAMP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC30
    86,   // doomednum
    S_TECH2LAMP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC31
    2028,   // doomednum
    S_COLU,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC32
    30,   // doomednum
    S_TALLGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC33
    31,   // doomednum
    S_SHRTGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC34
    32,   // doomednum
    S_TALLREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC35
    33,   // doomednum
    S_SHRTREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC36
    37,   // doomednum
    S_SKULLCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC37
    36,   // doomednum
    S_HEARTCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC38
    41,   // doomednum
    S_EVILEYE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC39
    42,   // doomednum
    S_FLOATSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC40
    43,   // doomednum
    S_TORCHTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC41
    44,   // doomednum
    S_BLUETORCH,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC42
    45,   // doomednum
    S_GREENTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC43
    46,   // doomednum
    S_REDTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC44
    55,   // doomednum
    S_BTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC45
    56,   // doomednum
    S_GTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC46
    57,   // doomednum
    S_RTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC47
    47,   // doomednum
    S_STALAGTITE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC48
    48,   // doomednum
    S_TECHPILLAR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC49
    34,   // doomednum
    S_CANDLESTIK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC50
    35,   // doomednum
    S_CANDELABRA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC51
    49,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC52
    50,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC53
    51,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC54
    52,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC55
    53,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC56
    59,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC57
    60,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC58
    61,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC59
    62,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC60
    63,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC61
    22,   // doomednum
    S_HEAD_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC62
    15,   // doomednum
    S_PLAY_DIE7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC63
    18,   // doomednum
    S_POSS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC64
    21,   // doomednum
    S_SARG_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC65
    23,   // doomednum
    S_SKULL_DIE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC66
    20,   // doomednum
    S_TROO_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC67
    19,   // doomednum
    S_SPOS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC68
    10,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC69
    12,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC70
    28,   // doomednum
    S_HEADSONSTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC71
    24,   // doomednum
    S_GIBS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC72
    27,   // doomednum
    S_HEADONASTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC73
    29,   // doomednum
    S_HEADCANDLES,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC74
    25,   // doomednum
    S_DEADSTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC75
    26,   // doomednum
    S_LIVESTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC76
    54,   // doomednum
    S_BIGTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    32*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC77
    70,   // doomednum
    S_BBAR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC78
    73,   // doomednum
    S_HANGNOGUTS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC79
    74,   // doomednum
    S_HANGBNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC80
    75,   // doomednum
    S_HANGTLOOKDN,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC81
    76,   // doomednum
    S_HANGTSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC82
    77,   // doomednum
    S_HANGTLOOKUP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC83
    78,   // doomednum
    S_HANGTNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC84
    79,   // doomednum
    S_COLONGIBS,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC85
    80,   // doomednum
    S_SMALLPOOL,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC86
    81,   // doomednum
    S_BRAINSTEM,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },

  // For use with wind and current effects
  {   // MT_PUSH                       // phares
    5001,           // doomednum       //   |      //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate      //   V      // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // For use with wind and current effects
  {   // MT_PULL
    5002,           // doomednum                   //jff 5/11/98 deconflict            
    S_TNT1,         // spawnstate                  // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // Marine's best friend :)      // killough 7/19/98
  {   // MT_DOGS
    888,   // doomednum
    S_DOGS_STND,    // spawnstate
    500,    // spawnhealth
    S_DOGS_RUN1,    // seestate
    sfx_dgsit,   // seesound
    8,    // reactiontime
    sfx_dgatk,   // attacksound
    S_DOGS_PAIN,    // painstate
    180,    // painchance
    sfx_dgpain,   // painsound
    S_DOGS_ATK1,    // meleestate
    0,    // missilestate
    S_DOGS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_dgdth,   // deathsound
    10,   // speed
    12*FRACUNIT,    // radius
    28*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_dgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_DOGS_RAISE1   // raisestate
  },

  // killough 7/11/98: this is the first of two plasma fireballs in the beta
  {   // MT_PLASMA1
    -1,   // doomednum
    S_PLS1BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS1EXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES|MF_TRANSLUCENT, // [FG] translucent
    S_NULL    // raisestate
  },
  
  // killough 7/11/98: this is the second of two plasma fireballs in the beta
  {   // MT_PLASMA2
    -1,   // doomednum
    S_PLS2BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS2BALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    6*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES|MF_TRANSLUCENT, // [FG] translucent
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the evil sceptre in the beta version
  {   // MT_SCEPTRE
    2016,   // doomednum
    S_BON3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the unholy bible in the beta version
  {   // MT_BIBLE
    2017,   // doomednum
    S_BON4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    10*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },

  // [crispy] support MUSINFO lump (dynamic music changing)
  {   // MT_MUSICSOURCE
    14164,   // doomednum
    S_TNT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,    // deathsound
    0,    // speed
    16,   // radius
    16,   // height
    100,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL   // raisestate
  },

};

//----------------------------------------------------------------------------
//
// $Log: info.c,v $
// Revision 1.44  1998/05/12  12:46:36  phares
// Removed OVER_UNDER code
//
// Revision 1.43  1998/05/12  09:35:07  phares
// Corrected 4001->5001 and 4002->5002 in OVER/UNDER table
//
// Revision 1.42  1998/05/12  08:41:13  jim
// fix decl of endboom
//
// Revision 1.40  1998/05/11  12:21:20  jim
// 4001/2 deconflicted with DosDOOM
//
// Revision 1.39  1998/05/06  11:30:54  jim
// Moved predefined lump writer info->w_wad
//
// Revision 1.38  1998/05/04  21:34:49  thldrmn
// commenting and reformatting
//
// Revision 1.37  1998/05/03  23:23:50  killough
// Fix #includes at the top, nothing else
//
// Revision 1.36  1998/04/29  09:20:37  jim
// New ENDBOOM
//
// Revision 1.35  1998/04/27  02:15:10  killough
// Fix cr_gold declaration, add missing v1.1 lumps
//
// Revision 1.34  1998/04/24  08:08:36  jim
// Make text translate tables lumps
//
// Revision 1.33  1998/04/22  13:45:37  phares
// Added Setup screen Reset to Defaults
//
// Revision 1.32  1998/04/22  06:34:43  killough
// Make WritePredefinedLumpWad endian-independent, remove tabs
//
// Revision 1.31  1998/04/21  23:46:21  jim
// Predefined lump dumper option
//
// Revision 1.30  1998/04/17  00:04:11  jim
// text file changes and new ENDBOOM
//
// Revision 1.29  1998/04/12  22:54:55  phares
// Remaining 3 Setup screens
//
// Revision 1.28  1998/04/06  04:36:51  killough
// Change WATERMAP, add C_START/C_END
//
// Revision 1.27  1998/04/05  10:10:13  jim
// added STCFN096 lump
//
// Revision 1.26  1998/04/03  19:18:46  phares
// Automap Palette work, slot 0 = disable, 247 = BLACK
//
// Revision 1.25  1998/04/02  05:01:49  jim
// Added ENDOOM, BOOM.TXT mods
//
// Revision 1.24  1998/04/01  15:34:30  phares
// Added Automap Setup Screen, fixed Seg Viol in Setup Menus
//
// Revision 1.23  1998/03/31  01:08:26  phares
// Initial Setup screens and Extended HELP screens
//
// Revision 1.22  1998/03/23  18:39:10  jim
// Switch and animation tables now lumps
//
// Revision 1.21  1998/03/23  15:23:54  phares
// Changed pushers to linedef control
//
// Revision 1.20  1998/03/23  03:18:09  killough
// Add WATERMAP colormap lump for underwater viewing
//
// Revision 1.19  1998/03/09  18:30:28  phares
// Added invisible sprite for MT_PUSH
//
// Revision 1.18  1998/03/09  07:15:14  killough
// Remove unnecessary translucency lumps
//
// Revision 1.17  1998/03/04  22:23:04  phares
// Removed BOOMHELP predefined lump
//
// Revision 1.16  1998/03/04  11:52:43  jim
// Add TRAN50 TRAN66 predefined lumps
//
// Revision 1.15  1998/03/03  00:21:54  jim
// Added predefined ENDBETA lump for beta test
//
// Revision 1.13  1998/02/27  11:51:50  jim
// Add predefined lump STTMINUS
//
// Revision 1.11  1998/02/24  08:45:44  phares
// Pushers, recoil, new friction, and over/under work
//
// Revision 1.10  1998/02/24  04:13:37  jim
// Added double keys to status
//
// Revision 1.8  1998/02/23  04:31:13  killough
// Make tranlucency apply realistically
//
// Revision 1.7  1998/02/22  12:51:38  jim
// HUD control on F5, z coord, spacing change
//
// Revision 1.5  1998/02/20  21:56:49  phares
// Preliminarey sprite translucency
//
// Revision 1.4  1998/02/18  00:59:44  jim
// Addition of HUD
//
// Revision 1.3  1998/02/02  13:36:12  killough
// Add predefined lumps
//
// Revision 1.2  1998/01/26  19:23:34  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:56  rand
// Lee's Jan 19 sources
//
//----------------------------------------------------------------------------
