/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

public class GeometryHeader {
    private float scale;
    private float[] bounds;
    private boolean hasNormals;
    private boolean hasColors;
    private boolean hasCoordinates;
    private boolean hasTexCoords;

    public GeometryHeader() {
        this.bounds = new float[3];
    }

    public GeometryHeader(float f, float[] fArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.scale = f;
        this.bounds = fArray;
        this.hasCoordinates = bl;
        this.hasNormals = bl2;
        this.hasColors = bl3;
        this.hasTexCoords = bl4;
    }

    public static int getSize() {
        return 17;
    }

    public void encode(int[] nArray, int n) {
        nArray[n++] = Float.floatToIntBits(this.scale);
        nArray[n++] = Float.floatToIntBits(this.bounds[0]);
        nArray[n++] = Float.floatToIntBits(this.bounds[1]);
        nArray[n++] = Float.floatToIntBits(this.bounds[2]);
        nArray[n++] = (this.hasCoordinates ? 1 : 0) << 3 | (this.hasNormals ? 1 : 0) << 2 | (this.hasColors ? 1 : 0) << 1 | (this.hasTexCoords ? 1 : 0);
        System.out.println("Encoded flags: " + nArray[n - 1]);
    }

    public void decode(int[] nArray, int n) {
        this.scale = Float.intBitsToFloat(nArray[n++]);
        this.bounds[0] = Float.intBitsToFloat(nArray[n++]);
        this.bounds[1] = Float.intBitsToFloat(nArray[n++]);
        this.bounds[2] = Float.intBitsToFloat(nArray[n++]);
        int n2 = nArray[n++];
        System.out.println("Decoded flags: " + nArray[n2]);
        this.hasCoordinates = (n2 & 8) > 0;
        this.hasNormals = (n2 & 4) > 0;
        this.hasColors = (n2 & 2) > 0;
        this.hasTexCoords = (n2 & 1) > 0;
    }

    public boolean hasNormals() {
        return this.hasNormals();
    }

    public float[] getBounds() {
        return this.bounds;
    }

    public float getScale() {
        return this.scale;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Geometry Header: scale: ");
        stringBuffer.append(Float.toString(this.scale));
        stringBuffer.append(" bounds: (");
        stringBuffer.append(Float.toString(this.bounds[0]));
        stringBuffer.append(' ');
        stringBuffer.append(Float.toString(this.bounds[1]));
        stringBuffer.append(' ');
        stringBuffer.append(Float.toString(this.bounds[2]));
        stringBuffer.append(")");
        stringBuffer.append(" hasCoords: ");
        stringBuffer.append(this.hasCoordinates);
        stringBuffer.append(" hasNormals: ");
        stringBuffer.append(this.hasNormals);
        stringBuffer.append(" hasColors: ");
        stringBuffer.append(this.hasColors);
        stringBuffer.append(" hasTexCoords: ");
        stringBuffer.append(this.hasTexCoords);
        return stringBuffer.toString();
    }
}

