/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders;

import java.awt.Rectangle;
import javax.vecmath.Point2d;
import org.j3d.loaders.HeightMapSource;
import org.j3d.terrain.AbstractTiledTerrainData;
import org.j3d.util.interpolator.ColorInterpolator;

public class SimpleTiledTerrainData
extends AbstractTiledTerrainData {
    private int gridWidth;
    private int gridDepth;
    private int maxWidthTile;
    private int maxDepthTile;
    private float[][] heightMap;
    private ColorInterpolator colorInterp;

    public SimpleTiledTerrainData(HeightMapSource heightMapSource) {
        this.heightMap = heightMapSource.getHeights();
        float[] fArray = heightMapSource.getGridStep();
        this.gridStepX = fArray[0];
        this.gridStepY = fArray[1];
        this.gridDepth = this.heightMap.length;
        this.gridWidth = this.heightMap[0].length;
        this.calcTileSize();
    }

    public SimpleTiledTerrainData(float[][] fArray, boolean bl, Point2d point2d) {
        if (bl) {
            int n = fArray.length;
            int n2 = fArray[0].length;
            this.heightMap = new float[n][n2];
            for (int i = 0; i < n; ++i) {
                System.arraycopy(fArray[i], 0, this.heightMap[i], 0, n2);
            }
            this.gridDepth = n;
            this.gridWidth = n2;
        } else {
            this.heightMap = fArray;
            this.gridDepth = this.heightMap.length;
            this.gridWidth = this.heightMap[0].length;
        }
        this.gridStepX = point2d.x;
        this.gridStepY = point2d.y;
        this.calcTileSize();
    }

    public void getTilesAvailableBounds(Rectangle rectangle) {
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = this.maxWidthTile;
        rectangle.height = this.maxDepthTile;
    }

    public void setActiveBounds(Rectangle rectangle) {
    }

    public float getHeight(float f, float f2) {
        float f3 = f / (float)this.gridStepX;
        float f4 = f2 / (float)this.gridStepY;
        int n = (int)Math.floor(f3);
        int n2 = (int)Math.floor(f4);
        if (n < 0 || n2 < 0 || n + 1 >= this.gridWidth || n2 + 1 >= this.gridDepth) {
            return Float.NaN;
        }
        float f5 = this.heightMap[n][n2];
        float f6 = this.heightMap[n][n2 + 1];
        float f7 = this.heightMap[n + 1][n2];
        float f8 = this.heightMap[n + 1][n2 + 1];
        return (f5 + f6 + f7 + f8) * 0.25f;
    }

    public void getCoordinate(float[] fArray, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        fArray[1] = this.heightMap[n3][n4];
    }

    public void getCoordinate(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        fArray[1] = this.heightMap[n3][n4];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        fArray2[0] = (float)n / (float)(this.gridWidth - 1);
        fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
        if (n >= 0 && n2 >= 0 && n < this.gridWidth && n2 < this.gridDepth) {
            float[] fArray4 = this.colorInterp.floatRGBValue(fArray[1]);
            fArray3[0] = fArray4[0];
            fArray3[1] = fArray4[1];
            fArray3[2] = fArray4[2];
        } else {
            fArray3[0] = 1.0f;
            fArray3[1] = 1.0f;
            fArray3[2] = 1.0f;
        }
    }

    public void getCoordinateWithTexture(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (this.tileGenerator == null) {
            if (n >= this.gridWidth) {
                n5 = this.gridWidth - 1;
            } else if (n > 0) {
                n5 = n;
            }
            if (n2 >= this.gridDepth) {
                n6 = this.gridDepth - 1;
            } else if (n2 > 0) {
                n6 = n2;
            }
            fArray[1] = this.heightMap[n5][n6];
            fArray[0] = (float)n * (float)this.gridStepX;
            fArray[2] = (float)(-n2) * (float)this.gridStepY;
            fArray2[0] = (float)n / (float)(this.gridWidth - 1);
            fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
        } else {
            if (n >= this.gridWidth) {
                n5 = this.gridWidth - 1;
            } else if (n > 0) {
                n5 = n;
            }
            if (n2 >= this.gridDepth) {
                n6 = this.gridDepth - 1;
            } else if (n2 > 0) {
                n6 = n2;
            }
            fArray[1] = this.heightMap[n5][n6];
            fArray[0] = (float)n * (float)this.gridStepX;
            fArray[2] = (float)(-n2) * (float)this.gridStepY;
            fArray2[1] = n4 % 2 == 0 ? (n2 < 0 ? (n2 % 128 == 0 ? 0.0f : 1.0f + (float)(n2 % 64) / 64.0f) : (n2 % 64 == 0 && n2 % 128 != 0 ? 1.0f : (float)(n2 % 64) / 64.0f)) : (n2 <= 0 ? (n2 % 64 == 0 && n2 % 128 != 0 ? 0.0f : 1.0f + (float)(n2 % 64) / 64.0f) : (n2 % 128 == 0 ? 1.0f : (float)(n2 % 64) / 64.0f));
            fArray2[0] = n3 % 2 == 0 ? (n < 0 ? (n % 64 == 0 && n % 128 != 0 ? 0.0f : 1.0f + (float)(n % 64) / 64.0f) : (n % 128 == 0 ? 1.0f : (float)(n % 64) / 64.0f)) : (n <= 0 ? (n % 128 == 0 ? 0.0f : 1.0f + (float)(n % 64) / 64.0f) : (n % 64 == 0 && n % 128 != 0 ? 1.0f : (float)(n % 64) / 64.0f));
        }
    }

    public void getCoordinateWithColor(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        float f = this.heightMap[n3][n4];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = f;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        if (n >= 0 && n2 >= 0 && n < this.gridWidth && n2 < this.gridDepth) {
            float[] fArray3 = this.colorInterp.floatRGBValue(fArray[1]);
            fArray2[0] = fArray3[0];
            fArray2[1] = fArray3[1];
            fArray2[2] = fArray3[2];
        } else {
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray2[2] = 1.0f;
        }
    }

    public float getHeightFromGrid(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        return this.heightMap[n3][n4];
    }

    public void setColorInterpolator(ColorInterpolator colorInterpolator) {
        this.colorInterp = colorInterpolator;
        this.colorAvailable = this.colorInterp != null;
    }

    private void calcTileSize() {
        int n = 64;
        int n2 = this.gridDepth - 1;
        while (n2 % n != 0) {
            n >>= 1;
        }
        this.gridPointsPerTile = n;
        this.maxDepthTile = (this.gridDepth - 1) / n;
        this.maxWidthTile = (this.gridWidth - 1) / n;
    }
}

