/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;

public class IntersectionUtils {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;
    private Point3d wkPoint = new Point3d();
    private Vector3d wkVec = new Vector3d();
    private Vector3d v0 = new Vector3d();
    private Vector3d v1 = new Vector3d();
    private Vector3d normal = new Vector3d();
    private Vector3d diffVec = new Vector3d();
    protected Point3d pickStart;
    protected Vector3d pickDir;
    protected float[] workingCoords;
    protected int[] workingStrips;
    protected int[] workingIndicies;
    protected float[] working2dCoords;
    protected float[] wkPolygon = new float[12];
    private Matrix4d reverseTx = new Matrix4d();

    public IntersectionUtils() {
        this.pickStart = new Point3d();
        this.pickDir = new Vector3d();
    }

    public void clear() {
        this.workingCoords = null;
        this.working2dCoords = null;
        this.workingStrips = null;
        this.workingIndicies = null;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryData geometryData, Matrix4d matrix4d, Point3d point3d2, boolean bl) {
        boolean bl2 = false;
        this.reverseTx.invert(matrix4d);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        switch (geometryData.geometryType) {
            case 1: {
                bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 3, point3d2, bl);
                break;
            }
            case 2: {
                bl2 = this.rayQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 4, point3d2, bl);
                break;
            }
            case 3: {
                bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 4: {
                bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 5: {
                bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
                break;
            }
            case 6: {
                bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
            }
        }
        if (bl2) {
            matrix4d.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (fArray.length < n * 9) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(fArray, i * 9, this.wkPolygon, 0, 9);
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) continue;
            bl2 = true;
            this.diffVec.sub(point3d, this.wkPoint);
            bl2 = true;
            double d2 = this.diffVec.lengthSquared();
            if (!(d2 < d)) continue;
            d = d2;
            point3d2.set(this.wkPoint);
            if (bl) break;
        }
        return bl2;
    }

    public boolean rayQuadArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (fArray.length < n * 12) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(fArray, i * 12, this.wkPolygon, 0, 12);
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 4, this.wkPoint)) continue;
            bl2 = true;
            this.diffVec.sub(point3d, this.wkPoint);
            double d2 = this.diffVec.lengthSquared();
            if (!(d2 < d)) continue;
            d = d2;
            point3d2.set(this.wkPoint);
            if (bl) break;
        }
        return bl2;
    }

    public boolean rayTriangleStripArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            n2 += nArray[n3];
        }
        if (fArray.length < n2 * 3) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray[i] - 2; ++j) {
                System.arraycopy(fArray, n4, this.wkPolygon, 0, 9);
                if (this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) {
                    bl2 = true;
                    this.diffVec.sub(point3d, this.wkPoint);
                    double d2 = this.diffVec.lengthSquared();
                    if (d2 < d) {
                        d = d2;
                        point3d2.set(this.wkPoint);
                        if (bl) break;
                    }
                }
                n4 += 3;
            }
            n4 += 6;
        }
        return bl2;
    }

    public boolean rayTriangleFanArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            n2 += nArray[n3];
        }
        if (fArray.length < n2 * 3) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            this.wkPolygon[0] = fArray[n4];
            this.wkPolygon[1] = fArray[n4 + 1];
            this.wkPolygon[2] = fArray[n4 + 2];
            for (int j = 1; j < nArray[i] - 2; ++j) {
                this.wkPolygon[3] = fArray[n4 + j * 3];
                this.wkPolygon[4] = fArray[n4 + j * 3 + 1];
                this.wkPolygon[5] = fArray[n4 + j * 3 + 2];
                this.wkPolygon[6] = fArray[n4 + j * 3 + 3];
                this.wkPolygon[7] = fArray[n4 + j * 3 + 4];
                this.wkPolygon[8] = fArray[n4 + j * 3 + 5];
                if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) continue;
                bl2 = true;
                this.diffVec.sub(point3d, this.wkPoint);
                double d2 = this.diffVec.lengthSquared();
                if (!(d2 < d)) continue;
                d = d2;
                point3d2.set(this.wkPoint);
                if (bl) break;
            }
            n4 += nArray[i] * 3;
        }
        return bl2;
    }

    public boolean rayIndexedTriangleArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2++];
            int n4 = nArray[n2++];
            int n5 = nArray[n2++];
            this.wkPolygon[0] = fArray[n3++];
            this.wkPolygon[1] = fArray[n3++];
            this.wkPolygon[2] = fArray[n3];
            this.wkPolygon[3] = fArray[n4++];
            this.wkPolygon[4] = fArray[n4++];
            this.wkPolygon[5] = fArray[n4];
            this.wkPolygon[6] = fArray[n5++];
            this.wkPolygon[7] = fArray[n5++];
            this.wkPolygon[8] = fArray[n5];
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) continue;
            bl2 = true;
            this.diffVec.sub(point3d, this.wkPoint);
            double d2 = this.diffVec.lengthSquared();
            if (!(d2 < d)) continue;
            d = d2;
            point3d2.set(this.wkPoint);
            if (!bl) continue;
            break;
        }
        return bl2;
    }

    public boolean rayIndexedQuadArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2++] * 3;
            int n4 = nArray[n2++] * 3;
            int n5 = nArray[n2++] * 3;
            int n6 = nArray[n2++] * 3;
            this.wkPolygon[0] = fArray[n3++];
            this.wkPolygon[1] = fArray[n3++];
            this.wkPolygon[2] = fArray[n3];
            this.wkPolygon[3] = fArray[n4++];
            this.wkPolygon[4] = fArray[n4++];
            this.wkPolygon[5] = fArray[n4];
            this.wkPolygon[6] = fArray[n5++];
            this.wkPolygon[7] = fArray[n5++];
            this.wkPolygon[8] = fArray[n5];
            this.wkPolygon[9] = fArray[n6++];
            this.wkPolygon[10] = fArray[n6++];
            this.wkPolygon[11] = fArray[n6];
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 4, this.wkPoint)) continue;
            bl2 = true;
            this.diffVec.sub(point3d, this.wkPoint);
            double d2 = this.diffVec.lengthSquared();
            if (!(d2 < d)) continue;
            d = d2;
            point3d2.set(this.wkPoint);
            if (!bl) continue;
            break;
        }
        return bl2;
    }

    public boolean rayCylinder(float[] fArray, float[] fArray2, int n, float[] fArray3, float f, float[] fArray4) throws IllegalArgumentException {
        return this.rayCylinder(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2], n, fArray3, f, fArray4);
    }

    public boolean rayCylinder(Point3d point3d, Vector3d vector3d, int n, float[] fArray, float f, Point3d point3d2) throws IllegalArgumentException {
        boolean bl = this.rayCylinder(point3d.x, point3d.y, point3d.z, vector3d.x, vector3d.y, vector3d.z, n, fArray, f, this.wkPolygon);
        point3d2.x = this.wkPolygon[0];
        point3d2.y = this.wkPolygon[1];
        point3d2.z = this.wkPolygon[2];
        return bl;
    }

    private boolean rayCylinder(double d, double d2, double d3, double d4, double d5, double d6, int n, float[] fArray, float f, float[] fArray2) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                if (d4 != 1.0 || d5 != 0.0 || d6 != 0.0) break;
                return false;
            }
            case 2: {
                if (d4 != 0.0 || d5 != 1.0 || d6 != 0.0) break;
                return false;
            }
            case 3: {
                if (d4 != 0.0 || d5 != 0.0 || d6 != 1.0) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Invalid Axis ID " + n);
            }
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        switch (n) {
            case 1: {
                d7 = d5;
                d8 = d6;
                d9 = d2;
                d10 = d3;
                d11 = fArray[1];
                d12 = fArray[2];
                break;
            }
            case 2: {
                d7 = d4;
                d8 = d6;
                d9 = d;
                d10 = d3;
                d11 = fArray[0];
                d12 = fArray[2];
                break;
            }
            case 3: {
                d7 = d4;
                d8 = d5;
                d9 = d;
                d10 = d2;
                d11 = fArray[0];
                d12 = fArray[1];
            }
        }
        double d13 = d7 * d7 + d8 * d8;
        double d14 = 2.0 * (d7 * (d9 - d11) + d8 * (d10 - d12));
        double d15 = (d9 - d11) * (d9 - d11) + (d10 - d12) * (d10 - d12) - (double)(f * f);
        double d16 = d14 * d14 - 4.0 * d13 * d15;
        if (d16 < 0.0) {
            return false;
        }
        if (d16 == 0.0) {
            double d17 = -d14 / d13 * 0.5;
            fArray2[0] = (float)(d + d17 * d4);
            fArray2[1] = (float)(d2 + d17 * d5);
            fArray2[2] = (float)(d3 + d17 * d6);
        } else {
            double d18 = (-d14 - Math.sqrt(d16)) / (d13 * 2.0);
            if (d18 < 0.0) {
                d18 = (-d14 + Math.sqrt(d16)) / (d13 * 2.0);
            }
            fArray2[0] = (float)(d + d18 * d4);
            fArray2[1] = (float)(d2 + d18 * d5);
            fArray2[2] = (float)(d3 + d18 * d6);
        }
        return true;
    }

    public boolean raySphere(float[] fArray, float[] fArray2, float[] fArray3, float f, float[] fArray4) {
        return this.raySphere(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2], fArray3, f, fArray4);
    }

    public boolean raySphere(Point3d point3d, Vector3d vector3d, float[] fArray, float f, Point3d point3d2) {
        boolean bl = this.raySphere(point3d.x, point3d.y, point3d.z, vector3d.x, vector3d.y, vector3d.z, fArray, f, this.wkPolygon);
        point3d2.x = this.wkPolygon[0];
        point3d2.y = this.wkPolygon[1];
        point3d2.z = this.wkPolygon[2];
        return bl;
    }

    private boolean raySphere(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray, float f, float[] fArray2) {
        double d7 = fArray[0];
        double d8 = fArray[1];
        double d9 = fArray[2];
        double d10 = 2.0 * (d4 * (d - d7) + d5 * (d2 - d8) + d6 * (d3 - d9));
        double d11 = d4 * d4 + d5 * d5 + d6 * d6;
        double d12 = (d - d7) * (d - d7) + (d2 - d8) * (d2 - d8) + (d3 - d9) * (d3 - d9) - (double)(f * f);
        double d13 = d10 * d10 - 4.0 * d11 * d12;
        if (d13 < 0.0) {
            return false;
        }
        if (d13 == 0.0) {
            double d14 = -d10 / d11 * 0.5;
            fArray2[0] = (float)(d + d14 * d4);
            fArray2[1] = (float)(d2 + d14 * d5);
            fArray2[2] = (float)(d3 + d14 * d6);
        } else {
            double d15 = (-d10 - Math.sqrt(d13)) / (d11 * 2.0);
            if (d15 < 0.0) {
                d15 = (-d10 + Math.sqrt(d13)) / (d11 * 2.0);
            }
            fArray2[0] = (float)(d + d15 * d4);
            fArray2[1] = (float)(d2 + d15 * d5);
            fArray2[2] = (float)(d3 + d15 * d6);
        }
        return true;
    }

    public boolean rayPlane(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        return this.rayPlane(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2], fArray3, fArray4);
    }

    public boolean rayPlane(Point3d point3d, Vector3d vector3d, float[] fArray, Point3d point3d2) {
        boolean bl = this.rayPlane(point3d.x, point3d.y, point3d.z, vector3d.x, vector3d.y, vector3d.z, fArray, this.wkPolygon);
        point3d2.x = this.wkPolygon[0];
        point3d2.y = this.wkPolygon[1];
        point3d2.z = this.wkPolygon[2];
        return bl;
    }

    private boolean rayPlane(double d, double d2, double d3, double d4, double d5, double d6, float[] fArray, float[] fArray2) {
        double d7 = d4 * (double)fArray[0] + d5 * (double)fArray[1] + d6 * (double)fArray[2];
        if (d7 == 0.0) {
            return false;
        }
        double d8 = -((double)fArray[0] * d + (double)fArray[1] * d2 + (double)fArray[2] * d3 + (double)fArray[3]);
        double d9 = d8 / d7;
        if (d9 < 0.0) {
            return false;
        }
        fArray2[0] = (float)(d + d4 * d9);
        fArray2[1] = (float)(d2 + d5 * d9);
        fArray2[2] = (float)(d3 + d6 * d9);
        return true;
    }

    public boolean rayPolygon(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2) {
        if (fArray.length < n * 2) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null || this.working2dCoords.length < n * 2) {
            this.working2dCoords = new float[n * 2];
        }
        return this.rayPolygonChecked(point3d, vector3d, f, fArray, n, point3d2);
    }

    private boolean rayPolygonChecked(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2) {
        int n2;
        this.v0.x = fArray[3] - fArray[0];
        this.v0.y = fArray[4] - fArray[1];
        this.v0.z = fArray[5] - fArray[2];
        this.v1.x = fArray[6] - fArray[3];
        this.v1.y = fArray[7] - fArray[4];
        this.v1.z = fArray[8] - fArray[5];
        this.normal.cross(this.v0, this.v1);
        if (this.normal.lengthSquared() == 0.0) {
            return false;
        }
        double d = this.normal.dot(vector3d);
        if (d == 0.0) {
            return false;
        }
        this.wkVec.x = fArray[0];
        this.wkVec.y = fArray[1];
        this.wkVec.z = fArray[2];
        double d2 = this.normal.dot(this.wkVec);
        this.wkVec.set(point3d);
        double d3 = this.normal.dot(this.wkVec);
        double d4 = (d2 - d3) / d;
        if (d4 < 0.0) {
            return false;
        }
        point3d2.x = point3d.x + vector3d.x * d4;
        point3d2.y = point3d.y + vector3d.y * d4;
        point3d2.z = point3d.z + vector3d.z * d4;
        if (f != 0.0f && point3d.distance(point3d2) > (double)f) {
            return false;
        }
        double d5 = this.normal.x >= 0.0 ? this.normal.x : -this.normal.x;
        double d6 = this.normal.y >= 0.0 ? this.normal.y : -this.normal.y;
        double d7 = this.normal.z >= 0.0 ? this.normal.z : -this.normal.z;
        int n3 = d5 > d6 ? 0 : 1;
        if (n3 == 0) {
            if (d5 < d7) {
                n3 = 2;
            }
        } else if (d6 < d7) {
            n3 = 2;
        }
        int n4 = 2 * n - 1;
        switch (n3) {
            case 0: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 2] - (float)point3d2.z;
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 1] - (float)point3d2.y;
                }
                break;
            }
            case 1: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 2] - (float)point3d2.z;
                    this.working2dCoords[n4--] = fArray[n2 * 3] - (float)point3d2.x;
                }
                break;
            }
            case 2: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 1] - (float)point3d2.y;
                    this.working2dCoords[n4--] = fArray[n2 * 3] - (float)point3d2.x;
                }
                break;
            }
        }
        int n5 = 0;
        int n6 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (n2 = 0; n2 < n; ++n2) {
            float f2;
            n4 = (n2 + 1) % n;
            int n7 = n2 * 2;
            int n8 = n4 * 2;
            int n9 = n2 * 2 + 1;
            int n10 = n4 * 2 + 1;
            int n11 = (double)this.working2dCoords[n10] < 0.0 ? -1 : 1;
            if (n6 == n11) continue;
            if ((double)this.working2dCoords[n7] > 0.0 && (double)this.working2dCoords[n8] > 0.0) {
                ++n5;
            } else if (((double)this.working2dCoords[n7] > 0.0 || (double)this.working2dCoords[n8] > 0.0) && (f2 = this.working2dCoords[n7] - this.working2dCoords[n9] * (this.working2dCoords[n8] - this.working2dCoords[n7]) / (this.working2dCoords[n10] - this.working2dCoords[n9])) > 0.0f) {
                ++n5;
            }
            n6 = n11;
        }
        return n5 % 2 == 1;
    }

    private void transformPicks(Matrix4d matrix4d, Point3d point3d, Vector3d vector3d) {
        matrix4d.transform(point3d, this.pickStart);
        matrix4d.transform(vector3d, this.pickDir);
    }
}

