
#ifndef __LLCONF_H__
#define __LLCONF_H__
struct llc_var {
	char name[64];
	char value[256];
	llc_var *next;
};
struct llc_cat {
	char name[64];
	llc_var *vars;
	llc_cat *next;
};
struct llc_list {
	char name[64];
	llc_cat *cats;
	llc_list *next;
};

llc_list *conf_load(const char *file);
llc_cat *conf_load_file(const char *file);

char *conf_find_val(char *value, llc_list *root_list, const char *listname,
		    const char *catname, const char *varname);
char *conf_find_val(char *value, llc_cat *root_cat,
		    const char *catname, const char *varname);
char *conf_find_val(char *value, llc_cat *cat, const char *varname);

llc_cat *conf_find_cat(llc_cat *root_cat, const char *catname);
llc_list *conf_find_list(llc_list *root_list, const char *listname);

void conf_release_list( llc_list *list );

#endif
