# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Utility classes for testing main on windows."""

from twisted.internet import defer

from ubuntu_kylin_sso import main
from ubuntu_kylin_sso.utils.tests.test_ipc import BaseIPCTestCase


class BaseTestCase(BaseIPCTestCase):
    """The base test case with platform specific support."""

    client_class = main.UbuntuSSOClient
    service_class = lambda *a: main.UbuntuSSOProxy(None)

    @defer.inlineCallbacks
    def setUp(self):

        self.sso_service = None

        def service_factory(*args):
            """Returns the service class."""
            self.sso_service = main.UbuntuSSOService()
            return main.UbuntuSSOProxy(self.sso_service)

        self.service_class = service_factory

        yield super(BaseTestCase, self).setUp()

        # set the proxy to be the service started by the parent test class
        self.sso_service.proxy = self.service

        # patch the start of the proxy since the parent setup started it
        self.patch(self.sso_service.proxy, 'start',
                                            lambda: defer.succeed(None))

        # start the service which will perform all the required operations
        # except the proxy start
        yield self.sso_service.start()

        self.sso_client = self.client
