/*
 * Copyright (c) 2009 Communication Group and Eislab at
 * Lulea University of Technology
 *
 * Contact: Laurynas Riliskis, LTU
 * Mail: laurynas.riliskis@ltu.se
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of Communication Group at Lulea University of Technology
 *   nor the names of its contributors may be used to endorse or promote
 *    products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL STANFORD
 * UNIVERSITY OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Configuration of the RV-8564 Real-time Clock on the Mulle platform.
 * 
 * @author Henrik Makitaavola <henrik.makitaavola@gmail.com>
 */

configuration HplRV8564C
{
  provides interface HplRV8564;
}
implementation
{
  components HplRV8564P as RTCP,
             new MulleI2C2C() as I2C,
             HplM16c60GeneralIOC as IOs,
             HplM16c60InterruptC as Irqs,
             new M16c60InterruptC() as Irq,
             BusyWaitMicroC;

  Irq.HplM16c60Interrupt -> Irqs.Int0;

  HplRV8564 = RTCP;
  RTCP.CLKOE -> IOs.PortP47;
  RTCP.CLKOUT -> IOs.PortP92;
  RTCP.GpioInterrupt -> Irq;
  RTCP.I2C -> I2C;
  RTCP.I2CResource -> I2C;
  RTCP.BusyWait -> BusyWaitMicroC;

  components PlatformC, RealMainP;
  PlatformC.SubInit -> RTCP.Init;
  RealMainP.SoftwareInit -> RTCP.Startup;
}
