from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ROPE_PREFS = _Mock()

STDERR = _Mock()

_ = _Mock()

dependencies = _Mock()

encoding = _Mock()

fallback = _Mock()

get_conf_path = _Mock()

log_dt = _Mock()

log_last_error = _Mock()

programs = _Mock()

rope = _Mock()

rope_patch = _Mock()

time = _Mock()

DEBUG_EDITOR = _Mock()

LOG_FILENAME = u'/home/cpascual/.spyder2/introspection.log'

PY2 = _Mock()

ROPE_REQVER = '>=0.9.2'

class IntrospectionPlugin(_Mock):
  pass
  name = 'fallback'

class RopePlugin(_Mock):
  pass
  name = 'rope'

