/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "WcEntry.h"

// svn


namespace svn
{

WcEntry::WcEntry()
{
}
  
WcEntry::WcEntry( svn_wc_entry_t* entry )
{
  _name        = sc::String(entry->name);
  _revision    = entry->revision;
  _url         = sc::String(entry->url);
  _reposUrl    = sc::String(entry->repos);
  _uuid        = sc::String(entry->uuid);
  _kind        = (NodeKind)entry->kind;

  _schedule    = (WcSchedule)entry->schedule;
  _copied      = 1 == entry->copied;
  _deleted     = 1 == entry->deleted;
  _absent      = 1 == entry->absent;
  _incomplete  = 1 == entry->incomplete;

  _copyFromUrl = sc::String(entry->copyfrom_url);
  _copyFromRev = entry->copyfrom_rev;

  _conflictOld = sc::String(entry->conflict_old);
  _conflictNew = sc::String(entry->conflict_new);
  _conflictWrk = sc::String(entry->conflict_wrk);

  _propReject  = sc::String(entry->prejfile);

  _textTime    = entry->text_time;
  _propTime    = entry->prop_time;

  _checksum    = sc::String(entry->checksum);

  _cmtRevision = entry->cmt_rev;
  _cmtDate     = entry->cmt_date;
  _cmtAuthor   = sc::String(entry->cmt_author);

  _lockToken   = sc::String(entry->lock_token);
  _lockOwner   = sc::String(entry->lock_owner);
  _lockComment = sc::String(entry->lock_comment);
  _lockTime    = entry->lock_creation_date;
}

WcEntry::WcEntry( const WcEntry& src )
{
  _name        = src._name;
  _revision    = src._revision;
  _url         = src._url;
  _reposUrl    = src._reposUrl;
  _uuid        = src._uuid;
  _kind        = src._kind;

  _schedule    = src._schedule;
  _copied      = src._copied;
  _deleted     = src._deleted;
  _absent      = src._absent;
  _incomplete  = src._incomplete;

  _copyFromUrl = src._copyFromUrl;
  _copyFromRev = src._copyFromRev;

  _conflictOld = src._conflictOld;
  _conflictNew = src._conflictNew;
  _conflictWrk = src._conflictWrk;

  _propReject  = src._propReject;

  _textTime    = src._textTime;
  _propTime    = src._propTime;

  _checksum    = src._checksum;

  _cmtRevision = src._cmtRevision;
  _cmtDate     = src._cmtDate;
  _cmtAuthor   = src._cmtAuthor;

  _lockToken   = src._lockToken;
  _lockOwner   = src._lockOwner;
  _lockComment = src._lockComment;
  _lockTime    = src._lockTime;
}

Revnumber WcEntry::getRevnumber() const
{
  return _revision;
}

NodeKind WcEntry::getKind() const
{
  return _kind;
}

bool WcEntry::isDir() const
{
  return getKind() == svn::Node_Dir;
}

const sc::String& WcEntry::getUrl() const
{
  return _url;
}

Revnumber WcEntry::getCmtRevnumber() const
{
  return _cmtRevision;
}

const sc::String& WcEntry::getCmtAuthor() const
{
  return _cmtAuthor;
}

const sc::String& WcEntry::getConflictOld() const
{
  return _conflictOld;
}

const sc::String& WcEntry::getConflictNew() const
{
  return _conflictNew;
}

const sc::String& WcEntry::getConflictWrk() const
{
  return _conflictWrk;
}

const sc::String& WcEntry::getLockToken() const
{
  return _lockToken;
}



} // namespace
