/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEW_ITEM_H
#define _SC_WCVIEW_ITEM_H

// sc
#include "subcommander/WcViewItem.h"

// qt
#include <QtCore/QList>

namespace wcview
{
typedef unsigned int Index;

class Item
{
public:
  virtual ~Item () {}

  virtual const sc::String& getName () const = 0;
  virtual const WcViewItemPtr& getViewItem () const = 0;

  virtual Item* getParent () const = 0;
  virtual Index getParentIndex () const = 0;

  virtual Index getChildCount () const = 0;
  virtual Item* getChild (const Index& index) const = 0;
  virtual Item* getChild (const sc::String& name) const = 0;
  virtual Index getChildIndex (const sc::String& name) const = 0;

  virtual void insertChild (Item* item) = 0;
//  virtual void updateChild (Item* item) = 0;
//  virtual void removeChild (const sc::String& name) = 0;



//  virtual Item* findChild (const sc::String& path) const = 0;
//  virtual const WcViewItemPtr& getChild( const ItemIndex& index ) const = 0;
//  virtual const WcViewItemPtr& getChild( const sc::String& name ) const = 0;
};

// todo move to own cpp file
class BadIndexException
{
public:
  BadIndexException (const Index& index) : _index(index)
  {
  }

  virtual ~BadIndexException() {}

  virtual Index getBadIndex() const
  {
    return _index;
  }

private:
  Index _index;
};

class BadNameException
{
public:
  BadNameException (const sc::String& name) : _name(name)
  {
  }

  virtual ~BadNameException() {}

  virtual const sc::String& getBadName() const
  {
    return _name;
  }

private:
  sc::String _name;
};


/** the child item list of an @a Item. */
typedef QList<Item*> Items;

} // namespace

#endif // _SC_WCVIEW_ITEM_H
