/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "WcStatusCache.h"
#include "WcStatusInfo.h"
#include "util/Mutex.h"
#include "util/Guard.h"

// sys
#include <map>

typedef std::map< sc::String, WcStatusInfo > Infos;


struct WcStatusCache::Member
{
  sc::Mutex lock;
  Infos     infos;
};

static WcStatusInfo NullInfo( sc::String(""), 0, svn::WcStatuss() );


WcStatusCache::WcStatusCache()
{
  _m = new WcStatusCache::Member();
}

WcStatusCache::~WcStatusCache()
{
  delete _m;
}

void WcStatusCache::set( const WcStatusInfo& info )
{
  sc::Guard<sc::Mutex> guard(_m->lock);

  Infos::iterator it = _m->infos.find(info.getPath());  
  if( it != _m->infos.end() )
  {
    (*it).second = info;
  }
  else
  {
    _m->infos.insert( Infos::value_type(info.getPath(),info) );
  }
}

WcStatusInfo WcStatusCache::get( const sc::String& key )
{
  sc::Guard<sc::Mutex> guard(_m->lock);

  Infos::iterator it = _m->infos.find(key);  

  if( it == _m->infos.end() )
  {
    return NullInfo;
  }

  return (*it).second;
}
