/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ProjectPropertiesDialog.h"
#include "settings/ProjectSettingsWidget.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <Qt3Support/Q3GroupBox>



ProjectPropertiesDialog::ProjectPropertiesDialog( Project* project,
  const QString& title, ExternProvider* p, QWidget *parent, const char *name )
: super( parent, name, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu )
{
  // "subcommander:project properties"
  setCaption( title );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("project settings: ") );
    //gb->setInsideSpacing(10);
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,1,1);
    gl->setMargin(0);
    //gl->setRowStretch( 1, 1 );
    {
      ProjectSettingsWidget* psw = new ProjectSettingsWidget( p, this );
      psw->setProject(project);
      gl->addWidget(psw,0,0);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      QPushButton * _ok = new QPushButton(this);
      //_ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      //hu->addSpacing(5);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

ProjectPropertiesDialog::~ProjectPropertiesDialog()
{
}
