/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "ProjectReaderTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/settings/ProjectReader.h"
#include "subcommander/Project.h"
#include "sublib/config/Config.h"
#include "sublib/config/ConfigData.h"
#include "util-test/AssertionTraitUuid.h"


class ProjectReaderTestConfig : public Config
{
public:
  void get( ConfigValues& v )
  {
    push( v, "project.0.guid", "e7380f2c-5bf6-0310-a2d6-b2464cb4a0ca" );
    push( v, "project.0.name", "Subcommander" );

    push( v, "project.1.guid", "c8a7d8dd-7018-3242-935d-42ea3470c315" );
    push( v, "project.1.name", "Subversion" );
  }

  void set( const ConfigValues& values )
  {
  }

private:
  void push( ConfigValues& v, const char* key, const char* val )
  {
    v.push_back(_(key,val));
  }

  ConfigValue _( const char* key, const char* val )
  {
    return ConfigValue(sc::String(key),sc::String(val));
  }
};

void ProjectReaderTest::setUp()
{
  _cfg  = new ProjectReaderTestConfig();
  _data = new ConfigData(_cfg);
  _data->load();
}

void ProjectReaderTest::tearDown()
{
  delete _data;
  delete _cfg;
}

void ProjectReaderTest::testSimpleProjectRoot()
{
  ProjectReader reader(_data,true);
  reader.readProjects();

  Projects projects;
  reader.getProjects(projects);

  CPPUNIT_ASSERT( projects.size() >= 1 );

  Project* prj = projects[0];
  CPPUNIT_ASSERT_EQUAL( Uuid("e7380f2c-5bf6-0310-a2d6-b2464cb4a0ca"),
    prj->getId() );
  CPPUNIT_ASSERT_EQUAL( sc::String("Subcommander"), prj->getName() );
}

void ProjectReaderTest::testMultipleProjectRoot()
{
  ProjectReader reader(_data,true);
  reader.readProjects();

  Projects projects;
  reader.getProjects(projects);

  CPPUNIT_ASSERT_EQUAL( 2L, (long)projects.size() );

  Project* prj = projects[0];
  CPPUNIT_ASSERT_EQUAL( Uuid("e7380f2c-5bf6-0310-a2d6-b2464cb4a0ca"),
    prj->getId() );
  CPPUNIT_ASSERT_EQUAL( sc::String("Subcommander"), prj->getName() );

  prj = projects[1];
  CPPUNIT_ASSERT_EQUAL( Uuid("c8a7d8dd-7018-3242-935d-42ea3470c315"),
    prj->getId() );
  CPPUNIT_ASSERT_EQUAL( sc::String("Subversion"), prj->getName() );
}
