/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _MOCK_SIGNAL_TARGET_H
#define _MOCK_SIGNAL_TARGET_H

// sc
#include "SignalTarget.h"

// gmock
#include <gmock/gmock.h>


class MockSignalTarget : SignalTarget
{
public:
  MockSignalTarget(QObject* target) : SignalTarget(target) {}

  MOCK_METHOD0(modelAboutToBeReset, void());
  MOCK_METHOD0(modelReset, void());
  MOCK_METHOD0(layoutAboutToBeChanged,void());
  MOCK_METHOD0(layoutChanged,void());
  MOCK_METHOD3(rowsAboutToBeInserted,void(const QModelIndex& srcParent,int start,int end));
  MOCK_METHOD3(rowsInserted,void(const QModelIndex& srcParent,int start,int end));
};


#endif // _MOCK_SIGNAL_TARGET_H
