/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _INDEX_EQ_H
#define _INDEX_EQ_H

// gmock
#include <gmock/gmock.h>

// qt
#include <QtCore/QModelIndex>


class IndexEqMatcher :
  public testing::MatcherInterface<const QModelIndex&>
{
public:
  explicit IndexEqMatcher(int row, int col)
    : _row(row), _col(col)
  {
  }

  bool Matches(const QModelIndex& index) const
  {
    return index.row() == _row && index.column() == _col;
  }

  void DescribeTo(std::ostream* os) const
  {
    *os << "row()/column() equal " << _row << "/" << _col;
  }

private:
  int _row;
  int _col;
};


testing::Matcher<const QModelIndex&> IndexEq(int row, int col);

#endif // _INDEX_EQ_H
