#! /usr/bin/ruby -w

## ====================================================================
## Copyright (c) 2008       Martin Hauner
##                          http://subcommander.tigris.org
##
## Subcommander is licensed as described in the file doc/COPYING, which
## you should have received as part of this distribution.
## ====================================================================
##
## Windows build: create Subcommander locale files.
##
## Run from Subcommander root directory.
##

require 'find'


puts "collecting source files with localizable strings."
puts

sources = []
Find.find( "subcommander", "submerge", "sublib", "svn", "util", "win32st"  ) do |f|
  # skip any file in a "moc" or ".svn" directory
  Find.prune if f =~ /.*\/moc\W/
  Find.prune if f =~ /.*\/\.svn\W/

  if f =~ /.*(\.h|\.cpp)$/ then
    sources << f
  end
end


puts
puts "creating Subcommander.pot."
puts

cmd = "xgettext"
cmd << " --sort-by-file"
cmd << " -d Subcommander"
cmd << " --msgid-bugs-address=dev@subcommander.tigris.org"
cmd << " --add-comments"
cmd << " --qt"
cmd << " -k_ -k_q -k_s -k_n --flag=_:1:pass-c-format"
cmd << " --files-from=- -o po/Subcommander.pot"
puts cmd

gettext = IO.popen cmd, "w+"
gettext.puts sources
gettext.close_write

if gettext.gets then
  puts gettext.gets
end


puts
puts "merging differences to po files."
puts

Find.find( "po" ) do |f|
  if f =~ /.*\.po$/ then
    
    cmd = "msgmerge --sort-by-file --update #{f} po/Subcommander.pot"
    puts cmd
    msgmerge = IO.popen cmd, "r+"

    if msgmerge.gets then
      puts msgmerge.gets
    end
  end
end


puts
puts "creating mo files."
puts

Find.find( "po" ) do |f|
  if f =~ /.*\/(.*)\.po$/ then
    l = $1
    
    cmd = "msgfmt --check --statistics -o po/#{l}.mo #{f}"
    puts cmd
    msgfmt = IO.popen cmd, "r+"

    if msgfmt.gets then
      puts msgfmt.gets
    end
  end
end
