/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.nxg.unity.SimpleUnit;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitRepresentation;

public class SimpleBinaryUnit
extends SimpleUnit {
    private static final Pattern unitWithPrefix = Pattern.compile("([KMGTPEZY])i(.+)");

    SimpleBinaryUnit(UnitDefinitionMap.Resolver resolver, int n, String string, UnitDefinition unitDefinition, float f) {
        super(resolver, n, string, unitDefinition, f, false);
    }

    @Override
    SimpleBinaryUnit reciprocate() {
        assert (!this.isQuoted());
        return new SimpleBinaryUnit(this.getUnitResolver(), this.getPrefix(), this.getBaseUnitString(), this.getBaseUnitDefinition(), -this.getExponent());
    }

    @Override
    SimpleBinaryUnit pow(double d) {
        assert (!this.isQuoted());
        return new SimpleBinaryUnit(this.getUnitResolver(), this.getPrefix(), this.getBaseUnitString(), this.getBaseUnitDefinition(), (float)d);
    }

    @Override
    boolean hasPermittedPrefix(UnitRepresentation unitRepresentation) {
        return this.getPrefix() == 0 || unitRepresentation.mayHaveBinaryPrefixes();
    }

    static SimpleUnit.PrefixSplit splitUnitString(String string) {
        final Matcher matcher = unitWithPrefix.matcher(string);
        if (matcher.matches()) {
            int n;
            char c = matcher.group(1).charAt(0);
            switch (c) {
                case 'K': {
                    n = 10;
                    break;
                }
                case 'M': {
                    n = 20;
                    break;
                }
                case 'G': {
                    n = 30;
                    break;
                }
                case 'T': {
                    n = 40;
                    break;
                }
                case 'P': {
                    n = 50;
                    break;
                }
                case 'E': {
                    n = 60;
                    break;
                }
                case 'Z': {
                    n = 70;
                    break;
                }
                case 'Y': {
                    n = 80;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Impossible binary prefix: '" + c + "i'"));
                }
            }
            final int n2 = n;
            String string2 = matcher.group(2);
            return new SimpleUnit.PrefixSplit(){

                @Override
                public int getPower() {
                    return n2;
                }

                @Override
                public boolean isBinaryPrefix() {
                    return true;
                }

                @Override
                public String getUnit() {
                    return matcher.group(2);
                }
            };
        }
        return null;
    }

    @Override
    String prefixPowerToString() {
        String string;
        switch (this.getPrefix()) {
            case 10: {
                string = "Ki";
                break;
            }
            case 20: {
                string = "Mi";
                break;
            }
            case 30: {
                string = "Gi";
                break;
            }
            case 40: {
                string = "Ti";
                break;
            }
            case 50: {
                string = "Pi";
                break;
            }
            case 60: {
                string = "Ei";
                break;
            }
            case 70: {
                string = "Zi";
                break;
            }
            case 80: {
                string = "Yi";
                break;
            }
            default: {
                throw new AssertionError((Object)("Impossible decimal prefix power: " + this.getPrefix()));
            }
        }
        return string;
    }

    @Override
    String prefixPowerToStringLaTeX() {
        String string;
        switch (this.getPrefix()) {
            case 10: {
                string = "\\kibi";
                break;
            }
            case 20: {
                string = "\\mebi";
                break;
            }
            case 30: {
                string = "\\gibi";
                break;
            }
            case 40: {
                string = "\\tebi";
                break;
            }
            case 50: {
                string = "\\pebi";
                break;
            }
            case 60: {
                string = "\\exbi";
                break;
            }
            case 70: {
                string = "\\zebi";
                break;
            }
            case 80: {
                string = "\\yobi";
                break;
            }
            default: {
                throw new AssertionError((Object)("Impossible binary prefix power: " + this.getPrefix()));
            }
        }
        return string;
    }
}

