/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

public class DBType {
    public static final int NO_LENGTH = -1;
    public final DBDatatype type;
    public final int length;

    public DBType(DBDatatype datatype) {
        this(datatype, -1);
    }

    public DBType(DBDatatype datatype, int length) {
        if (datatype == null) {
            throw new NullPointerException("Missing TAP column datatype !");
        }
        this.type = datatype;
        this.length = length;
    }

    public boolean isNumeric() {
        switch (this.type) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case UNKNOWN_NUMERIC: {
                return true;
            }
        }
        return false;
    }

    public boolean isBinary() {
        switch (this.type) {
            case BINARY: 
            case VARBINARY: 
            case BLOB: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        switch (this.type) {
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }

    public boolean isGeometry() {
        switch (this.type) {
            case POINT: 
            case CIRCLE: 
            case POLYGON: 
            case REGION: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnknown() {
        return this.type == DBDatatype.UNKNOWN || this.type == DBDatatype.UNKNOWN_NUMERIC;
    }

    public boolean isCompatible(DBType t) {
        if (t == null) {
            return false;
        }
        if (this.isUnknown() || t.isUnknown()) {
            return true;
        }
        if (this.isBinary() && t.isBinary()) {
            return this.type == DBDatatype.BLOB && t.type == DBDatatype.BLOB || this.type != DBDatatype.BLOB && t.type != DBDatatype.BLOB;
        }
        if (this.isNumeric() && t.isNumeric()) {
            return true;
        }
        if (this.isGeometry() && t.isGeometry()) {
            return this.type == t.type;
        }
        if (this.isString() && t.isString()) {
            return this.type == DBDatatype.CLOB && t.type == DBDatatype.CLOB || this.type != DBDatatype.CLOB && t.type != DBDatatype.CLOB;
        }
        return this.type == t.type;
    }

    public String toString() {
        if (this.length > 0) {
            return (Object)((Object)this.type) + "(" + this.length + ")";
        }
        return this.type.toString();
    }

    public static enum DBDatatype {
        SMALLINT,
        INTEGER,
        BIGINT,
        REAL,
        DOUBLE,
        BINARY,
        VARBINARY,
        CHAR,
        VARCHAR,
        BLOB,
        CLOB,
        TIMESTAMP,
        POINT,
        CIRCLE,
        POLYGON,
        REGION,
        UNKNOWN,
        UNKNOWN_NUMERIC;

        private String strExp = this.name();

        public String toString() {
            return this.strExp;
        }

        public void setCustomType(String typeName) {
            if (this == UNKNOWN || this == UNKNOWN_NUMERIC) {
                this.strExp = typeName != null && typeName.trim().length() > 0 ? "?" + typeName.trim() + "?" : this.name();
            }
        }
    }
}

