/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

/** @file
* This file is Plasma Applet for Account Skroogoid
*
* @author Siddharth SHARMA
*/

#include "adviceskroogoid.h"
#include "skgdocumentbank.h"
#include "skgservices.h"
#include "skgmainpanel.h"
#include "skgtraces.h"

#include <QGraphicsLinearLayout>
#include <QGraphicsProxyWidget>
#include <QGraphicsGridLayout>
#include <QToolButton>
#include <QPushButton>
#include <QAction>
#include <QApplication>
#include <KMenu>
#include <KMessageBox>

AdviceSkroogoid::AdviceSkroogoid(QObject* iParent, const QVariantList& args)
    : Plasma::Applet(iParent, args), doc(NULL), widgetLayout(NULL)
{}

void AdviceSkroogoid::init()
{
    if (widgetLayout == NULL) {
        widgetLayout = new QGraphicsLinearLayout(Qt::Vertical);
        setLayout(widgetLayout);

        // Load the dataengine that contains data we need
        Plasma::DataEngine* engine = dataEngine("skgdataengine");
        if (engine->isValid())  engine->connectSource("Advices", this);
    }
}

void AdviceSkroogoid::addAdviceLine(const QString uuid)
{
    // Set the icon to display depending on the priority
    int priority = listData[uuid].at(0).toInt();
    QString icon;
    QString priorityChar;

    if (priority == -1) {
        priorityChar = 'D';
        icon = "dialog-information";
    } else if (priority >= 8) {
        priorityChar = 'A';
        icon = "security-low";
    } else if (priority <= 4) {
        priorityChar = 'C';
        icon = "security-high";
    } else {
        priorityChar = 'B';
        icon = "security-medium";
    }

    QGraphicsLinearLayout* groupLayout;
    if (priorityGroups.keys().contains(priorityChar)) {
        groupLayout = static_cast< QGraphicsLinearLayout* >(priorityGroups[priorityChar]->layout());
    } else {
        Plasma::Frame* groupFrame = new Plasma::Frame();
        groupFrame->setFrameShadow(Plasma::Frame::Raised);

        groupLayout = new QGraphicsLinearLayout(Qt::Vertical);
        groupFrame->setLayout(groupLayout);
        priorityGroups[priorityChar] = groupFrame;
    }

    QGraphicsLinearLayout* lineLayout = new QGraphicsLinearLayout(Qt::Horizontal);
    groupLayout->addItem(lineLayout);

    // The button for this advice
    Plasma::ToolButton* adviceButton = new Plasma::ToolButton();
    lineLayout->addItem(adviceButton);
    adviceButton->setIcon(KIcon(icon));


    // The layout for label for the advice content and action buttons
    QGraphicsLinearLayout* labelAndActionsLayout = new QGraphicsLinearLayout(Qt::Vertical);
    lineLayout->addItem(labelAndActionsLayout);

    // The label for this advice
    Plasma::Label* shortMessageLabel = new Plasma::Label();
    labelAndActionsLayout->addItem(shortMessageLabel);
    shortMessageLabel->setText(listData[uuid].at(1).toString());

    // Define the tooltip for the advice
    QString toolTip = "<b>" % i18nc("Noun, a numerical value indicating the priority level", "Priority") % SKGServices::intToString(priority) % " : </b>" % listData[uuid].at(2).toString();
    shortMessageLabel->setToolTip(toolTip);
    adviceButton->setToolTip(toolTip);

    // The Plasma::Frame for the actions. Hidden per default, and displayed only
    // when adviceButton is clicked
    Plasma::Frame* actionsFrame = new Plasma::Frame();
    labelAndActionsLayout->addItem(actionsFrame);
    QGraphicsGridLayout* actionsLayout = new QGraphicsGridLayout();
    actionsFrame->setLayout(actionsLayout);


    QStringList actionsList = listData[uuid].at(3).toStringList();
    for (int i = 0 ; i < actionsList.count() ; ++i) {

        Plasma::ToolButton* actionButton = new Plasma::ToolButton();
        actionButton->setIcon(KIcon("system-run"));
        actionsLayout->addItem(actionButton, i, 0);

        QString actionString = actionsList.at(i);
        Plasma::Label* actionLabel = new Plasma::Label();
        actionLabel->setText(actionString);
        actionsLayout->addItem(actionLabel, i, 1);

    }
}

void AdviceSkroogoid::dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData)
{
    if (sourceName != "Advices" || !widgetLayout) return;
    SKGTRACEIN(1, "AdviceSkroogoid::dataUpdated");
    listData.clear();
    priorityGroups.clear();
    for (int i = 0 ; i < engineData.keys().count() ; ++i) {

        QString adviceId = engineData.keys().at(i);
        QVariant adviceValuesVariant = engineData.value(adviceId);
        QVariantList adviceValues = adviceValuesVariant.value<QVariantList>();

        listData[adviceId] = adviceValues;
    }

    // Initialisation
    int nb = widgetLayout->count();
    for (int i = 0; widgetLayout && i < nb; ++i) {
        QGraphicsLayoutItem* item = widgetLayout->itemAt(0);
        if (item) {
            widgetLayout->removeItem(item);
            delete item;
        }
    }
    nb = listData.count();
    for (int i = 0 ; i < nb ; ++i) {
        addAdviceLine(listData.keys().at(i));
    }

    QStringList priorities = priorityGroups.keys();
    priorities.sort();

    for (int i = 0 ; i < priorities.count() ; ++i) {
        QString priority = priorities.at(i);
        widgetLayout->addItem(priorityGroups[priority]);
    }

    widgetLayout->addStretch(2);
}

AdviceSkroogoid::~AdviceSkroogoid()
{
}


#include "adviceskroogoid.moc"
