/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
import QtQuick 1.1
import org.kde.plasma.components 0.1 as PlasmaComponents
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets
import org.kde.plasma.core 0.1 as PlasmaCore
 
Item {
    id: mainWidget
    property int minimumWidth: 300
    property int minimumHeight: 200
    
    PlasmaCore.DataSource {
        id: advicesSource
        engine: "skgdataengine"
        interval: 0
        connectedSources: ["Advices"]
    }
    
    PlasmaCore.SortFilterModel {
        id: advicesModel
        sourceModel: PlasmaCore.DataModel {
            dataSource: advicesSource
            keyRoleFilter: "[\\w]*"
            
        }
        sortRole: "priority"
    }
    
    ListView {
        id: list
        anchors {
            top: parent.top
            bottom: parent.bottom
            left: parent.left
            right: scroll.left
        }    
        model: advicesModel
        spacing: 2
        clip: true
        
        // For each row, display the advice
        delegate: PlasmaComponents.ListItem {
            id: adviceItem
            enabled: true
            Text {
                id: shorttext
                width: parent.width
                text: shortmessage
                wrapMode: Text.Wrap
            }
            Text {
                id: longtext
//                 visible: false
                width: parent.width
                text: longmessage
                wrapMode: Text.Wrap
                anchors {
                    top: shorttext.anchors.bottom
                }
            }
        }
        
        
        // Group advices per priority group
        section {
            property: "prioritygroup"
            criteria: ViewSection.FullString
            delegate: Row {
                PlasmaWidgets.IconWidget {
                    id: icon
                    width:24
                    height:24
                    Component.onCompleted: {
                        switch(section){
                            case "High":
                               icon.setIcon("task-reject")
                            break
                            case "Medium":
                                icon.setIcon("task-attention")
                            break
                            case "Low":
                                icon.setIcon("task-complete")
                            break
                            default:
                                icon.setIcon("dialog-information")
                            break
                        }
                    }
                }
                Text { 
                    font.bold: true
                    text: section
                    anchors.verticalCenter: icon.verticalCenter
                }    
            }
            
        }
    }

    PlasmaComponents.ScrollBar {
        id: scroll
        flickableItem: list
        orientation: Qt.Vertical
            anchors {
            top: parent.top
            bottom: parent.bottom
            right: parent.right
         }
    }   
}
