/************************************************************************
 *
 * Copyright (C) 2009-2016 IRCAD France
 * Copyright (C) 2012-2016 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#ifndef __FWDICOMIOFILTER_NAMESPACE_HPP__
#define __FWDICOMIOFILTER_NAMESPACE_HPP__

/**
 * @brief fwDicomIOFilter contains filters used to pre-process images before reading.
 */
namespace fwDicomIOFilter
{

/**
 * @brief composite contains composite filters.
 */
namespace composite
{
} // namespace composite

/**
 * @brief custom contains custom filters.
 */
namespace custom
{
} // namespace custom

/**
 * @brief exceptions contains filter exceptions.
 */
namespace exceptions
{
} // namespace exceptions

/**
 * @brief helper contains filter helpers.
 */
namespace helper
{
} // namespace helper

/**
 * @brief modifier contains modifiers used to alter tag values before reading.
 */
namespace modifier
{
} // namespace modifier

/**
 * @brief sorter contains sorters used to sort instances.
 */
namespace sorter
{
} // namespace sorter

/**
 * @brief splitter contains splitters to split images.
 */
namespace splitter
{
} // namespace splitter

/**
 * @brief contains factory utilities.
 */
namespace factory
{
} // namespace factory

/**
 * @brief contains registry details
 */
namespace registry
{
} // namespace registry

} // namespace fwDicomIOFilter

#endif /* __FWDICOMIOFILTER_NAMESPACE_HPP__ */

