(define-interface low-odbc-interface
  (export

   ;;; data types
   environment-handle?
   environment-handle-handle

   connection-handle?
   connection-handle-handle
   connection-handle-environment
   connection-handle-connected?

   statement-handle?
   statement-handle-handle
   statement-handle-connection

   odbc-handle?
   odbc-handle
   handle-record-type->c-handle-identifier

   odbc-column?
   odbc-column-name
   odbc-column-type
   odbc-column-size
   odbc-column-digits
   odbc-column-nullable?

   odbc-parameter?
   odbc-parameter-type
   odbc-parameter-size
   odbc-parameter-digits
   odbc-parameter-nullable

   ;;; errors, conditions
   odbc-error?
   odbc-api-version-mismatch?
   odbc-unknown-integer-type?
   odbc-buffer-alloc-error?
   odbc-unknown-c-type-identifier-error?
   odbc-bindcol-unbound-column-error?
   odbc-bindcol-rebinding-error?

   ;; functions
   odbc-alloc-environment-handle
   odbc-alloc-connection-handle
   odbc-alloc-statement-handle
   odbc-sql-connect
   odbc-sql-browse-connect

   odbc-sql-data-sources
   odbc-sql-drivers
   odbc-sql-get-info-int
   odbc-sql-get-info-string
   odbc-sql-get-func
   odbc-sql-get-type-info

   odbc-sql-set-connect-attr-string
   odbc-sql-set-connect-attr-int
   odbc-sql-get-connect-attr-string
   odbc-sql-get-connect-attr-int
   odbc-sql-set-env-attr-int
   odbc-sql-get-env-attr-int
   odbc-sql-set-stmt-attr-string
   odbc-sql-set-stmt-attr-int
   odbc-sql-get-stmt-attr-int
   odbc-sql-get-stmt-attr-string

   odbc-sql-get-desc-field-int
   odbc-sql-get-desc-field-string

   odbc-sql-prepare
   odbc-sql-get-cursor-name
   odbc-sql-set-cursor-name

   odbc-sql-execute
   odbc-sql-execute-direct
   odbc-sql-native-sql
   odbc-sql-describe-param
   odbc-sql-num-params

   odbc-sql-row-count
   odbc-sql-get-data
   odbc-sql-set-pos
   odbc-sql-bulk-operations
   odbc-sql-more-results
   odbc-sql-fetch
   odbc-sql-bindcol
   
   odbc-sql-column-privileges
   odbc-sql-columns
   odbc-sql-foreign-keys
   odbc-sql-primary-keys
   odbc-sql-procedure-columns
   odbc-sql-procedures
   odbc-sql-special-columns
   odbc-sql-statistics
   odbc-sql-table-privileges
   odbc-sql-tables

   odbc-sql-free-statement
   odbc-sql-close-cursor
   odbc-sql-cancel
   odbc-sql-num-result-cols
   odbc-sql-describe-col
   odbc-sql-col-attribute
   
   odbc-sql-disconnect
   odbc-sql-free-handle
   odbc-sql-get-diag-recs
   
   odbc-call-successful?
   raise-odbc-api-version-mismatch-error
   raise-odbc-unknown-integer-type-error
   raise-odbc-buffer-alloc-error
   raise-odbc-unknown-c-type-identifier-error
   raise-odbc-bindcol-unbound-column-error
   raise-odbc-bindcol-rebinding-error

   odbc-set-initial-retval-buffer-size
   odbc-get-initial-retval-buffer-size))

;;;

(define-interface low-odbc-constants-interface
  (export
   sql-null-data
   sql-data-at-exec
   sql-success
	sql-success-with-info
	sql-no-data
	sql-error
	sql-invalid-handle
	sql-still-executing
	sql-need-data
	sql-nts
	sql-ntsl
	sql-max-message-length
	sql-date-len
	sql-time-len
	sql-timestamp-len
	sql-handle-env
	sql-handle-dbc
	sql-handle-stmt
	sql-handle-desc
	sql-attr-output-nts
	sql-attr-auto-ipd
	sql-attr-metadata-id
	sql-attr-app-row-desc
	sql-attr-app-param-desc
	sql-attr-imp-row-desc
	sql-attr-imp-param-desc
	sql-attr-cursor-scrollable
	sql-attr-cursor-sensitivity
	sql-nonscrollable
	sql-scrollable
	sql-desc-count
	sql-desc-type
	sql-desc-length
	sql-desc-octet-length-ptr
	sql-desc-precision
	sql-desc-scale
	sql-desc-datetime-interval-code
	sql-desc-nullable
	sql-desc-indicator-ptr
	sql-desc-data-ptr
	sql-desc-name
	sql-desc-unnamed
	sql-desc-octet-length
	sql-desc-alloc-type
	sql-diag-returncode
	sql-diag-number
	sql-diag-row-count
	sql-diag-sqlstate
	sql-diag-native
	sql-diag-message-text
	sql-diag-dynamic-function
	sql-diag-class-origin
	sql-diag-subclass-origin
	sql-diag-connection-name
	sql-diag-server-name
	sql-diag-dynamic-function-code
	sql-diag-alter-domain
	sql-diag-alter-table
	sql-diag-call
	sql-diag-create-assertion
	sql-diag-create-character-set
	sql-diag-create-collation
	sql-diag-create-domain
	sql-diag-create-index
	sql-diag-create-schema
	sql-diag-create-table
	sql-diag-create-translation
	sql-diag-create-view
	sql-diag-delete-where
	sql-diag-drop-assertion
	sql-diag-drop-character-set
	sql-diag-drop-collation
	sql-diag-drop-domain
	sql-diag-drop-index
	sql-diag-drop-schema
	sql-diag-drop-table
	sql-diag-drop-translation
	sql-diag-drop-view
	sql-diag-dynamic-delete-cursor
	sql-diag-dynamic-update-cursor
	sql-diag-grant
	sql-diag-insert
	sql-diag-revoke
	sql-diag-select-cursor
	sql-diag-unknown-statement
	sql-diag-update-where
	sql-unknown-type
	sql-char
	sql-numeric
	sql-decimal
	sql-integer
	sql-smallint
	sql-float
	sql-real
	sql-double
	sql-datetime
	sql-varchar
	sql-type-date
	sql-type-time
	sql-type-timestamp
	sql-unspecified
	sql-insensitive
	sql-sensitive
	sql-all-types
	sql-default
	sql-ard-type
	sql-code-date
	sql-code-time
	sql-code-timestamp
	sql-false
	sql-true
	sql-no-nulls
	sql-nullable
	sql-nullable-unknown
	sql-pred-none
	sql-pred-char
	sql-pred-basic
	sql-named
	sql-unnamed
	sql-desc-alloc-auto
	sql-desc-alloc-user
	sql-close
	sql-drop
	sql-unbind
	sql-reset-params
	sql-fetch-next
	sql-fetch-first
	sql-fetch-last
	sql-fetch-prior
	sql-fetch-absolute
	sql-fetch-relative
	sql-commit
	sql-rollback
	sql-null-henv
	sql-null-hdbc
	sql-null-hstmt
	sql-null-hdesc
	sql-null-handle
	sql-scope-currow
	sql-scope-transaction
	sql-scope-session
	sql-pc-unknown
	sql-pc-non-pseudo
	sql-pc-pseudo
	sql-row-identifier
	sql-index-unique
	sql-index-all
	sql-index-clustered
	sql-index-hashed
	sql-index-other
	sql-api-sqlallocconnect
	sql-api-sqlallocenv
	sql-api-sqlallochandle
	sql-api-sqlallocstmt
	sql-api-sqlbindcol
	sql-api-sqlbindparam
	sql-api-sqlcancel
	sql-api-sqlclosecursor
	sql-api-sqlcolattribute
	sql-api-sqlcolumns
	sql-api-sqlconnect
	sql-api-sqlcopydesc
	sql-api-sqldatasources
	sql-api-sqldescribecol
	sql-api-sqldisconnect
	sql-api-sqlendtran
	sql-api-sqlerror
	sql-api-sqlexecdirect
	sql-api-sqlexecute
	sql-api-sqlfetch
	sql-api-sqlfetchscroll
	sql-api-sqlfreeconnect
	sql-api-sqlfreeenv
	sql-api-sqlfreehandle
	sql-api-sqlfreestmt
	sql-api-sqlgetconnectattr
	sql-api-sqlgetcursorname
	sql-api-sqlgetdata
	sql-api-sqlgetdescfield
	sql-api-sqlgetdescrec
	sql-api-sqlgetdiagfield
	sql-api-sqlgetdiagrec
	sql-api-sqlgetenvattr
	sql-api-sqlgetfunctions
	sql-api-sqlgetinfo
	sql-api-sqlgetstmtattr
	sql-api-sqlgetstmtoption
	sql-api-sqlgettypeinfo
	sql-api-sqlnumresultcols
	sql-api-sqlparamdata
	sql-api-sqlprepare
	sql-api-sqlputdata
	sql-api-sqlrowcount
	sql-api-sqlsetconnectattr
	sql-api-sqlsetconnectoption
	sql-api-sqlsetcursorname
	sql-api-sqlsetdescfield
	sql-api-sqlsetdescrec
	sql-api-sqlsetenvattr
	sql-api-sqlsetparam
	sql-api-sqlsetstmtattr
	sql-api-sqlsetstmtoption
	sql-api-sqlspecialcolumns
	sql-api-sqlstatistics
	sql-api-sqltables
	sql-api-sqltransact
	sql-max-driver-connections
	sql-maximum-driver-connections
	sql-max-concurrent-activities
	sql-maximum-driver-connections
	sql-data-source-name
	sql-fetch-direction
	sql-server-name
	sql-search-pattern-escape
	sql-dbms-name
	sql-dbms-ver
	sql-accessible-tables
	sql-accessible-procedures
	sql-cursor-commit-behavior
	sql-data-source-read-only
	sql-default-txn-isolation
	sql-identifier-case
	sql-identifier-quote-char
	sql-max-column-name-len
	sql-maximum-column-name-length
	sql-max-cursor-name-len
	sql-maximum-cursor-name-length
	sql-max-schema-name-len
	sql-maximum-schema-name-length
	sql-max-catalog-name-len
	sql-maximum-catalog-name-length
	sql-max-table-name-len
	sql-scroll-concurrency
	sql-txn-capable
	sql-transaction-capable
	sql-user-name
	sql-txn-isolation-option
	sql-transaction-isolation-option
	sql-integrity
	sql-getdata-extensions
	sql-null-collation
	sql-alter-table
	sql-order-by-columns-in-select
	sql-special-characters
	sql-max-columns-in-group-by
	sql-maximum-columns-in-group-by
	sql-max-columns-in-index
	sql-maximum-columns-in-index
	sql-max-columns-in-order-by
	sql-maximum-columns-in-order-by
	sql-max-columns-in-select
	sql-maximum-columns-in-select
	sql-max-columns-in-table
	sql-max-index-size
	sql-maximum-index-size
	sql-max-row-size
	sql-maximum-row-size
	sql-max-statement-len
	sql-maximum-statement-length
	sql-max-tables-in-select
	sql-maximum-tables-in-select
	sql-max-user-name-len
	sql-maximum-user-name-length
	sql-oj-capabilities
	sql-outer-join-capabilities
	sql-xopen-cli-year
	sql-cursor-sensitivity
	sql-describe-parameter
	sql-catalog-name
	sql-collation-seq
	sql-max-identifier-len
	sql-maximum-identifier-length
	sql-at-add-column
	sql-at-drop-column
	sql-at-add-constraint
	sql-am-none
	sql-am-connection
	sql-am-statement
	sql-cb-delete
	sql-cb-close
	sql-cb-preserve
	sql-fd-fetch-next
	sql-fd-fetch-first
	sql-fd-fetch-last
	sql-fd-fetch-prior
	sql-fd-fetch-absolute
	sql-fd-fetch-relative
	sql-gd-any-column
	sql-gd-any-order
	sql-ic-upper
	sql-ic-lower
	sql-ic-sensitive
	sql-ic-mixed
	sql-oj-left
	sql-oj-right
	sql-oj-full
	sql-oj-nested
	sql-oj-not-ordered
	sql-oj-inner
	sql-oj-all-comparison-ops
	sql-scco-read-only
	sql-scco-lock
	sql-scco-opt-rowver
	sql-scco-opt-values
	sql-tc-none
	sql-tc-dml
	sql-tc-all
	sql-tc-ddl-commit
	sql-tc-ddl-ignore
	sql-txn-read-uncommitted
	sql-transaction-read-uncommitted
	sql-txn-read-uncommitted
	sql-transaction-read-committed
	sql-txn-repeatable-read
	sql-transaction-repeatable-read
	sql-txn-serializable
	sql-transaction-serializable
	sql-nc-high
	sql-nc-low
	sql-spec-major
	sql-spec-minor
	sql-spec-string
	sql-sqlstate-size
	sql-max-dsn-length
	sql-max-option-string-length
	sql-handle-senv
	sql-attr-odbc-version
	sql-attr-connection-pooling
	sql-attr-cp-match
	sql-cp-one-per-driver
	sql-cp-one-per-henv
	sql-cp-default
	sql-cp-strict-match
	sql-cp-relaxed-match
	sql-cp-match-default
	sql-ov-odbc2
	sql-ov-odbc3
	sql-access-mode
	sql-autocommit
	sql-login-timeout
	sql-opt-trace
	sql-opt-tracefile
	sql-translate-dll
	sql-translate-option
	sql-txn-isolation
	sql-current-qualifier
	sql-odbc-cursors
	sql-quiet-mode
	sql-packet-size
	sql-attr-access-mode
	sql-attr-autocommit
	sql-attr-connection-timeout
	sql-attr-current-catalog
	sql-attr-disconnect-behavior
	sql-attr-enlist-in-dtc
	sql-attr-enlist-in-xa
	sql-attr-login-timeout
	sql-attr-odbc-cursors
	sql-attr-packet-size
	sql-attr-quiet-mode
	sql-attr-trace
	sql-attr-tracefile
	sql-attr-translate-lib
	sql-attr-translate-option
	sql-attr-txn-isolation
	sql-attr-connection-dead
	sql-db-return-to-pool
	sql-db-disconnect
	sql-db-default
	sql-dtc-done
	sql-cd-true
	sql-cd-false
	sql-query-timeout
	sql-max-rows
	sql-noscan
	sql-max-length
	sql-async-enable
	sql-bind-type
	sql-cursor-type
	sql-concurrency
	sql-keyset-size
	sql-rowset-size
	sql-simulate-cursor
	sql-retrieve-data
	sql-use-bookmarks
	sql-get-bookmark
	sql-row-number
	sql-attr-async-enable
	sql-attr-concurrency
	sql-attr-cursor-type
	sql-attr-enable-auto-ipd
	sql-attr-fetch-bookmark-ptr
	sql-attr-keyset-size
	sql-attr-max-length
	sql-attr-max-rows
	sql-attr-noscan
	sql-attr-param-bind-offset-ptr
	sql-attr-param-bind-type
	sql-attr-param-operation-ptr
	sql-attr-param-status-ptr
	sql-attr-params-processed-ptr
	sql-attr-paramset-size
	sql-attr-query-timeout
	sql-attr-retrieve-data
	sql-attr-row-bind-offset-ptr
	sql-attr-row-bind-type
	sql-attr-row-number
	sql-attr-row-operation-ptr
	sql-attr-row-status-ptr
	sql-attr-rows-fetched-ptr
	sql-attr-row-array-size
	sql-attr-simulate-cursor
	sql-attr-use-bookmarks
	sql-col-pred-char
	sql-col-pred-basic
	sql-is-pointer
	sql-is-uinteger
	sql-is-integer
	sql-is-usmallint
	sql-is-smallint
	sql-param-bind-by-column
	sql-param-bind-type-default
	sql-query-timeout-default
	sql-max-rows-default
	sql-noscan-off
	sql-noscan-on
	sql-noscan-default
	sql-max-length-default
	sql-async-enable-off
	sql-async-enable-on
	sql-async-enable-default
	sql-bind-by-column
	sql-bind-type-default
	sql-concur-read-only
	sql-concur-lock
	sql-concur-rowver
	sql-concur-values
	sql-concur-default
	sql-cursor-forward-only
	sql-cursor-keyset-driven
	sql-cursor-dynamic
	sql-cursor-static
	sql-cursor-type-default
	sql-rowset-size-default
	sql-keyset-size-default
	sql-sc-non-unique
	sql-sc-try-unique
	sql-sc-unique
	sql-rd-off
	sql-rd-on
	sql-rd-default
	sql-ub-off
	sql-ub-on
	sql-ub-default
	sql-ub-fixed
	sql-ub-variable
	sql-desc-array-size
	sql-desc-array-status-ptr
	sql-desc-auto-unique-value
	sql-desc-base-column-name
	sql-desc-base-table-name
	sql-desc-bind-offset-ptr
	sql-desc-bind-type
	sql-desc-case-sensitive
	sql-desc-catalog-name
	sql-desc-concise-type
	sql-desc-datetime-interval-precision
	sql-desc-display-size
	sql-desc-fixed-prec-scale
	sql-desc-label
	sql-desc-literal-prefix
	sql-desc-literal-suffix
	sql-desc-local-type-name
	sql-desc-maximum-scale
	sql-desc-minimum-scale
	sql-desc-num-prec-radix
	sql-desc-parameter-type
	sql-desc-rows-processed-ptr
	sql-desc-schema-name
	sql-desc-searchable
	sql-desc-type-name
	sql-desc-table-name
	sql-desc-unsigned
	sql-desc-updatable
	sql-diag-cursor-row-count
	sql-diag-row-number
	sql-diag-column-number
	sql-date
	sql-interval
	sql-time
	sql-timestamp
	sql-longvarchar
	sql-binary
	sql-varbinary
	sql-longvarbinary
	sql-bigint
	sql-tinyint
	sql-bit
	sql-code-year
	sql-code-month
	sql-code-day
	sql-code-hour
	sql-code-minute
	sql-code-second
	sql-code-year-to-month
	sql-code-day-to-hour
	sql-code-day-to-minute
	sql-code-day-to-second
	sql-code-hour-to-minute
	sql-code-hour-to-second
	sql-code-minute-to-second
	sql-interval-year
	sql-interval-month
	sql-interval-day
	sql-interval-hour
	sql-interval-minute
	sql-interval-second
	sql-interval-year-to-month
	sql-interval-day-to-hour
	sql-interval-day-to-minute
	sql-interval-day-to-second
	sql-interval-hour-to-minute
	sql-interval-hour-to-second
	sql-interval-minute-to-second
	sql-c-char
	sql-c-long
	sql-c-short
	sql-c-float
	sql-c-double
	sql-c-numeric
	sql-signed-offset
	sql-unsigned-offset
	sql-c-date
	sql-c-time
	sql-c-timestamp
	sql-c-type-date
	sql-c-type-time
	sql-c-type-timestamp
	sql-c-interval-year
	sql-c-interval-month
	sql-c-interval-day
	sql-c-interval-hour
	sql-c-interval-minute
	sql-c-interval-second
	sql-c-interval-year-to-month
	sql-c-interval-day-to-hour
	sql-c-interval-day-to-minute
	sql-c-interval-day-to-second
	sql-c-interval-hour-to-minute
	sql-c-interval-hour-to-second
	sql-c-interval-minute-to-second
	sql-c-binary
	sql-c-bit
	sql-c-sbigint
	sql-c-ubigint
	sql-c-tinyint
	sql-c-slong
	sql-c-sshort
	sql-c-stinyint
	sql-c-ulong
	sql-c-ushort
	sql-c-utinyint
	sql-c-bookmark
	sql-c-varbookmark
	sql-no-row-number
	sql-no-column-number
	sql-row-number-unknown
	sql-column-number-unknown
	sql-default-param
	sql-ignore
	sql-column-ignore
	sql-len-data-at-exec-offset
	sql-param-type-default
	sql-setparam-value-max
	sql-column-count
	sql-column-name
	sql-column-type
	sql-column-length
	sql-column-precision
	sql-column-scale
	sql-column-display-size
	sql-column-nullable
	sql-column-unsigned
	sql-column-money
	sql-column-updatable
	sql-column-auto-increment
	sql-column-case-sensitive
	sql-column-searchable
	sql-column-type-name
	sql-column-table-name
	sql-column-owner-name
	sql-column-qualifier-name
	sql-column-label
	sql-colatt-opt-max
	sql-colatt-opt-min
	sql-attr-readonly
	sql-attr-write
	sql-attr-readwrite-unknown
	sql-unsearchable
	sql-like-only
	sql-all-except-like
	sql-searchable
	sql-pred-searchable
	sql-no-total
	sql-api-sqlallochandlestd
	sql-api-sqlbulkoperations
	sql-api-sqlbindparameter
	sql-api-sqlbrowseconnect
	sql-api-sqlcolattributes
	sql-api-sqlcolumnprivileges
	sql-api-sqldescribeparam
	sql-api-sqldriverconnect
	sql-api-sqldrivers
	sql-api-sqlextendedfetch
	sql-api-sqlforeignkeys
	sql-api-sqlmoreresults
	sql-api-sqlnativesql
	sql-api-sqlnumparams
	sql-api-sqlparamoptions
	sql-api-sqlprimarykeys
	sql-api-sqlprocedurecolumns
	sql-api-sqlprocedures
	sql-api-sqlsetpos
	sql-api-sqlsetscrolloptions
	sql-api-sqltableprivileges
	sql-api-all-functions
	sql-api-loadbyordinal
	sql-api-odbc3-all-functions
	sql-api-odbc3-all-functions-size
	sql-info-first
	sql-active-connections
	sql-active-statements
	sql-driver-hdbc
	sql-driver-henv
	sql-driver-hstmt
	sql-driver-name
	sql-driver-ver
	sql-odbc-api-conformance
	sql-odbc-ver
	sql-row-updates
	sql-odbc-sag-cli-conformance
	sql-odbc-sql-conformance
	sql-procedures
	sql-concat-null-behavior
	sql-cursor-rollback-behavior
	sql-expressions-in-orderby
	sql-max-owner-name-len
	sql-max-procedure-name-len
	sql-max-qualifier-name-len
	sql-mult-result-sets
	sql-multiple-active-txn
	sql-outer-joins
	sql-owner-term
	sql-procedure-term
	sql-qualifier-name-separator
	sql-qualifier-term
	sql-scroll-options
	sql-table-term
	sql-convert-functions
	sql-numeric-functions
	sql-string-functions
	sql-system-functions
	sql-timedate-functions
	sql-convert-bigint
	sql-convert-binary
	sql-convert-bit
	sql-convert-char
	sql-convert-date
	sql-convert-decimal
	sql-convert-double
	sql-convert-float
	sql-convert-integer
	sql-convert-longvarchar
	sql-convert-numeric
	sql-convert-real
	sql-convert-smallint
	sql-convert-time
	sql-convert-timestamp
	sql-convert-tinyint
	sql-convert-varbinary
	sql-convert-varchar
	sql-convert-longvarbinary
	sql-odbc-sql-opt-ief
	sql-correlation-name
	sql-non-nullable-columns
	sql-driver-hlib
	sql-driver-odbc-ver
	sql-lock-types
	sql-pos-operations
	sql-positioned-statements
	sql-bookmark-persistence
	sql-static-sensitivity
	sql-file-usage
	sql-column-alias
	sql-group-by
	sql-keywords
	sql-owner-usage
	sql-qualifier-usage
	sql-quoted-identifier-case
	sql-subqueries
	sql-union
	sql-max-row-size-includes-long
	sql-max-char-literal-len
	sql-timedate-add-intervals
	sql-timedate-diff-intervals
	sql-need-long-data-len
	sql-max-binary-literal-len
	sql-like-escape-clause
	sql-qualifier-location
	sql-active-environments
	sql-alter-domain
	sql-sql-conformance
	sql-datetime-literals
	sql-async-mode
	sql-batch-row-count
	sql-batch-support
	sql-catalog-location
	sql-catalog-name-separator
	sql-catalog-term
	sql-catalog-usage
	sql-convert-wchar
	sql-convert-interval-day-time
	sql-convert-interval-year-month
	sql-convert-wlongvarchar
	sql-convert-wvarchar
	sql-create-assertion
	sql-create-character-set
	sql-create-collation
	sql-create-domain
	sql-create-schema
	sql-create-table
	sql-create-translation
	sql-create-view
	sql-driver-hdesc
	sql-drop-assertion
	sql-drop-character-set
	sql-drop-collation
	sql-drop-domain
	sql-drop-schema
	sql-drop-table
	sql-drop-translation
	sql-drop-view
	sql-dynamic-cursor-attributes1
	sql-dynamic-cursor-attributes2
	sql-forward-only-cursor-attributes1
	sql-forward-only-cursor-attributes2
	sql-index-keywords
	sql-info-schema-views
	sql-keyset-cursor-attributes1
	sql-keyset-cursor-attributes2
	sql-max-async-concurrent-statements
	sql-odbc-interface-conformance
	sql-param-array-row-counts
	sql-param-array-selects
	sql-schema-term
	sql-schema-usage
	sql-sql92-datetime-functions
	sql-sql92-foreign-key-delete-rule
	sql-sql92-foreign-key-update-rule
	sql-sql92-grant
	sql-sql92-numeric-value-functions
	sql-sql92-predicates
	sql-sql92-relational-join-operators
	sql-sql92-revoke
	sql-sql92-row-value-constructor
	sql-sql92-string-functions
	sql-sql92-value-expressions
	sql-standard-cli-conformance
	sql-static-cursor-attributes1
	sql-static-cursor-attributes2
	sql-aggregate-functions
	sql-ddl-index
	sql-dm-ver
	sql-insert-statement
	sql-union-statement
	sql-at-add-column-single
	sql-at-add-column-default
	sql-at-add-column-collation
	sql-at-set-column-default
	sql-at-drop-column-default
	sql-at-drop-column-cascade
	sql-at-drop-column-restrict
	sql-at-add-table-constraint
	sql-at-drop-table-constraint-cascade
	sql-at-drop-table-constraint-restrict
	sql-at-constraint-name-definition
	sql-at-constraint-initially-deferred
	sql-at-constraint-initially-immediate
	sql-at-constraint-deferrable
	sql-at-constraint-non-deferrable
	sql-cvt-char
	sql-cvt-numeric
	sql-cvt-decimal
	sql-cvt-integer
	sql-cvt-smallint
	sql-cvt-float
	sql-cvt-real
	sql-cvt-double
	sql-cvt-varchar
	sql-cvt-longvarchar
	sql-cvt-binary
	sql-cvt-varbinary
	sql-cvt-bit
	sql-cvt-tinyint
	sql-cvt-bigint
	sql-cvt-date
	sql-cvt-time
	sql-cvt-timestamp
	sql-cvt-longvarbinary
	sql-cvt-interval-year-month
	sql-cvt-interval-day-time
	sql-cvt-wchar
	sql-cvt-wlongvarchar
	sql-cvt-wvarchar
	sql-fn-str-concat
	sql-fn-str-insert
	sql-fn-str-left
	sql-fn-str-ltrim
	sql-fn-str-length
	sql-fn-str-locate
	sql-fn-str-lcase
	sql-fn-str-repeat
	sql-fn-str-replace
	sql-fn-str-right
	sql-fn-str-rtrim
	sql-fn-str-substring
	sql-fn-str-ucase
	sql-fn-str-ascii
	sql-fn-str-char
	sql-fn-str-difference
	sql-fn-str-locate-2
	sql-fn-str-soundex
	sql-fn-str-space
	sql-fn-str-bit-length
	sql-fn-str-char-length
	sql-fn-str-character-length
	sql-fn-str-octet-length
	sql-fn-str-position
	sql-ssf-convert
	sql-ssf-lower
	sql-ssf-upper
	sql-ssf-substring
	sql-ssf-translate
	sql-ssf-trim-both
	sql-ssf-trim-leading
	sql-ssf-trim-trailing
	sql-fn-num-abs
	sql-fn-num-acos
	sql-fn-num-asin
	sql-fn-num-atan
	sql-fn-num-atan2
	sql-fn-num-ceiling
	sql-fn-num-cos
	sql-fn-num-cot
	sql-fn-num-exp
	sql-fn-num-floor
	sql-fn-num-log
	sql-fn-num-mod
	sql-fn-num-sign
	sql-fn-num-sin
	sql-fn-num-sqrt
	sql-fn-num-tan
	sql-fn-num-pi
	sql-fn-num-rand
	sql-fn-num-degrees
	sql-fn-num-log10
	sql-fn-num-power
	sql-fn-num-radians
	sql-fn-num-round
	sql-fn-num-truncate
	sql-snvf-bit-length
	sql-snvf-char-length
	sql-snvf-character-length
	sql-snvf-extract
	sql-snvf-octet-length
	sql-snvf-position
	sql-fn-td-now
	sql-fn-td-curdate
	sql-fn-td-dayofmonth
	sql-fn-td-dayofweek
	sql-fn-td-dayofyear
	sql-fn-td-month
	sql-fn-td-quarter
	sql-fn-td-week
	sql-fn-td-year
	sql-fn-td-curtime
	sql-fn-td-hour
	sql-fn-td-minute
	sql-fn-td-second
	sql-fn-td-timestampadd
	sql-fn-td-timestampdiff
	sql-fn-td-dayname
	sql-fn-td-monthname
	sql-fn-td-current-date
	sql-fn-td-current-time
	sql-fn-td-current-timestamp
	sql-fn-td-extract
	sql-sdf-current-date
	sql-sdf-current-time
	sql-sdf-current-timestamp
	sql-fn-sys-username
	sql-fn-sys-dbname
	sql-fn-sys-ifnull
	sql-fn-tsi-frac-second
	sql-fn-tsi-second
	sql-fn-tsi-minute
	sql-fn-tsi-hour
	sql-fn-tsi-day
	sql-fn-tsi-week
	sql-fn-tsi-month
	sql-fn-tsi-quarter
	sql-fn-tsi-year
	sql-ca1-next
	sql-ca1-absolute
	sql-ca1-relative
	sql-ca1-bookmark
	sql-ca1-lock-no-change
	sql-ca1-lock-exclusive
	sql-ca1-lock-unlock
	sql-ca1-pos-position
	sql-ca1-pos-update
	sql-ca1-pos-delete
	sql-ca1-pos-refresh
	sql-ca1-positioned-update
	sql-ca1-positioned-delete
	sql-ca1-select-for-update
	sql-ca1-bulk-add
	sql-ca1-bulk-update-by-bookmark
	sql-ca1-bulk-delete-by-bookmark
	sql-ca1-bulk-fetch-by-bookmark
	sql-ca2-read-only-concurrency
	sql-ca2-lock-concurrency
	sql-ca2-opt-rowver-concurrency
	sql-ca2-opt-values-concurrency
	sql-ca2-sensitivity-additions
	sql-ca2-sensitivity-deletions
	sql-ca2-sensitivity-updates
	sql-ca2-max-rows-select
	sql-ca2-max-rows-insert
	sql-ca2-max-rows-delete
	sql-ca2-max-rows-update
	sql-ca2-max-rows-catalog
	sql-ca2-max-rows-affects-all
	sql-ca2-crc-exact
	sql-ca2-crc-approximate
	sql-ca2-simulate-non-unique
	sql-ca2-simulate-try-unique
	sql-ca2-simulate-unique
	sql-oac-none
	sql-oac-level1
	sql-oac-level2
	sql-oscc-not-compliant
	sql-oscc-compliant
	sql-osc-minimum
	sql-osc-core
	sql-osc-extended
	sql-cb-null
	sql-cb-non-null
	sql-so-forward-only
	sql-so-keyset-driven
	sql-so-dynamic
	sql-so-mixed
	sql-so-static
	sql-fd-fetch-bookmark
	sql-cn-none
	sql-cn-different
	sql-cn-any
	sql-nnc-null
	sql-nnc-non-null
	sql-nc-start
	sql-nc-end
	sql-file-not-supported
	sql-file-table
	sql-file-qualifier
	sql-file-catalog
	sql-gd-block
	sql-gd-bound
	sql-ps-positioned-delete
	sql-ps-positioned-update
	sql-ps-select-for-update
	sql-gb-not-supported
	sql-gb-group-by-equals-select
	sql-gb-group-by-contains-select
	sql-gb-no-relation
	sql-gb-collate
	sql-ou-dml-statements
	sql-ou-procedure-invocation
	sql-ou-table-definition
	sql-ou-index-definition
	sql-ou-privilege-definition
	sql-su-dml-statements
	sql-su-procedure-invocation
	sql-su-table-definition
	sql-su-index-definition
	sql-su-privilege-definition
	sql-qu-dml-statements
	sql-qu-procedure-invocation
	sql-qu-table-definition
	sql-qu-index-definition
	sql-qu-privilege-definition
	sql-cu-dml-statements
	sql-cu-procedure-invocation
	sql-cu-table-definition
	sql-cu-index-definition
	sql-cu-privilege-definition
	sql-sq-comparison
	sql-sq-exists
	sql-sq-in
	sql-sq-quantified
	sql-sq-correlated-subqueries
	sql-u-union
	sql-u-union-all
	sql-bp-close
	sql-bp-delete
	sql-bp-drop
	sql-bp-transaction
	sql-bp-update
	sql-bp-other-hstmt
	sql-bp-scroll
	sql-ss-additions
	sql-ss-deletions
	sql-ss-updates
	sql-cv-create-view
	sql-cv-check-option
	sql-cv-cascaded
	sql-cv-local
	sql-lck-no-change
	sql-lck-exclusive
	sql-lck-unlock
	sql-pos-position
	sql-pos-refresh
	sql-pos-update
	sql-pos-delete
	sql-pos-add
	sql-ql-start
	sql-ql-end
	sql-af-avg
	sql-af-count
	sql-af-max
	sql-af-min
	sql-af-sum
	sql-af-distinct
	sql-af-all
	sql-sc-fips127-2-transitional
	sql-sc-sql92-intermediate
	sql-sc-sql92-full
	sql-dl-sql92-date
	sql-dl-sql92-time
	sql-dl-sql92-timestamp
	sql-dl-sql92-interval-year
	sql-dl-sql92-interval-month
	sql-dl-sql92-interval-day
	sql-dl-sql92-interval-hour
	sql-dl-sql92-interval-minute
	sql-dl-sql92-interval-second
	sql-dl-sql92-interval-year-to-month
	sql-dl-sql92-interval-day-to-hour
	sql-dl-sql92-interval-day-to-minute
	sql-dl-sql92-interval-day-to-second
	sql-dl-sql92-interval-hour-to-minute
	sql-dl-sql92-interval-hour-to-second
	sql-dl-sql92-interval-minute-to-second
	sql-cl-start
	sql-cl-end
	sql-brc-procedures
	sql-brc-explicit
	sql-brc-rolled-up
	sql-bs-select-explicit
	sql-bs-row-count-explicit
	sql-bs-select-proc
	sql-bs-row-count-proc
	sql-parc-batch
	sql-parc-no-batch
	sql-pas-batch
	sql-pas-no-batch
	sql-pas-no-select
	sql-ik-none
	sql-ik-asc
	sql-ik-desc
	sql-ik-all
	sql-isv-assertions
	sql-isv-character-sets
	sql-isv-check-constraints
	sql-isv-collations
	sql-isv-column-domain-usage
	sql-isv-column-privileges
	sql-isv-columns
	sql-isv-constraint-column-usage
	sql-isv-constraint-table-usage
	sql-isv-domain-constraints
	sql-isv-domains
	sql-isv-key-column-usage
	sql-isv-referential-constraints
	sql-isv-schemata
	sql-isv-sql-languages
	sql-isv-table-constraints
	sql-isv-table-privileges
	sql-isv-tables
	sql-isv-translations
	sql-isv-usage-privileges
	sql-isv-view-column-usage
	sql-isv-view-table-usage
	sql-isv-views
	sql-am-none
	sql-am-connection
	sql-am-statement
	sql-ad-constraint-name-definition
	sql-ad-add-domain-constraint
	sql-ad-drop-domain-constraint
	sql-ad-add-domain-default
	sql-ad-drop-domain-default
	sql-ad-add-constraint-initially-deferred
	sql-ad-add-constraint-initially-immediate
	sql-ad-add-constraint-deferrable
	sql-ad-add-constraint-non-deferrable
	sql-cs-create-schema
	sql-cs-authorization
	sql-cs-default-character-set
	sql-ctr-create-translation
	sql-ca-create-assertion
	sql-ca-constraint-initially-deferred
	sql-ca-constraint-initially-immediate
	sql-ca-constraint-deferrable
	sql-ca-constraint-non-deferrable
	sql-ccs-create-character-set
	sql-ccs-collate-clause
	sql-ccs-limited-collation
	sql-ccol-create-collation
	sql-cdo-create-domain
	sql-cdo-default
	sql-cdo-constraint
	sql-cdo-collation
	sql-cdo-constraint-name-definition
	sql-cdo-constraint-initially-deferred
	sql-cdo-constraint-initially-immediate
	sql-cdo-constraint-deferrable
	sql-cdo-constraint-non-deferrable
	sql-ct-create-table
	sql-ct-commit-preserve
	sql-ct-commit-delete
	sql-ct-global-temporary
	sql-ct-local-temporary
	sql-ct-constraint-initially-deferred
	sql-ct-constraint-initially-immediate
	sql-ct-constraint-deferrable
	sql-ct-constraint-non-deferrable
	sql-ct-column-constraint
	sql-ct-column-default
	sql-ct-column-collation
	sql-ct-table-constraint
	sql-ct-constraint-name-definition
	sql-di-create-index
	sql-di-drop-index
	sql-dc-drop-collation
	sql-dd-drop-domain
	sql-dd-restrict
	sql-dd-cascade
	sql-ds-drop-schema
	sql-ds-restrict
	sql-ds-cascade
	sql-dcs-drop-character-set
	sql-da-drop-assertion
	sql-dt-drop-table
	sql-dt-restrict
	sql-dt-cascade
	sql-dtr-drop-translation
	sql-dv-drop-view
	sql-dv-restrict
	sql-dv-cascade
	sql-is-insert-literals
	sql-is-insert-searched
	sql-is-select-into
	sql-oic-core
	sql-oic-level1
	sql-oic-level2
	sql-sfkd-cascade
	sql-sfkd-no-action
	sql-sfkd-set-default
	sql-sfkd-set-null
	sql-sfku-cascade
	sql-sfku-no-action
	sql-sfku-set-default
	sql-sfku-set-null
	sql-sg-usage-on-domain
	sql-sg-usage-on-character-set
	sql-sg-usage-on-collation
	sql-sg-usage-on-translation
	sql-sg-with-grant-option
	sql-sg-delete-table
	sql-sg-insert-table
	sql-sg-insert-column
	sql-sg-references-table
	sql-sg-references-column
	sql-sg-select-table
	sql-sg-update-table
	sql-sg-update-column
	sql-sp-exists
	sql-sp-isnotnull
	sql-sp-isnull
	sql-sp-match-full
	sql-sp-match-partial
	sql-sp-match-unique-full
	sql-sp-match-unique-partial
	sql-sp-overlaps
	sql-sp-unique
	sql-sp-like
	sql-sp-in
	sql-sp-between
	sql-sp-comparison
	sql-sp-quantified-comparison
	sql-srjo-corresponding-clause
	sql-srjo-cross-join
	sql-srjo-except-join
	sql-srjo-full-outer-join
	sql-srjo-inner-join
	sql-srjo-intersect-join
	sql-srjo-left-outer-join
	sql-srjo-natural-join
	sql-srjo-right-outer-join
	sql-srjo-union-join
	sql-sr-usage-on-domain
	sql-sr-usage-on-character-set
	sql-sr-usage-on-collation
	sql-sr-usage-on-translation
	sql-sr-grant-option-for
	sql-sr-cascade
	sql-sr-restrict
	sql-sr-delete-table
	sql-sr-insert-table
	sql-sr-insert-column
	sql-sr-references-table
	sql-sr-references-column
	sql-sr-select-table
	sql-sr-update-table
	sql-sr-update-column
	sql-srvc-value-expression
	sql-srvc-null
	sql-srvc-default
	sql-srvc-row-subquery
	sql-sve-case
	sql-sve-cast
	sql-sve-coalesce
	sql-sve-nullif
	sql-scc-xopen-cli-version1
	sql-scc-iso92-cli
	sql-us-union
	sql-us-union-all
	sql-dtc-enlist-expensive
	sql-dtc-unenlist-expensive
	sql-fetch-first-user
	sql-fetch-first-system
	sql-entire-rowset
	sql-position
	sql-refresh
	sql-update
	sql-delete
	sql-add
	sql-setpos-max-option-value
	sql-update-by-bookmark
	sql-delete-by-bookmark
	sql-fetch-by-bookmark
	sql-lock-no-change
	sql-lock-exclusive
	sql-lock-unlock
	sql-setpos-max-lock-value
	sql-best-rowid
	sql-rowver
	sql-pc-not-pseudo
	sql-quick
	sql-ensure
	sql-table-stat
	sql-driver-noprompt
	sql-driver-complete
	sql-driver-prompt
	sql-driver-complete-required
	sql-fetch-bookmark
	sql-row-success
	sql-row-deleted
	sql-row-updated
	sql-row-norow
	sql-row-added
	sql-row-error
	sql-row-success-with-info
	sql-row-proceed
	sql-row-ignore
	sql-param-success
	sql-param-success-with-info
	sql-param-error
	sql-param-unused
	sql-param-diag-unavailable
	sql-param-proceed
	sql-param-ignore
	sql-cascade
	sql-restrict
	sql-set-null
	sql-no-action
	sql-set-default
	sql-initially-deferred
	sql-initially-immediate
	sql-not-deferrable
	sql-param-type-unknown
	sql-param-input
	sql-param-input-output
	sql-result-col
	sql-param-output
	sql-return-value
	sql-pt-unknown
	sql-pt-procedure
	sql-pt-function))
