#include <stdio.h>
#include <stdlib.h>

#define DOC_ONLY
#include "../../../../../src/plugins/sim/sim.c"

void csch_sheet_bbox_update(csch_sheet_t *sheet) {}

static const char *logname(int l)
{
	switch(l) {
		case -1: return "none (no plot)";
		case 0: return "linear";
		case 8: return "logarithmic (octal)";
		case 10: return "logarithmic (decade)";
	}
}
static const char *yesno(int b)
{
	switch(b) {
		case 1: return "yes";
		case 0: return "no";
		default: return "N/A";
	}
}

int main()
{
	int n;

	printf("<html>\n");
	printf("\n\n\n\n<!-- ******** DO NOT EDIT ********: generated by src/gen.c -->\n\n\n\n");
	printf("<body>\n");
	printf("<H2 autotoc=\"yes\"> Simulation setup details </H2>\n");


	printf("<H3 autotoc=\"yes\"> Analyses </H3>\n");
	printf("<p>Below is a table of all analysis types supported. The first column goes in analysis/type.\n");

	printf(" <p><table border=1 cellspacing=0>\n");
	printf("  <tr><th> analysis name <th> description <th> x axis\n");

	for(n = 0; sch_siman_names[n] != NULL; n++) {
		printf("  <tr><td> %s\n", sch_siman_names[n]);
		printf("      <td> %s\n", sch_siman_description[n]);
		if (sch_siman_x_axis_log[n] == -1)
			printf("      <td> N/A\n");
		else
			printf("      <td> %s, %s\n", logname(sch_siman_x_axis_log[n]), sch_siman_x_axis_name[n]);
	}
	printf(" </table>\n");

	printf("<H3 autotoc=\"yes\"> Presentations </H3>\n");
	printf("<p>The following presentation types are available (these go in presentation/type):\n");
	printf(" <ul>\n");
	for(n = 0; sch_simpres_names[n] != NULL; n++)
		printf("  <li> %s\n", sch_simpres_names[n]);
	printf(" </ul>\n");

	printf("<H3 autotoc=\"yes\"> Modifications </H3>\n");
	printf("<p>Below is a table of all modification types supported. The first column is the node name used for hash nodes in the mods subtree.\n");

	printf(" <p><table border=1 cellspacing=0>\n");
	printf("  <tr><th> modification name\n");

	for(n = 0; sch_simmod_type_names[n] != NULL; n++) {
		printf("  <tr><td> %s\n", sch_simmod_type_names[n]);
	}
	printf(" </table>\n");

	printf("<H3 autotoc=\"yes\"> 'Add' modification fields </H3>\n");
	printf("<p>Below is a table of all device types supported when adding a component from mods. The first column goes in the add mod's device node.\n");

	printf(" <p><table border=1 cellspacing=0>\n");
	printf("  <tr><th> modification name <th> can have AC <th> can have tdf (time-dependent func)\n");

	for(n = 0; sch_simmod_dev_names[n] != NULL; n++) {
		printf("  <tr><td> %s\n", sch_simmod_dev_names[n]);
		printf("      <td> %s\n", yesno(sch_sim_device_has_ac[n]));
		printf("      <td> %s\n", yesno(sch_sim_device_has_tdf[n]));

	}
	printf(" </table>\n");

	printf("<H3 autotoc=\"yes\"> 'Add' modification tdf subtree </H3>\n");
	printf("<p>Below is a table of all tdf types supported when adding a component that has tdf capability. First column goes in add/tdf, parameters go in add/tdf_params/\n");

	printf(" <p><table border=1 cellspacing=0>\n");
	printf("  <tr><th> tdf name <th> params \n");

	for(n = 0; sch_simmod_tdf_names[n] != NULL; n++) {
		const sch_sim_mod_tdf_param_t *p = sch_sim_mod_tdf_params[n];

		printf("  <tr><td> %s\n", sch_simmod_tdf_names[n]);
		printf("  <td>");
		if (p != NULL) {
			printf("\n    <ul>\n");
			for(; p->name != NULL; p++) {
				printf("    <li> %s (%s)", p->name, p->desc);
				if (p->optional)
					printf(" <i>optional</i>");
				printf("\n");
			}
			printf("    </ul>\n");
		}
		else
			printf("(no parametres)");
		printf("\n");
	}
	printf(" </table>\n");


}
