/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.views;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChartCoordinateView
extends JPanel {
    protected Chart2D m_chart2D;
    protected JTextField m_xView;
    protected JTextField m_yView;
    private final transient MouseMotionListener m_mouseListener;

    public ChartCoordinateView(Chart2D chart) {
        this.m_chart2D = chart;
        this.m_xView = new JTextField(10);
        this.m_xView.setEditable(false);
        this.m_yView = new JTextField(10);
        this.m_yView.setEditable(false);
        this.m_mouseListener = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent me) {
                ITracePoint2D value = ChartCoordinateView.this.m_chart2D.translateMousePosition(me);
                if (value != null) {
                    ChartCoordinateView.this.m_xView.setText(ChartCoordinateView.this.m_chart2D.getAxisX().getFormatter().format(value.getX()));
                    ChartCoordinateView.this.m_yView.setText(ChartCoordinateView.this.m_chart2D.getAxisY().getFormatter().format(value.getY()));
                }
            }
        };
        this.m_chart2D.addMouseMotionListener(this.m_mouseListener);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        gbc.insets.top = 4;
        gbc.insets.bottom = 4;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        this.add((Component)new JLabel("X value:"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.2;
        this.add(Box.createHorizontalStrut(4));
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)this.m_xView, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)new JLabel("Y value:"), gbc);
        gbc.weightx = 0.2;
        gbc.gridx = 1;
        this.add(Box.createHorizontalStrut(4));
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)this.m_yView, gbc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartCoordinateView other = (ChartCoordinateView)obj;
        if (this.m_chart2D == null ? other.m_chart2D != null : !this.m_chart2D.equals(other.m_chart2D)) {
            return false;
        }
        if (this.m_xView == null ? other.m_xView != null : !this.m_xView.equals(other.m_xView)) {
            return false;
        }
        return !(this.m_yView == null ? other.m_yView != null : !this.m_yView.equals(other.m_yView));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_chart2D.removeMouseMotionListener(this.m_mouseListener);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_chart2D == null ? 0 : this.m_chart2D.hashCode());
        result = 31 * result + (this.m_xView == null ? 0 : this.m_xView.hashCode());
        result = 31 * result + (this.m_yView == null ? 0 : this.m_yView.hashCode());
        return result;
    }
}

