/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sablecc.sablecc.BooleanCast;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.AHelperDef;
import org.sablecc.sablecc.node.AIdBasic;
import org.sablecc.sablecc.node.AIgnTokens;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.AStateList;
import org.sablecc.sablecc.node.AStateListTail;
import org.sablecc.sablecc.node.AStates;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.ATransition;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.TId;
import org.sablecc.sablecc.node.TPkgId;
import org.sablecc.sablecc.node.TSlash;
import org.sablecc.sablecc.node.Token;

public class ResolveIds
extends DepthFirstAdapter {
    public final Map helpers = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map states = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map tokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ignTokens = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map prods = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map alts = new TypedHashMap(StringCast.instance, NodeCast.instance);
    public final Map elems = new TypedHashMap(StringCast.instance, NodeCast.instance);
    public final Map names = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map errorNames = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map elemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map altsElemNameTypes = new TypedHashMap(StringCast.instance, StringCast.instance);
    public final Map altsElemTypes = new TypedHashMap(StringCast.instance, StringCast.instance);
    public final Map fixedTokens = new TypedHashMap(NodeCast.instance, BooleanCast.instance);
    public final List tokenList = new TypedLinkedList(StringCast.instance);
    public final LinkedList stateList = new TypedLinkedList(StringCast.instance);
    public File pkgDir;
    public String pkgName = "";
    private boolean processingStates;
    private boolean processingIgnTokens;
    String currentProd;
    String currentAlt;
    private int lastLine;
    private int lastPos;
    private Map stateMap;

    public ResolveIds(File file) {
        this.pkgDir = file;
    }

    public void inAGrammar(AGrammar aGrammar) {
        TPkgId[] tPkgIdArray = aGrammar.getPackage().toArray(new TPkgId[0]);
        if (tPkgIdArray.length > 0) {
            this.pkgName = tPkgIdArray[0].getText();
            this.pkgDir = new File(this.pkgDir, tPkgIdArray[0].getText());
            for (int i = 1; i < tPkgIdArray.length; ++i) {
                this.pkgName = this.pkgName + "." + tPkgIdArray[i].getText();
                this.pkgDir = new File(this.pkgDir, tPkgIdArray[i].getText());
            }
            if (!this.pkgDir.exists() && !this.pkgDir.mkdirs()) {
                throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
            }
        }
    }

    public void caseAProd(AProd aProd) {
        this.currentProd = ResolveIds.name(aProd.getId().getText());
        String string = "P" + this.currentProd;
        if (this.prods.put(string, aProd) != null) {
            ResolveIds.error(aProd.getId(), string);
        }
        this.names.put(aProd, string);
        Object[] objectArray = aProd.getAlts().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((PAlt)objectArray[i]).apply(this);
        }
    }

    public void caseAIdBasic(AIdBasic aIdBasic) {
        String string = aIdBasic.getId().getText();
        if (this.helpers.get(string) == null) {
            ResolveIds.error2(aIdBasic.getId(), string);
        }
    }

    public void outAHelperDef(AHelperDef aHelperDef) {
        String string = aHelperDef.getId().getText();
        if (this.helpers.put(string, aHelperDef) != null) {
            ResolveIds.error(aHelperDef.getId(), string);
        }
        this.names.put(aHelperDef, string);
    }

    public void outATokenDef(ATokenDef aTokenDef) {
        String string = "T" + ResolveIds.name(aTokenDef.getId().getText());
        String string2 = ResolveIds.errorName(aTokenDef.getId().getText());
        if (this.tokens.put(string, aTokenDef) != null) {
            ResolveIds.error(aTokenDef.getId(), string);
        }
        this.names.put(aTokenDef, string);
        this.errorNames.put(aTokenDef, string2);
        this.tokenList.add(string);
        if (aTokenDef.getLookAhead() != null) {
            TSlash tSlash = aTokenDef.getSlash();
            throw new RuntimeException("[" + tSlash.getLine() + "," + tSlash.getPos() + "] " + "Look ahead not yet supported.");
        }
    }

    public void inAStates(AStates aStates) {
        Object[] objectArray = aStates.getListId().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((TId)objectArray[i]).getText().toUpperCase();
            if (this.states.put(string, objectArray[i]) != null) {
                ResolveIds.error((TId)objectArray[i], string);
            }
            this.names.put(objectArray[i], string);
            this.stateList.add(string);
        }
    }

    public void inAIgnTokens(AIgnTokens aIgnTokens) {
        Object[] objectArray = aIgnTokens.getListId().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = "T" + ResolveIds.name(((TId)objectArray[i]).getText());
            if (this.tokens.get(string) == null) {
                ResolveIds.error2((TId)objectArray[i], string);
            }
            if (this.ignTokens.put(string, objectArray[i]) != null) {
                ResolveIds.error((TId)objectArray[i], string);
            }
            this.names.put(objectArray[i], string);
        }
    }

    public void inAStateList(AStateList aStateList) {
        this.stateMap = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
        String string = aStateList.getId().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(aStateList.getId(), string);
        }
        if (this.stateMap.put(string, aStateList) != null) {
            ResolveIds.error(aStateList.getId(), string);
        }
    }

    public void outAStateList(AStateList aStateList) {
        this.stateMap = null;
    }

    public void inAStateListTail(AStateListTail aStateListTail) {
        String string = aStateListTail.getId().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(aStateListTail.getId(), string);
        }
        if (this.stateMap.put(string, aStateListTail) != null) {
            ResolveIds.error(aStateListTail.getId(), string);
        }
    }

    public void inATransition(ATransition aTransition) {
        String string = aTransition.getId().getText().toUpperCase();
        if (this.states.get(string) == null) {
            ResolveIds.error2(aTransition.getId(), string);
        }
    }

    public void caseAAlt(AAlt aAlt) {
        if (aAlt.getAltName() != null) {
            this.currentAlt = "A" + ResolveIds.name(aAlt.getAltName().getText()) + this.currentProd;
            if (this.alts.put(this.currentAlt, aAlt) != null) {
                ResolveIds.error(aAlt.getAltName(), this.currentAlt);
            }
            this.names.put(aAlt, this.currentAlt);
        } else {
            this.currentAlt = "A" + this.currentProd;
            if (this.alts.put(this.currentAlt, aAlt) != null) {
                this.error(this.currentAlt);
            }
            this.names.put(aAlt, this.currentAlt);
        }
        AElem[] aElemArray = aAlt.getElems().toArray(new AElem[0]);
        for (int i = 0; i < aElemArray.length; ++i) {
            aElemArray[i].apply(this);
        }
    }

    public void defaultcase(Node node) {
        if (node instanceof Token) {
            Token token = (Token)node;
            this.lastLine = token.getLine();
            this.lastPos = token.getPos() + token.getText().length();
        }
    }

    public void caseAAst(AAst aAst) {
    }

    public void caseAElem(AElem aElem) {
        if (aElem.getElemName() != null) {
            String string = this.currentAlt + "." + ResolveIds.name(aElem.getElemName().getText());
            if (this.elems.put(string, aElem) != null) {
                ResolveIds.error(aElem.getElemName(), string);
            }
            if (aElem.getElemName().getText().equals("class")) {
                ResolveIds.error5(aElem.getElemName());
            }
            this.names.put(aElem, ResolveIds.name(aElem.getElemName().getText()));
        } else {
            String string = this.currentAlt + "." + ResolveIds.name(aElem.getId().getText());
            if (this.elems.put(string, aElem) != null) {
                ResolveIds.error(aElem.getId(), string);
            }
            if (aElem.getId().getText().equals("class")) {
                ResolveIds.error5(aElem.getId());
            }
            this.names.put(aElem, ResolveIds.name(aElem.getId().getText()));
        }
    }

    public void outAProductions(AProductions aProductions) {
        aProductions.apply(new DepthFirstAdapter(){

            public void caseAProd(AProd aProd) {
                ResolveIds.this.currentProd = ResolveIds.name(aProd.getId().getText());
                Object[] objectArray = aProd.getAlts().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((PAlt)objectArray[i]).apply(this);
                }
            }

            public void caseAAlt(AAlt aAlt) {
                ResolveIds.this.currentAlt = aAlt.getAltName() != null ? "A" + ResolveIds.name(aAlt.getAltName().getText()) + ResolveIds.this.currentProd : "A" + ResolveIds.this.currentProd;
                AElem[] aElemArray = aAlt.getElems().toArray(new AElem[0]);
                for (int i = 0; i < aElemArray.length; ++i) {
                    aElemArray[i].apply(this);
                }
            }

            public void caseAElem(AElem aElem) {
                String string = ResolveIds.name(aElem.getId().getText());
                String string2 = aElem.getElemName() != null ? aElem.getElemName().getText() : aElem.getId().getText();
                if (aElem.getSpecifier() != null) {
                    if (aElem.getSpecifier() instanceof ATokenSpecifier) {
                        if (ResolveIds.this.tokens.get("T" + string) == null) {
                            ResolveIds.error2(aElem.getId(), "T" + string);
                        }
                        if (ResolveIds.this.ignTokens.get("T" + string) != null) {
                            ResolveIds.error3(aElem.getId(), "T" + string);
                        }
                        ResolveIds.this.elemTypes.put(aElem, "T" + string);
                        if (aElem.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + aElem.getElemName().getText(), "T" + string);
                        }
                        String string3 = string;
                        if (aElem.getUnOp() instanceof AStarUnOp || aElem.getUnOp() instanceof AQMarkUnOp) {
                            string3 = string3 + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + string2, "T" + string3);
                    } else {
                        if (ResolveIds.this.prods.get("P" + string) == null) {
                            ResolveIds.error2(aElem.getId(), "P" + string);
                        }
                        ResolveIds.this.elemTypes.put(aElem, "P" + string);
                        if (aElem.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + aElem.getElemName().getText(), "P" + string);
                        }
                        String string4 = string;
                        if (aElem.getUnOp() instanceof AStarUnOp || aElem.getUnOp() instanceof AQMarkUnOp) {
                            string4 = string4 + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + string2, "P" + string4);
                    }
                } else {
                    Object v = ResolveIds.this.tokens.get("T" + string);
                    Object v2 = ResolveIds.this.ignTokens.get("T" + string);
                    Object v3 = ResolveIds.this.prods.get("P" + string);
                    if (v == null && v3 == null) {
                        ResolveIds.error2(aElem.getId(), "P" + string + " and T" + string);
                    }
                    if (v != null) {
                        if (v3 != null) {
                            ResolveIds.error4(aElem.getId(), "P" + string + " and T" + string);
                        }
                        if (v2 != null) {
                            ResolveIds.error3(aElem.getId(), "T" + string);
                        }
                        ResolveIds.this.elemTypes.put(aElem, "T" + string);
                        if (aElem.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + aElem.getElemName().getText(), "T" + string);
                        }
                        String string5 = string;
                        if (aElem.getUnOp() instanceof AStarUnOp || aElem.getUnOp() instanceof AQMarkUnOp) {
                            string5 = string5 + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + string2, "T" + string5);
                    } else {
                        ResolveIds.this.elemTypes.put(aElem, "P" + string);
                        if (aElem.getElemName() != null) {
                            ResolveIds.this.altsElemNameTypes.put(ResolveIds.this.currentAlt + "." + aElem.getElemName().getText(), "P" + string);
                        }
                        String string6 = string;
                        if (aElem.getUnOp() instanceof AStarUnOp || aElem.getUnOp() instanceof AQMarkUnOp) {
                            string6 = string6 + "?";
                        }
                        ResolveIds.this.altsElemTypes.put(ResolveIds.this.currentAlt + "." + string2, "P" + string6);
                    }
                }
            }
        });
    }

    public static String name(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '_': {
                    bl = true;
                    continue block4;
                }
                case '$': {
                    stringBuffer.append(c);
                    bl = true;
                    continue block4;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(Character.toUpperCase(c));
                        bl = false;
                        continue block4;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String errorName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '_': {
                    stringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void reinit() {
        this.names.clear();
        this.elemTypes.clear();
    }

    private static void error(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Redefinition of " + string + ".");
    }

    private void error(String string) {
        throw new RuntimeException("[" + this.lastLine + "," + this.lastPos + "] " + "Redefinition of " + string + ".");
    }

    private static void error2(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " undefined.");
    }

    private static void error3(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " is ignored.");
    }

    private static void error4(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "ambiguous " + string + ".");
    }

    private static void error5(Token token) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "class is an invalid element name.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Helpers:");
        stringBuffer.append(string);
        stringBuffer.append(this.helpers);
        stringBuffer.append(string);
        stringBuffer.append("States:");
        stringBuffer.append(string);
        stringBuffer.append(this.states);
        stringBuffer.append(string);
        stringBuffer.append("Tokens:");
        stringBuffer.append(string);
        stringBuffer.append(this.tokens);
        stringBuffer.append(string);
        stringBuffer.append("Ignored Tokens:");
        stringBuffer.append(string);
        stringBuffer.append(this.ignTokens);
        stringBuffer.append(string);
        stringBuffer.append("Productions:");
        stringBuffer.append(string);
        stringBuffer.append(this.prods);
        stringBuffer.append(string);
        stringBuffer.append("Alternatives:");
        stringBuffer.append(string);
        stringBuffer.append(this.alts);
        stringBuffer.append(string);
        stringBuffer.append("Elements:");
        stringBuffer.append(string);
        stringBuffer.append(this.elems);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

