# Copyright (c) 2013 Novo Nordisk Foundation Center for Biosustainability, DTU.
# See LICENSE for details.

import os

import pytest
from swiglpk import glp_create_index, glp_create_prob, glp_get_num_cols, glp_get_num_rows, glp_read_lp

from optlang.util import glpk_read_cplex, list_available_solvers, solve_with_glpsol


TESTMODELPATH = os.path.join(os.path.dirname(__file__), 'data/model.lp')


@pytest.mark.skip("deprecated functionality")
def test_solve_with_glpsol():
    problem = glp_create_prob()
    glp_read_lp(problem, None, TESTMODELPATH)
    glp_create_index(problem)
    result = solve_with_glpsol(problem)
    reference = {'M_13dpg_c': ['5', '0', '-0.0471054946649844'], 'R_ME1': ['2', '0', '-0.00509248590972805'],
                 'R_ME2': ['2', '0', '-0.00381936443229605'], 'R_EX_acald_e': ['2', '0', '-0.0343742798906643'],
                 'R_EX_pi_e': ['1', '-3.21489504768477', '0'], 'R_PTAr': ['1', '0', '0'],
                 'M_g6p_c': ['5', '0', '-0.0980303537622649'], 'R_THD2': ['2', '0', '-0.00127312147743202'],
                 'M_s7p_c': ['5', '0', '-0.113307811491449'], 'M_glu_L_c': ['5', '0', '-0.0700216812587607'],
                 'R_TKT1': ['1', '1.49698375726157', '0'], 'M_glu_L_e': ['5', '0', '-0.0687485597813287'],
                 'R_CO2t': ['1', '-22.809833310205', '0'], 'R_PFL': ['1', '5.31182206840464e-31', '0'],
                 'M_nadp_c': ['5', '0', '0.00891185034202407'], 'R_ICL': ['1', '0', '0'], 'M_h2o_c': ['5', '0', '-0'],
                 'M_amp_c': ['5', '0', '0.0101849718194561'], 'M_f6p_c': ['5', '0', '-0.0980303537622649'],
                 'M_h2o_e': ['5', '0', '-0'], 'M_ac_c': ['5', '0', '-0.0241893080712082'],
                 'M_ac_e': ['5', '0', '-0.0229161865937762'], 'R_NH4t': ['1', '4.76531919319746', '0'],
                 'M_adp_c': ['5', '0', '0.00509248590972805'], 'M_nh4_e': ['5', '0', '-0'],
                 'M_gln_L_c': ['5', '0', '-0.0751141671684887'], 'M_gln_L_e': ['5', '0', '-0.0700216812587607'],
                 'M_succoa_c': ['5', '0', '-0.0547442235295765'], 'M_nh4_c': ['5', '0', '-0'],
                 'R_H2Ot': ['1', '-29.1758271355658', '0'], 'R_EX_glu_L_e': ['2', '0', '-0.0687485597813287'],
                 'M_icit_c': ['5', '0', '-0.0712948027361927'], 'M_q8h2_c': ['1', '-7.105427357601e-15', '0'],
                 'R_FORt2': ['2', '0', '-0.00127312147743201'], 'R_ADK1': ['1', '0', '0'],
                 'M_glx_c': ['5', '0', '-0.0203699436389122'], 'M_glc_D_e': ['5', '0', '-0.0916647463751049'],
                 'M_lac_D_c': ['5', '0', '-0.0420130087552564'], 'M_lac_D_e': ['5', '0', '-0.0407398872778244'],
                 'M_acald_e': ['5', '0', '-0.0343742798906643'], 'M_acald_c': ['5', '0', '-0.0343742798906643'],
                 'R_RPE': ['1', '2.67848185050753', '0'], 'R_EX_for_e': ['2', '0', '-0.00763872886459208'],
                 'M_dhap_c': ['5', '0', '-0.0521979805747125'], 'M_pyr_c': ['5', '0', '-0.0356474013680963'],
                 'M_pyr_e': ['5', '0', '-0.0343742798906643'], 'M_fdp_c': ['5', '0', '-0.104395961149425'],
                 'R_PGM': ['1', '-14.7161395687428', '0'], 'R_PGL': ['1', '4.95998494457466', '0'],
                 'R_PGK': ['1', '-16.0235261431676', '0'], 'M_3pg_c': ['5', '0', '-0.0420130087552564'],
                 'M_coa_c': ['1', '-1.77635683940025e-15', '0'], 'R_FRD7': ['2', '0', '0'],
                 'R_EX_gln_L_e': ['2', '0', '-0.0700216812587607'], 'R_GLCpts': ['1', '10', '0'],
                 'R_SUCCt3': ['1', '0', '0'], 'R_ATPM': ['2', '8.39', '-0.00509248590972805'],
                 'M_succ_e': ['5', '0', '-0.0521979805747125'], 'M_succ_c': ['5', '0', '-0.0509248590972805'],
                 'R_EX_lac_D_e': ['2', '0', '-0.0407398872778244'], 'R_O2t': ['1', '21.7994926559988', '0'],
                 'M_2pg_c': ['5', '0', '-0.0420130087552564'], 'R_CS': ['1', '6.00724957535033', '0'],
                 'R_PDH': ['1', '9.28253259916661', '0'], 'R_CYTBD': ['1', '43.5989853119975', '0'],
                 'R_ETOHt2r': ['1', '-0', '0'], 'R_FBP': ['2', '0', '-0.00509248590972805'], 'R_ACKr': ['1', '0', '0'],
                 'R_GLUSy': ['2', '0', '-0.00509248590972804'], 'M_fru_e': ['5', '0', '-0.0916647463751049'],
                 'R_G6PDH2r': ['1', '4.95998494457466', '0'], 'R_EX_co2_e': ['1', '22.809833310205', '0'],
                 'R_TKT2': ['1', '1.18149809324596', '0'], 'R_GLUDy': ['1', '-4.54185746386563', '0'],
                 'R_EX_fru_e': ['2', '0', '-0.0916647463751049'], 'R_NADTRHD': ['2', '0', '-0.001273121477432'],
                 'R_PYRt2r': ['1', '-0', '0'], 'R_FUMt2_2': ['1', '0', '0'], 'R_SUCDi': ['1', '5.06437566148209', '0'],
                 'R_ALCD2x': ['1', '-5.84859702315521e-30', '0'], 'R_EX_o2_e': ['1', '-21.7994926559988', '0'],
                 'M_g3p_c': ['5', '0', '-0.0521979805747125'], 'R_EX_akg_e':
                     ['2', '0', '-0.0611098309167366'], 'R_GLUt2r': ['1', '-0', '0'],
                 'M_pi_c': ['5', '0', '-0.00127312147743201'],
                 'M_pi_e': ['5', '0', '-0'], 'R_LDH_D': ['1', '0', '0'], 'M_o2_c': ['5', '0', '-0'],
                 'M_atp_c': ['1', '0', '0'], 'M_o2_e': ['5', '0', '-0'], 'R_MALt2_2': ['1', '0', '0'],
                 'R_FBA': ['1', '7.47738196216028', '0'], 'M_for_c': ['5', '0', '-0.00763872886459208'],
                 'R_EX_pyr_e': ['2', '0', '-0.0343742798906643'], 'R_EX_h_e': ['1', '17.5308654297867', '0'],
                 'R_MALS': ['2', '0', '-0.001273121477432'], 'M_h_c': ['5', '0', '0.00127312147743201'],
                 'M_h_e': ['5', '0', '-0'], 'R_TALA': ['1', '1.49698375726157', '0'],
                 'R_SUCOAS': ['1', '-5.06437566148209', '0'], 'M_pep_c': ['5', '0', '-0.0420130087552564'],
                 'R_ICDHyr': ['1', '6.00724957535033', '0'], 'R_RPI': ['1', '-2.28150309406713', '0'],
                 'M_accoa_c': ['5', '0', '-0.0280086725035043'], 'R_EX_ac_e': ['2', '0', '-0.0229161865937762'],
                 'M_6pgl_c': ['5', '0', '-0.0903916248976729'], 'R_PFK': ['1', '7.47738196216028', '0'],
                 'M_oaa_c': ['5', '0', '-0.0420130087552564'], 'R_EX_glc_e': ['2', '-10', '-0.0916647463751049'],
                 'R_EX_h2o_e': ['1', '29.1758271355658', '0'], 'M_mal_L_c': ['5', '0', '-0.0483786161424165'],
                 'R_EX_nh4_e': ['1', '-4.76531919319746', '0'], 'M_acon_C_c': ['5', '0', '-0.0712948027361927'],
                 'R_ACALDt': ['1', '0', '0'], 'R_GLNS': ['1', '0.223461729331828', '0'],
                 'M_r5p_c': ['5', '0', '-0.0827528960330808'], 'R_ACONTb': ['1', '6.00724957535033', '0'],
                 'M_actp_c': ['5', '0', '-0.0292817939809363'], 'M_cit_c': ['5', '0', '-0.0712948027361927'],
                 'M_mal_L_e': ['5', '0', '-0.0458323731875524'], 'M_akg_c': ['5', '0', '-0.0623829523941686'],
                 'M_akg_e': ['5', '0', '-0.0611098309167366'], 'R_D_LACt2': ['1', '-0', '0'],
                 'R_ATPS4r': ['1', '45.5140097745175', '0'], 'M_ru5p_D_c': ['5', '0', '-0.0827528960330808'],
                 'R_TPI': ['1', '7.47738196216028', '0'], 'R_PPCK': ['2', '0', '-0.00509248590972805'],
                 'R_SUCCt2_2': ['2', '0', '-0.00381936443229604'], 'M_e4p_c': ['5', '0', '-0.0674754383038966'],
                 'R_NADH16': ['1', '38.5346096505154', '0'],
                 'R_Biomass_Ecoli_core_w_GAM': ['1', '0.87392150696843', '0'], 'R_GAPD': ['1', '16.0235261431676', '0'],
                 'R_PGI': ['1', '4.86086114649682', '0'], 'R_GLNabc': ['1', '0', '0'],
                 'R_AKGDH': ['1', '5.06437566148209', '0'], 'R_MDH': ['1', '5.06437566148209', '0'],
                 'R_EX_fum_e': ['2', '0', '-0.0458323731875524'], 'R_PYK': ['1', '1.75817744410678', '0'],
                 'M_etoh_c': ['5', '0', '-0.0407398872778244'], 'M_fum_c': ['5', '0', '-0.0483786161424165'],
                 'M_q8_c': ['5', '0', '0.00254624295486403'], 'M_etoh_e': ['5', '0', '-0.0394667658003924'],
                 'M_fum_e': ['5', '0', '-0.0458323731875524'], 'R_FRUpts2': ['1', '0', '0'],
                 'M_nadph_c': ['1', '-8.88178419700125e-16', '0'], 'R_ENO': ['1', '14.7161395687428', '0'],
                 'R_PIt2r': ['1', '3.21489504768477', '0'], 'R_EX_mal_L_e': ['2', '0', '-0.0458323731875524'],
                 'R_ACALD': ['1', '-5.84859702315521e-30', '0'], 'M_for_e': ['5', '0', '-0.00763872886459208'],
                 'M_nad_c': ['5', '0', '0.00763872886459208'], 'M_6pgc_c': ['5', '0', '-0.0916647463751049'],
                 'R_FORti': ['1', '5.31182206840464e-31', '0'], 'M_co2_c': ['5', '0', '-0'],
                 'R_PPS': ['2', '0', '-0.00509248590972805'], 'M_co2_e': ['5', '0', '-0'],
                 'R_EX_succ_e': ['2', '0', '-0.0521979805747125'], 'R_ACONTa': ['1', '6.00724957535033', '0'],
                 'M_nadh_c': ['1', '5.32907051820075e-15', '0'], 'R_FUM': ['1', '5.06437566148209', '0'],
                 'R_GND': ['1', '4.95998494457465', '0'], 'R_ACt2r': ['1', '-0', '0'],
                 'R_PPC': ['1', '2.50430947036873', '0'], 'R_EX_etoh_e': ['2', '0', '-0.0394667658003924'],
                 'R_AKGt2r': ['1', '-0', '0'], 'R_GLUN': ['2', '0', '-0.00509248590972805']}
    for key, val in result.items():
        assert val == reference[key]


def test_list_available_solvers():
    solvers = list_available_solvers()
    for solver, boolean in solvers.items():
        assert boolean is True or boolean is False


def test_glpk_read_cplex():
    problem = glpk_read_cplex(TESTMODELPATH)
    assert glp_get_num_rows(problem) == 72
    assert glp_get_num_cols(problem) == 95
