###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_java_se_unsafe_interaction_win.nasl 3899 2009-08-20 15:17:20Z aug $
#
# Unsafe Interaction In Sun Java SE Abstract Window Toolkit (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900820);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2717");
  script_name("Unsafe Interaction In Sun Java SE Abstract Window Toolkit (Win)");
  desc = "

  Overview: This host is installed with Sun Java SE and is prone to Unsafe
  Interaction.

  Vulnerability Insight:
  An error in the Abstract Window Toolkit (AWT) implementation on Windows
  2000 Professional does not provide a Security Warning Icon.

  Impact:
  Successful attacks will let the attackers to trick a user into interacting
  unsafely with an untrusted applet.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java SE version 6.0 before Update 15 on Windows.

  Fix: Upgrade to Java SE version 6 Update 15
  http://java.sun.com/javase/downloads/index.jsp

  References:
  http://java.sun.com/javase/6/webnotes/6u15.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Sun Java JRE/JDK");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_java_prdts_detect_win.nasl");
  script_require_keys("Sun/Java/JRE/Win/Ver", "Sun/Java/JDK/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");

if(hotfix_check_sp(win2k:5) <= 0){
  exit(0);
}

# Get KB for JDK Version On Windows
jdkVer = get_kb_item("Sun/Java/JDK/Win/Ver");

if(jdkVer)
{
  jdkVer = ereg_replace(pattern:"_", string:jdkVer, replace: ".");
  # Check for 1.6 < 1.6.0_15 (6 Update 15)
  if(version_in_range(version:jdkVer, test_version:"1.6", test_version2:"1.6.0.14")){
    security_warning(0);
    exit(0);
  }
}

# Get KB for JRE Version On Windows
jreVer = get_kb_item("Sun/Java/JRE/Win/Ver");

if(jreVer)
{
  jreVer = ereg_replace(pattern:"_", string:jreVer, replace: ".");
  # Check for 1.6 < 1.6.0_15 (6 Update 15)
  if(version_in_range(version:jreVer, test_version:"1.6", test_version2:"1.6.0.14")){
    security_warning(0);
  }
}
