###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_natterchat_mult_xss_n_sql_inj_vuln.nasl 4257 2009-08-26 15:38:09Z aug $
#
# NatterChat Multiple XSS And SQL Injection Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901007);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-7048", "CVE-2008-7049");
  script_bugtraq_id(32385);
  script_name("NatterChat Multiple XSS And SQL Injection Vulnerabilities");
  desc = "

  Overview: The host is running NatterChat and is prone to multiple XSS and SQL
  Injection vulnerabilities.

  Vulnerability Insight:
  - Multiple SQL injection flaws in login.asp, which can be caused via the
    'txtUsername' parameter and 'txtPassword' parameter in a form generated by
    home.asp.
  - Multiple XSS flaws which can be caused by injecting arbitrary web script
    or HTML via the 'txtUsername' parameter in registerDo.asp, as invoked from
    register.asp, or 'txtRoomName' parameter in room_new.asp.

  Impact:
  Successful exploitation will let the attackers to inject arbitrary web script
  or HTML code or execute arbitrary SQL commands in the context of an affected
  application.

  Impact Level: Application

  Affected Software/OS:
  NatterChat version 1.12 on Windows.

  Fix: No solution or patch is available as on 26th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.natterchat.co.uk/index.asp

  References:
  http://www.milw0rm.com/exploits/7175
  http://xforce.iss.net/xforce/xfdb/46768

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of NatterChat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_natterchat_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

nchatPort = get_http_port(default:80);
if(!nchatPort){
  exit(0);
}

nchatVer = get_kb_item("www/" + nchatPort + "/NatterChat");
nchatVer = eregmatch(pattern:"^(.+) under (/.*)$", string:nchatVer);

if(nchatVer[1] != NULL)
{
  if(version_is_equal(version:nchatVer[1], test_version:"1.12")){
    security_hole(nchatPort);
  }
}
