###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mini_stream_rm_downloader_bof_vuln.nasl 2010-03-31 12:29:17Z mar $
#
# Mini Stream RM Downloader '.smi' File Buffer Overflow Vulnerability
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902036);
  script_version("$Revision: 8038 $:1.0");
  script_cve_id("CVE-2009-4761");
 script_bugtraq_id(34794);
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_name("Mini Stream RM Downloader '.smi' File Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with Mini-stream RM Downloader and is prone
  to buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused by improper bounds checking when processing '.smi' files
  and can be exploited via crafted '.smi' file to cause buffer overflow.

  Impact:
  Successful exploitation allows remote attacker to execute arbitrary code on
  the system or cause the application to crash.

  Impact Level: Application

  Affected Software/OS:
  Mini-stream RM Downloader version 3.0.0.9 and prior.

  Fix: No solution or patch is available as on 31st, March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mini-stream.net/

  References:
  http://www.milw0rm.com/exploits/8594
  http://xforce.iss.net/xforce/xfdb/50266";

  script_description(desc);
  script_copyright("Copyright (c) 2010 SecPod");
  script_summary("Check the version of Mini-stream RM Downloader");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_dependencies("secpod_mini_stream_prdts_detect.nasl");
  script_require_keys("MiniStream/RMDown/Ver");
  exit(0);
}


include("version_func.inc");

# Get Mini-stream RM Downloader version
rmDownVer = get_kb_item("MiniStream/RMDown/Ver");
if(!rmDownVer){
  exit(0);
}

# Mini-stream RM Downloader version 3.0.0.9 => 3.0.2.1
if(version_is_less_equal(version:rmDownVer, test_version:"3.0.2.1")){
  security_hole(0);
}
