###############################################################################
# OpenVAS Vulnerability Test
# $Id: pligg_37185.nasl 7518 2010-05-04 08:39:45Z chandra $
#
# Pligg Cross Site Scripting And Request Forgery Remote Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100375);
 script_bugtraq_id(37185);
 script_version ("1.0-$Revision: 7518 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Pligg Cross Site Scripting And Request Forgery Remote Vulnerabilities");

desc = "Overview:
Pligg is prone to multiple cross-site scripting vulnerabilities and a
cross-site request-forgery vulnerability.

An attacker can exploit these issues to steal cookie-based
authentication credentials or perform unauthorized actions when
masquerading as the victim. Other attacks are also possible.

Versions prior to Pligg 1.0.3 are vulnerable.

Solution:
Vendor updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37185
http://holisticinfosec.org/content/view/130/45/
http://www.pligg.com/blog/775/pligg-cms-1-0-3-release/
http://www.pligg.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine the version of Pligg");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("pligg_cms_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/pligg")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "1.0.3")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
