###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# LinPHA 1.3.4 Multiple Cross-Site Scripting Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100120);
 script_bugtraq_id(34422);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("LinPHA 1.3.4 Multiple Cross-Site Scripting Vulnerabilities");
 desc = "

 Overview:
  According to its version number, the remote version of LinPHA is
  prone to multiple cross-site scripting vulnerabilities because it
  fails to sufficiently sanitize user-supplied input data.

  Attackers can leverage these issues to execute arbitrary script code
  in the browser of an unsuspecting user in the context of the
  affected site. This may help attackers steal cookie-based
  authentication credentials and launch other attacks.

  LinPHA 1.3.4 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34422

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if LinPHA = 1.3.4");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("linpha_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/linpha")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {
  if(version_is_less_equal(version: vers, test_version: "1.3.4")) { 
      security_warning(port:port);
      exit(0);
  }  

}   

exit(0);
