###############################################################################
# OpenVAS Vulnerability Test
# $Id: home_web_server_147.nasl 7515 2010-05-04 08:18:47Z chandra $
#
# Home Web Server Graphical User Interface Remote Denial Of Service Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100163);
 script_bugtraq_id(34698);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Home Web Server Graphical User Interface Remote Denial Of Service Vulnerability");
 desc = "

 Overview:
  According to its version number, the remote version of the Home Web Server is
  prone to a denial-of-service vulnerability because it fails to adequately
  handle malformed HTTP requests.

  Attackers can exploit this issue to cause the graphical interface of
  the server to stop responding, denying service to the administrator.

  Home Web Server 1.7.1.147 is vulnerable; other versions may also be
  affected. 

 See also:
  http://www.securityfocus.com/bid/34698

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Home Web Server is vulnerable to DoS");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("misc_func.inc");
include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)) exit(0);
if(get_kb_item("Services/www/" + port + "/embedded" ))exit(0);

banner = get_http_banner(port:port);
if (!banner)exit(0);
if(!egrep(pattern:"Server: .*\(HWS[0-9]+\)", string:banner) ) exit(0);

version = eregmatch(pattern: "HWS([0-9]+)", string: banner);

if(version[1] == "147") {

 security_warning(port:port);
 exit(0);

}  

exit(0);
