###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zenoss_serv_detect.nasl 7489 2010-03-02 15:50:35Z mar $
#
# Zenoss Server Version Detection
#
# Authors:
# Rachana Shetty <srachan@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800988);
  script_version("$Revision: 7732 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Zenoss Server Version Detection");
  desc = "
  Overview: This script detects the installed version of Zenoss Server
  and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of Zenoss Server in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

## Get Http Ports
httpPort = get_http_port(default:8080);
if(!httpPort){
  httpPort = 8080;
}

## Check Port status
if(!get_port_state(httpPort)){
  exit(0);
}

## Send Request and Receive Response
sndReq = http_get(item:"/zport/acl_users/cookieAuthHelper/login_form",
                  port:httpPort);
rcvRes = http_keepalive_send_recv(port:httpPort, data:sndReq);

if(("Zenoss Login" >< rcvRes))
{
  zenVer = eregmatch(pattern:"<span>([0-9.]+)" ,string:rcvRes);
  if(zenVer[1] != NULL)
  {
    set_kb_item(name:"www/" + httpPort + "/Zenoss", value:zenVer[1]);
    security_note(data:"Zenoss Server version " + zenVer[1] + " was detected on the host");
    exit(0);
  }
}
