###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for kernel 120011-14
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855516);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "SUNSolve", value: "120011-14");
  script_cve_id("CVE-2006-3738", "CVE-2006-4343", "CVE-2006-4339", "CVE-2006-2937", "CVE-2006-2940", "CVE-2007-0957", "CVE-2006-0225", "CAN-2005-2969");
  script_name( "Solaris Update for kernel 120011-14");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  kernel
  For more information please visit the below reference link.

  Affected Software/OS:
  kernel on solaris_5.10_sparc

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-120011-14-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"sparc", patch:"120011-14", package:"SUNWcakr.u SUNWsshcu SUNWpcmci SUNWcnetr SUNWcar.us SUNWdhcsu SUNWrcmdc SUNWperl584usr SUNWixgb SUNWpsu SUNWfss SUNWatfsu SUNWopenssl-include SUNWpmu SUNWlldap SUNWipfr SUNWudapltu SUNWzoner SUNWarc SUNWipfu SUNWfmd SUNWintgige SUNWscpu SUNWbtool SUNWxge SUNWidn.u SUNWsra FJSVcpcu SUNWperl584core SUNWbart SUNWkrbu SUNWdrcr.u SUNWsmapi SUNWtavor SUNWbcp SUNWipfh SUNWmdb SUNWzfsu SUNWsndmr SUNWaudit SUNWncar SUNWldomr.v SUNWiopc.v SUNWcakr.us SUNWpapi SUNWsshdu SUNWcart200.v SUNWcpr.u SUNWkvm.u SUNWsndmu SUNWpppdu SUNWnfssu SUNWdhcm SUNWkdcu SUNWmdr SUNWkvm.v SUNWkvm.us FJSVhea SUNWpool SUNWxcu4 SUNWudapltr SUNWdtrc SUNWopenssl-libraries SUNWus.u SUNWcsl FJSVmdbr SUNWcpcu SUNWses SUNWsadmi SUNWvolu SUNWcpc.v SUNWib SUNWkey SUNWnisu SUNWtoo SUNWsckmr SUNWdrr.u FJSVpiclu SUNWdmgtu SUNWkvmt200.v SUNWusbu SUNWefc.u SUNWpiclu SUNWypu SUNWpoolr SUNWftduu SUNWppm SUNWuksp SUNWcakr.v SUNWslpu SUNWusb SUNWcti2.u SUNWzfsr SUNWdrr.us SUNWroute SUNWckr SUNWcsr SUNWdoc SUNWefcr SUNWaudh SUNWefcl SUNWrge SUNWtecla SUNWmdbr SUNWldomu.v SUNWpcu SUNWdscpr.u SUNWzfskr SUNWarcr SUNWmdu SUNWdcsu SUNWrcapu FJSVmdb SUNWwbsup SUNWcar.v SUNWhea SUNWqos SUNWntpu SUNWnfsckr SUNWdtrp SUNWcpc.us SUNWpl5u SUNWlibsasl SUNWcslr SUNWippcore SUNWsshu SUNWdcsr SUNWcsu SUNWust1.v SUNWcar.u SUNWnfscu SUNWesu SUNWcsd SUNWfruip.u SUNWssad SUNWcpc.u SUNWipplr SUNWpsm-lpd SUNWuprl SUNWefc.us SUNWzoneu SUNWipplu SUNWrcapr SUNWdfbh SUNWwrsm.u SUNWftdur SUNWerid SUNWauda") < 0)
{
  security_hole(0);
  exit(0);
}