###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_mult_vuln_nov08_win.nasl 478 2008-11-18 14:45:57Z nov $
#
# Mozilla Seamonkey Multiple Vulnerabilities November-08 (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800061);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5012", "CVE-2008-5013", "CVE-2008-5014", "CVE-2008-5016",
                "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-5021", "CVE-2008-5022",
                "CVE-2008-5023", "CVE-2008-5024", "CVE-2008-5052", "CVE-2008-0017");
  script_bugtraq_id(32281);
  script_name("Mozilla Seamonkey Multiple Vulnerabilities November-08 (Win)");
  desc = "

  Overview: The host is installed with Mozilla Seamonkey and is prone
  to multiple vulnerabilities.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  bypass security restrictions, spoofing attacks, sensitive information
  disclosure, and JavaScript code that can be executed with the privileges
  of the signed user.

  Impact Level: System

  Affected Software/OS:
  Seamonkey version prior to 1.1.13 on Windows.

  Fix: Upgrade to Seamonkey version 1.1.13 or later
  http://www.seamonkey-project.org/releases/

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-48.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-49.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-50.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-52.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-54.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-55.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-56.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-57.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-58.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_seamonkey_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

smVer = get_kb_item("Seamonkey/Win/Ver");
if(!smVer){
  exit(0);
}

# Grep for firefox version < 2.0.0.18
if(version_is_less(version:smVer, test_version:"1.1.13")){
  security_hole(0);
}
