###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mult_vuln_july08_win.nasl 302 2008-10-03 12:37:36Z oct $
#
# Mozilla Firefox Multiple Vulnerability July-08 (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800011);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2800", "CVE-2008-2801",
                "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2805", "CVE-2008-2806",
                "CVE-2008-2807", "CVE-2008-2808", "CVE-2008-2809", "CVE-2008-2810",
                "CVE-2008-2811");
  script_bugtraq_id(30038);
  script_xref(name:"CB-A", value:"08-0109");
  script_name("Mozilla Firefox Multiple Vulnerability July-08 (Win)");
  desc = "

  Overview : The host is installed with Mozilla Firefox browser, that is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  Issues in browser are due to,
  - multiple errors in the layout and JavaScript engines that can corrupt
    memory.
  - error while handling unprivileged XUL documents that can be exploited to
    load chrome scripts from a fastload file via <script> elements.
  - error in mozIJSSubScriptLoader.LoadScript function can bypass
    XPCNativeWrappers.
  - error in block re-flow process, which can potentially lead to crash.
  - error in processing file URLs contained within local directory listings.
  - errors in the implementation of the Javascript same origin policy
  - errors in the verification of signed JAR files.
  - improper implementation of file upload forms result in uploading specially
    crafted DOM Range and originalTarget elements.
  - error in Java LiveConnect implementation.
  - error in processing of Alt Names provided by peer.
  - error in processing of windows URL shortcuts.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  spoofing attacks, sensitive information disclosure, and JavaScript code can
  be executed with the privileges of JAR's signer.
  
  Impact Level: System

  Affected Software/OS:
  Firefox version prior to 2.0.0.15 on Windows.

  Fix: Upgrade to Firefox version 2.0.0.15
  http://www.mozilla.com/en-US/firefox/all-older.html

  References :
  http://www.mozilla.org/security/announce/2008/mfsa2008-21.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-22.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-23.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-24.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-25.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-27.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-28.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-29.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-30.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-31.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-32.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-33.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl");
  exit(0);
}


# Grep for firefox version < 2.0.0.15
if(egrep(pattern:"^([01]\..*|2\.0(\.0\.(0?[0-9]|1[0-4]))?)$",
         string:get_kb_item("Firefox/Win/Ver"))){
  security_hole(0);
}
