# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1569-3 (cacti)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61359);
 script_cve_id("CVE-2008-0783", "CVE-2008-0785");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1569-3 (cacti)";
 script_name(name);

 desc = "The remote host is missing an update to cacti
announced via advisory DSA 1569-3.

Since the previous security update, the cacti package could no longer
be rebuilt from the source package. This update corrects that problem.
Note that this problem does not affect regular use of the provided
binary packages (.deb).

For reference the original advisory text follows.

It was discovered that Cacti, a systems and services monitoring frontend,
performed insufficient input sanitising, leading to cross site scripting
and SQL injection being possible.

For the stable distribution (etch), this problem has been fixed in
version 0.8.6i-3.5.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201569-3

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1569-3 (cacti)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cacti", ver:"0.8.6i-3.5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
