#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator.SetSeed(0)

try:
    distribution = Rayleigh(2.5, -1.0)
    size = 10000
    sample = distribution.getSample(size)
    factory = RayleighFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)
    estimatedDistribution = factory.build()
    print "Default distribution=", estimatedDistribution
    estimatedDistribution = factory.build(
        distribution.getParametersCollection())
    print "Distribution from parameters=", estimatedDistribution
    estimatedRayleigh = factory.buildAsRayleigh(sample)
    print "Rayleigh          =", distribution
    print "Estimated rayleigh=", estimatedRayleigh
    estimatedRayleigh = factory.buildAsRayleigh()
    print "Default rayleigh=", estimatedRayleigh
    estimatedRayleigh = factory.buildAsRayleigh(
        distribution.getParametersCollection())
    print "Rayleigh from parameters=", estimatedRayleigh

except:
    import sys
    print "t_RayleighFactory_std.py", sys.exc_type, sys.exc_value
