"predictValuesLm" <-
function(x, beta){

  # Checking for NAs in x, beta is assumed not to contain any
  indexNA <- which(is.na(x), arr.ind=TRUE)

  if(length(indexNA) > 0) {
   
    x[indexNA[, 1], ] <- NA 
    # Eliminating the NAs
    x <- matrix(x[ ! is.na(x)], ncol = ncol(x))
  }

  # Prediction.
  completeX <- cbind(rep(1, nrow(x)), x)
  predictedSample <- completeX %*% beta

  return(predictedSample)

}

