# dir.mms for omniORB
#
SUBDIRS = orbcore dynamic codesets

# Note that the MMS version of the makefiles don't build omniidl_be
# via $(MakeSubDirs).  Rather, the export of the python files to
# $(TOP)/lib/python is accomplished via $(ExportPythonFiles) below.

headers = distdate.hh\
	Naming.hh\
	corbaidl_defs.hh\
	corbaidl_operators.hh\
	corbaidl_poa.hh\
	ir_defs.hh\
	ir_operators.hh\
	ir_poa.hh\
	boxes_defs.hh\
	boxes_operators.hh\
	boxes_poa.hh\
	poa_enums_defs.hh\
	poa_enums_operators.hh\
	poa_enums_poa.hh\
	omniTypedefs.hh\
	bootstrap.hh\
	omniConnectionData.hh

localHeaders=$(foreach header,$(headers),[.omniORB4]$(header) )

omniORBInclude_V=$(SUBST ..,-,$(EXPORT_TREE)/include/omniORB4)
omniORBInclude_V=$(SUBST /,.,$(omniORBInclude_V))
omniORBInclude_V=[$(SUBST .-,-,$(omniORBInclude_V))]

exportHeaders=$(foreach header,$(headers),$(omniORBInclude_V)$(header) )

all :: $(localHeaders)

clean ::
	@ $(MakeSubdirs)

distdate_header = $(omniORBInclude_V)distdate.hh
Naming_header = $(omniORBInclude_V)Naming.hh
corbaidl_defs_header = $(omniORBInclude_V)corbaidl_defs.hh
corbaidl_operators_header = $(omniORBInclude_V)corbaidl_operators.hh
corbaidl_poa_header = $(omniORBInclude_V)corbaidl_poa.hh
ir_defs_header = $(omniORBInclude_V)ir_defs.hh
ir_operators_header = $(omniORBInclude_V)ir_operators.hh
ir_poa_header = $(omniORBInclude_V)ir_poa.hh
boxes_defs_header = $(omniORBInclude_V)boxes_defs.hh
boxes_operators_header = $(omniORBInclude_V)boxes_operators.hh
boxes_poa_header = $(omniORBInclude_V)boxes_poa.hh
poa_enums_defs_header = $(omniORBInclude_V)poa_enums_defs.hh
poa_enums_operators_header = $(omniORBInclude_V)poa_enums_operators.hh
poa_enums_poa_header = $(omniORBInclude_V)poa_enums_poa.hh
omniTypedefs_header = $(omniORBInclude_V)omniTypedefs.hh
bootstrap_header = $(omniORBInclude_V)bootstrap.hh
omniConnectionData_header = $(omniORBInclude_V)omniConnectionData.hh

export :: $(localHeaders) $(exportHeaders)
	@ $(ExportPythonFiles)
	@ $(MakeSubdirs)

tlist1_=.idl .hh SK.cc DynSK.cc
tlist2_=.idl _defs.hh _operators.hh SK.cc DynSK.cc

veryclean ::
	$(VERBOSITY) $(RM) $(foreach f,\
 $(foreach t,$(tlist1_),Naming$(t) ),[.omniORB4]$(f) )
	$(VERBOSITY) $(RM) $(foreach f,\
 $(foreach t,$(tlist1_),bootstrap$(t) ),[.omniORB4]$(f) )
	$(VERBOSITY) $(RM) [.omniORB4]distdate.hh
	$(VERBOSITY) $(RM) $(foreach f,\
 $(foreach t,.$(tlist2_),ir$(t) ),[.omniORB4]$(f) )
	$(VERBOSITY) $(RM) $(foreach f,\
 $(foreach t,$(tlist2_),corbaidl$(t) ),[.omniORB4]$(f) )

######################################################################
# Make rules for Stubs                                               #
######################################################################
OMNIORB_IDL_FLAGS=-DHAS_LongLong
OMNIORB_IDL = $(OMNIORB_IDL) -p$(BASE_OMNI_TREE)/src/lib/omniORB -Wbdebug\
 $(OMNIORB_IDL_FLAGS)

checkdir=if f$search("omniORB4.dir").eqs."" then\
	create/dir/log [.omniORB4]/prot=(o:rwd,w:r)

UPDATELOG_V=$(SUBST ..,-,$(BASE_OMNI_TREE))
UPDATELOG_V=$(SUBST /,.,$(UPDATELOG_V))
UPDATELOG_V=[$(SUBST .-,-,$(UPDATELOG_V))]update.log

[.omniORB4]distdate.hh : $(UPDATELOG_V)
	$(checkdir)
	@distdate.dcl

[.omniORB4]Naming.hh : Naming.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -ComniORB4 Naming.idl

[.omniORB4]boxes_defs.hh [.omniORB4]boxes_operators.hh [.omniORB4]boxes_poa.hh : boxes.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -WbF -ComniORB4 "-I./" boxes.idl

[.omniORB4]poa_enums_defs.hh [.omniORB4]poa_enums_operators.hh [.omniORB4]poa_enums_poa.hh : poa_enums.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -WbF -ComniORB4 "-I./" poa_enums.idl

[.omniORB4]omniTypedefs.hh : omniTypedefs.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -ComniORB4 $<

[.omniORB4]bootstrap.hh : bootstrap.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -ComniORB4 bootstrap.idl

[.omniORB4]omniConnectionData.hh : omniConnectionData.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -ComniORB4 $<

[.omniORB4]ir_defs.hh [.omniORB4]ir_operators.hh [.omniORB4]ir_poa.hh :\
 ir.idl corbaidl.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -WbF -ComniORB4 "-I./" ir.idl

[.omniORB4]corbaidl_defs.hh\
 [.omniORB4]corbaidl_operators.hh\
 [.omniORB4]corbaidl_poa.hh : corbaidl.idl
	$(checkdir)
	$(OMNIORB_IDL) -v -WbF -ComniORB4 corbaidl.idl


# Make rules to import idls from ['top'.idl]
IDLPATH_V=$(SUBST ..,-,$(IMPORT_TREES)/idl)
IDLPATH_V=$(SUBST /,.,$(IDLPATH_V))
IDLPATH_V=[$(SUBST .-,-,$(IDLPATH_V))]

Naming.idl : $(IDLPATH_V)Naming.idl
	backup/log/new $< []

boxes.idl : $(IDLPATH_V)boxes.idl
	backup/log/new $< []

poa_enums.idl : $(IDLPATH_V)poa_enums.idl
	backup/log/new $< []

omniTypedefs.idl : $(IDLPATH_V)omniTypedefs.idl
	backup/log/new $< []

bootstrap.idl : $(IDLPATH_V)bootstrap.idl
	backup/log/new $< []

omniConnectionData.idl : $(IDLPATH_V)omniConnectionData.idl
	backup/log/new $< []

ir.idl : $(IDLPATH_V)ir.idl
	backup/log/new $< []

corbaidl.idl : $(IDLPATH_V)corbaidl.idl
	backup/log/new $< []

######################################################################
# Make rules for Exporting headers                                   #
######################################################################

$(distdate_header) : [.omniORB4]distdate.hh
	@ $(ExportHeader)

$(Naming_header) : [.omniORB4]Naming.hh
	@ $(ExportHeader)

$(corbaidl_defs_header) : [.omniORB4]corbaidl_defs.hh
	@ $(ExportHeader)

$(corbaidl_operators_header) : [.omniORB4]corbaidl_operators.hh
	@ $(ExportHeader)

$(corbaidl_poa_header) : [.omniORB4]corbaidl_poa.hh
	@ $(ExportHeader)

$(ir_defs_header) : [.omniORB4]ir_defs.hh
	@ $(ExportHeader)

$(ir_operators_header) : [.omniORB4]ir_operators.hh
	@ $(ExportHeader)

$(ir_poa_header) : [.omniORB4]ir_poa.hh
	@ $(ExportHeader)

$(boxes_defs_header)  : [.omniORB4]boxes_defs.hh
	@ $(ExportHeader)

$(boxes_operators_header)  : [.omniORB4]boxes_operators.hh
	@ $(ExportHeader)

$(boxes_poa_header)  : [.omniORB4]boxes_poa.hh
	@ $(ExportHeader)

$(poa_enums_defs_header) 	: [.omniORB4]poa_enums_defs.hh
	@ $(ExportHeader)

$(poa_enums_operators_header) 	: [.omniORB4]poa_enums_operators.hh
	@ $(ExportHeader)

$(poa_enums_poa_header) 	: [.omniORB4]poa_enums_poa.hh
	@ $(ExportHeader)

$(omniTypedefs_header) : [.omniORB4]omniTypedefs.hh
	@ $(ExportHeader)

$(bootstrap_header) : [.omniORB4]bootstrap.hh
	@ $(ExportHeader)

$(omniConnectionData_header) : [.omniORB4]omniConnectionData.hh
	@ $(ExportHeader)

show ::
	! localheaders=$(localheaders)