/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.torque.engine.database.model.AppData;
import org.apache.turbine.torque.engine.database.model.Column;
import org.apache.turbine.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class Database {
    private List tableList = new ArrayList(100);
    private Column curColumn;
    private String name;
    private String pkg;
    private String baseClass;
    private String basePeer;
    private String defaultIdMethod;
    private AppData dbParent;
    private Hashtable tablesByName = new Hashtable();
    private Hashtable tablesByJavaName = new Hashtable();

    public void loadFromXML(Attributes attrib) {
        this.name = attrib.getValue("name");
        if (this.name == null) {
            this.name = TurbineDB.getDefaultDB();
        }
        this.pkg = attrib.getValue("package");
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.defaultIdMethod = attrib.getValue("defaultIdMethod");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String v) {
        this.pkg = v;
    }

    public String getBaseClass() {
        if (this.baseClass == null) {
            return "BaseObject";
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.basePeer == null) {
            return "BasePeer";
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public String getDefaultIdMethod() {
        return this.defaultIdMethod;
    }

    public void setDefaultIdMethod(String v) {
        this.defaultIdMethod = v;
    }

    public Table[] getTables() {
        int size = this.tableList.size();
        Table[] tbls = new Table[size];
        int i = 0;
        while (i < size) {
            tbls[i] = (Table)this.tableList.get(i);
            ++i;
        }
        return tbls;
    }

    public Table getTable(String name) {
        return (Table)this.tablesByName.get(name);
    }

    public Table getTableByJavaName(String javaName) {
        return (Table)this.tablesByJavaName.get(javaName);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.loadFromXML(attrib, this.getDefaultIdMethod());
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this.tableList.add(tbl);
        this.tablesByName.put(tbl.getName(), tbl);
        this.tablesByJavaName.put(tbl.getJavaName(), tbl);
    }

    public void setAppData(AppData parent) {
        this.dbParent = parent;
    }

    public AppData getAppData() {
        return this.dbParent;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<database name=\"" + this.getName());
        result.append(" package=\"" + this.getPackage() + "\"");
        result.append(" defaultIdMethod=\"" + this.getDefaultIdMethod() + "\"");
        result.append(" baseClass=\"" + this.getBaseClass() + "\"");
        result.append(" basePeer=\"" + this.getBasePeer() + "\"");
        result.append(">\n");
        Iterator i = this.tableList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        result.append("</database>");
        return result.toString();
    }
}

