Created by [jonschlinkert]({%= author.url %}) and [doowb](https://github.com/doowb).

**Features**

- Bootstrap your own parser, get sourcemap support for free
- All parsing and compiling is handled by simple, reusable middleware functions
- Inspired by the parsers in [pug][] and [css][].

## History

### v0.5.0

**Breaking changes**

Substantial breaking changes were made in v0.5.0! Most of these changes are part of a larger refactor that will be finished in 0.6.0, including the introduction of a `Lexer` class. 

- Renderer was renamed to `Compiler`
- the `.render` method was renamed to `.compile`
- Many other smaller changes. A more detailed overview will be provided in 0.6.0. If you don't have to time review code, I recommend you wait for the 0.6.0 release.


## Usage examples

```js
var Snapdragon = require('{%= name %}');
var snapdragon = new Snapdragon();
```

**Parse**

```js
var ast = snapdragon.parser('some string', options)
  // parser middleware that can be called by other middleware
  .set('foo', function () {})
  // parser middleware, runs immediately in the order defined
  .use(bar())
  .use(baz())
```

**Render**

```js
// pass the `ast` from the parse method
var res = snapdragon.compiler(ast)
  // compiler middleware, called when the name of the middleware
  // matches the `node.type` (defined in a parser middleware)
  .set('bar', function () {})
  .set('baz', function () {})
  .compile()
```

See the [examples](./examples/).

## Getting started

**Parsers**

Parsers are middleware functions used for parsing a string into an ast node.

```js
var ast = snapdragon.parser(str, options)
  .use(function() {
    var pos = this.position();
    var m = this.match(/^\./);
    if (!m) return;
    return pos({
      // `type` specifies the compiler to use
      type: 'dot',
      val: m[0]
    });
  })
```

**AST node**

When the parser finds a match, `pos()` is called, pushing a token for that node onto the ast that looks something like:

```js
{ type: 'dot',
  val: '.',
  position:
   { start: { lineno: 1, column: 1 },
     end: { lineno: 1, column: 2 } }}
```

**Renderers**

Renderers are _named_ middleware functions that visit over an array of ast nodes to compile a string.


```js
var res = snapdragon.compiler(ast)
  .set('dot', function (node) {
    console.log(node.val)
    //=> '.'
    return this.emit(node.val);
  })
```

**Source maps**

If you want source map support, make sure to emit the position as well.

```js
var res = snapdragon.compiler(ast)
  .set('dot', function (node) {
    return this.emit(node.val, node.position);
  })
```

## Docs

### Parser middleware

A parser middleware is a function that returns an abject called a `token`. This token is pushed onto the AST as a node.

**Example token**

```js
{ type: 'dot',
  val: '.',
  position:
   { start: { lineno: 1, column: 1 },
     end: { lineno: 1, column: 2 } }}
```

**Example parser middleware**

Match a single `.` in a string:

  1. Get the starting position by calling `this.position()`
  1. pass a regex for matching a single dot to the `.match` method
  1. if **no match** is found, return `undefined`
  1. if a **match** is found, `pos()` is called, which returns a token with:
      * `type`: the name of the [compiler] to use
      * `val`: The actual value captured by the regex. In this case, a `.`. Note that you can capture and return whatever will be needed by the corresponding [compiler].
      * The ending position: automatically calculated by adding the length of the first capture group to the starting position. 


## Renderer middleware

Renderers are run when the name of the compiler middleware matches the `type` defined on an ast `node` (which is defined in a parser).

**Example**

Exercise: Parse a dot, then compile it as an escaped dot.

```js
var ast = snapdragon.parser('.')
  .use(function () {
    var pos = this.position();
    var m = this.match(/^\./);
    if (!m) return;
    return pos({
      // define the `type` of compiler to use
      type: 'dot',
      val: m[0]
    })
  })

var result = snapdragon.compiler(ast)
  .set('dot', function (node) {
    return this.emit('\\' + node.val);
  })
  .compile()

console.log(result.output);
//=> '\.'
```

## API

### Parse
{%= apidocs("lib/parser.js") %}

### Render
{%= apidocs("lib/compiler.js") %}
