<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [CDPSession](./puppeteer.cdpsession.md)

## CDPSession class

The `CDPSession` instances are used to talk raw Chrome Devtools Protocol.

<b>Signature:</b>

```typescript
export declare class CDPSession extends EventEmitter
```
<b>Extends:</b> [EventEmitter](./puppeteer.eventemitter.md)

## Remarks

Protocol methods can be called with [CDPSession.send()](./puppeteer.cdpsession.send.md) method and protocol events can be subscribed to with `CDPSession.on` method.

Useful links: [DevTools Protocol Viewer](https://chromedevtools.github.io/devtools-protocol/) and [Getting Started with DevTools Protocol](https://github.com/aslushnikov/getting-started-with-cdp/blob/master/README.md).

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `CDPSession` class.

## Example


```js
const client = await page.target().createCDPSession();
await client.send('Animation.enable');
client.on('Animation.animationCreated', () => console.log('Animation created!'));
const response = await client.send('Animation.getPlaybackRate');
console.log('playback rate is ' + response.playbackRate);
await client.send('Animation.setPlaybackRate', {
  playbackRate: response.playbackRate / 2
});

```

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [detach()](./puppeteer.cdpsession.detach.md) |  | Detaches the cdpSession from the target. Once detached, the cdpSession object won't emit any events and can't be used to send messages. |
|  [send(method, paramArgs)](./puppeteer.cdpsession.send.md) |  |  |
