if (typeof T === 'undefined') require('../setup');

T('toDecimalPlaces', function () {

  function t(expected, n, dp, rm) {
    T.assertEqual(expected, new Decimal(n).toDP(dp, rm).valueOf());
  }

  function tx(fn, msg) {
    T.assertException(fn, msg);
  }

  Decimal.config({
    precision: 20,
    rounding: 7,
    toExpNeg: -9e15,
    toExpPos: 300,
    minE: -9e15,
    maxE: 9e15
  });

  T.assert(Decimal.prototype.toDP === Decimal.prototype.toDecimalPlaces);

  t('0', 0);
  t('-1', -1);
  t('9.999e+9000000000000000', '9.999e+9000000000000000');
  t('-9.999e+9000000000000000', '-9.999e+9000000000000000');
  t('1e-9000000000000000', '1e-9000000000000000');
  t('-1e-9000000000000000', '-1e-9000000000000000');
  t('Infinity', Infinity);
  t('-Infinity', -Infinity);
  t('NaN', NaN);
  t('Infinity', 'Infinity', 0);
  t('-Infinity', '-Infinity', 0);

  t('1', 0.5, 0);
  t('1', 0.7, 0);
  t('1', 1, 0);
  t('1', 1.1, 0);
  t('1', 1.49999, 0);
  t('-0', -0.5, 0);
  t('-1', -0.500001, 0);
  t('-1', -0.7, 0);
  t('-1', -1, 0);
  t('-1', -1.1, 0);
  t('-1', -1.49999, 0);
  t('-1', -1.5, 0);

  t('0', 0.4, 0);
  t('-0', -0.4, 0);
  t('-0', -0.5, 0);
  t('1', 0.6, 0);
  t('-1', -0.6, 0);
  t('2', 1.5, 0);
  t('2', 1.6, 0);
  t('-2', -1.6, 0);

  t('0', '0', 0);
  t('-0', '-0', 1);
  t('-0', '-0', 1, 0);
  t('-0', '-0', 1, 3);
  t('-0', '-0', 1, 6);
  t('0', '0', 10);
  t('-0', '-0', 20);

  t('0.000000000001', '0.0000000000005', 12);
  t('0.00000000001', '0.000000000005', 11);
  t('0.0000000001', '0.00000000005', 10);
  t('0.000000001', '0.0000000005', 9);
  t('0.00000001', '0.000000005', 8);
  t('0.0000001', '0.00000005', 7);
  t('0.000001', '0.0000005', 6);
  t('0.00001', '0.000005', 5);
  t('0.0001', '0.00005', 4);
  t('0.001', '0.0005', 3);
  t('0.01', '0.005', 2);
  t('0.1', '0.05', 1);
  t('1', '0.5', 0);

  t('0.01', '0.00001000', 2, 0);
  t('0.0039', '0.0039', 4, 3);
  t('-41620.65299', '-41620.65299', 6, 5);
  t('0.0011117', '0.0011117', 7, 0);
  t('938116', '938116', 6, 5);
  t('-7187', '-7187', 4, 4);
  t('-2.4263', '-2.426346', 4, 6);
  t('-0.537', '-0.5374743', 3, 5);
  t('652506', '652506', 3, 6);
  t('-178587', '-178587', 3, 2);
  t('4093', '4093', 3, 0);
  t('44', '44', 1, 2);
  t('-0.0496', '-0.049635', 4, 4);
  t('-1', '-0.05', 0, 0);
  t('520216039', '520216039', 7, 1);
  t('-2932289', '-2932289', 8, 3);
  t('53937.3', '53937.399', 1, 1);
  t('63101619', '63101619', 5, 0);
  t('-0.00207', '-0.00207', 6, 0);
  t('-0.032', '-0.03169086', 3, 0);
  t('-755', '-755', 5, 3);
  t('-3583', '-3583', 5, 1);
  t('-6.616', '-6.615375', 3, 0);
  t('7528739', '7528739', 8, 0);
  t('-0.9028', '-0.9028782', 4, 2);
  t('-8.78762908', '-8.78762908', 8, 2);
  t('-0.000262', '-0.0002613', 6, 0);
  t('-888980.3', '-888980.3', 1, 6);
  t('0.00009075', '0.00009075', 8, 0);
  t('-4.42', '-4.4195', 2, 0);
  t('-0.336889', '-0.336888682', 6, 6);
  t('43759', '43759', 6, 4);
  t('0.0000804', '0.0000804', 8, 6);
  t('-4', '-4', 0, 2);
  t('-3', '-3.614204', 0, 2);
  t('336379823', '336379823', 4, 1);
  t('310614', '310614', 7, 0);
  t('-375811635', '-375811635', 8, 3);
  t('-5446775', '-5446775', 7, 4);
  t('59.7954405', '59.7954405', 7, 0);
  t('47086', '47085.84', 0, 4);
  t('-2564', '-2564', 3, 4);
  t('1.4069997', '1.40699967', 7, 2);
  t('-0.4', '-0.42528874', 1, 6);
  t('-0.00005573', '-0.000055732', 8, 1);
  t('-0.00003014', '-0.000030137', 8, 6);
  t('57', '57', 3, 6);
  t('365474.9164', '365474.9164', 4, 5);
  t('-7', '-7', 0, 4);
  t('0.843206', '0.84320562', 6, 5);
  t('-62734', '-62734', 5, 3);
  t('-51246', '-51246', 7, 2);
  t('0.0003', '0.000332', 4, 5);
  t('-609', '-609', 2, 0);
  t('-0.00004595', '-0.00004595', 8, 1);
  t('-22243', '-22243', 0, 1);
  t('54693', '54693', 5, 0);
  t('5', '5', 1, 6);
  t('2', '2', 2, 6);
  t('3808', '3808', 0, 4);
  t('2616', '2616', 0, 5);
  t('-2477', '-2477', 3, 2);
  t('0.00009', '0.00008892', 5, 4);
  t('8.8953', '8.8953', 5, 5);
  t('0.07', '0.06922', 2, 4);
  t('0.08', '0.08', 3, 2);
  t('-773.0965536', '-773.0965536', 8, 2);
  t('-326', '-326', 2, 1);
  t('-0.356', '-0.3564473', 3, 6);
  t('-312283993', '-312283992.7', 0, 3);
  t('-2.3995861', '-2.39958606', 7, 3);
  t('-0.0449', '-0.0449', 4, 3);
  t('-0', '-0.003', 0, 4);
  t('85942', '85942', 2, 5);
  t('6738', '6738.1977', 0, 3);
  t('-0.003', '-0.002995', 5, 3);
  t('-572936', '-572936', 3, 6);
  t('684.2426407', '684.2426407', 8, 6);
  t('-0', '-0.0007851', 1, 6);
  t('-0', '-0.002', 0, 5);
  t('85.05', '85.05', 3, 3);
  t('1.66', '1.66', 3, 3);
  t('-17.14', '-17.14', 2, 0);
  t('80182', '80182', 6, 5);
  t('-0.00064', '-0.00063953', 6, 6);
  t('-3.76703298', '-3.767032983', 8, 4);
  t('-0.000378', '-0.00037877', 6, 2);
  t('675', '675.76294', 0, 3);
  t('0.0003', '0.00023235', 4, 0);
  t('-0.0155175', '-0.0155175', 7, 0);
  t('-645406477.5', '-645406477.5', 2, 1);
  t('-0.89603', '-0.8960278', 5, 6);
  t('866034', '866034', 7, 3);
  t('484.002', '484.002', 4, 6);
  t('420', '419.83', 0, 6);
  t('4611867124', '4611867124', 4, 4);
  t('0.0080252', '0.0080252', 8, 0);
  t('-0', '-0.02829833', 1, 4);
  t('-8', '-8', 0, 4);
  t('-0.0073554', '-0.00735541', 7, 4);
  t('28', '28', 3, 5);
  t('-3903', '-3903', 6, 0);
  t('228', '228', 3, 4);
  t('0.88', '0.883', 2, 5);
  t('-0.01', '-0.009', 2, 3);
  t('7796.6', '7796.6', 2, 2);
  t('0', '0.005', 0, 6);
  t('805.25', '805.2467', 2, 0);
  t('-85023', '-85023', 4, 3);
  t('-0', '-0.008097491', 0, 2);
  t('-0.026', '-0.0259', 3, 4);
  t('-0.00801', '-0.008007359', 5, 4);
  t('30745', '30745', 6, 5);
  t('-81', '-81', 4, 6);
  t('-386', '-386', 4, 2);
  t('-2876', '-2876', 5, 6);
  t('0', '0.00002329', 4, 5);
  t('-62453828', '-62453828', 7, 6);
  t('0.317', '0.317', 3, 3);
  t('-706', '-706', 0, 1);
  t('36.911', '36.9109527', 4, 4);
  t('5040908', '5040908', 1, 0);
  t('-0.08', '-0.08', 2, 4);
  t('-0.352847', '-0.352847085', 6, 6);
  t('0.001', '0.00006', 3, 2);
  t('-0.4389', '-0.438905', 4, 1);
  t('0.00390964', '0.00390964', 8, 2);
  t('-35105.1', '-35105.1788', 1, 2);
  t('-8858843.829', '-8858843.829', 3, 1);
  t('-5946.90816', '-5946.90816', 5, 3);
  t('608475', '608475', 6, 6);

  t('-249815496353142605063083339706423770452529255711064841247978.1649', '-249815496353142605063083339706423770452529255711064841247978.16482575714251625720191747855256', 4, 3);
  t('-8757939868931375459275247990933877309', '-8757939868931375459275247990933877309', 37, 5);
  t('556228688742576287254121716253667920283844645854057755303259369', '556228688742576287254121716253667920283844645854057755303259369', 25, 3);
  t('0', '0.00000000000000000000000000000000000000000000000029171651270270187897342247995644546232788426', 35, 3);
  t('-0.0000058979376152458865088785307705', '-0.000005897937615245886508878530770431196412050562641578155968', 34, 0);
  t('-0.00000000000000847145658', '-0.00000000000000847145657888758222743159237', 23, 3);
  t('-6049825281564367887763596943301191584240212075976455', '-6049825281564367887763596943301191584240212075976455', 53, 0);
  t('-64680661822322715719008107701612.741312367131318202976964422', '-64680661822322715719008107701612.74131236713131820297696442216284615573809', 27, 4);
  t('-0', '-0.0000000000000000000000000000000000048810387700772580768508931440796984745771392', 29, 2);
  t('232730083859746141163.7653402888578932348762190816502', '232730083859746141163.76534028885789323487621908165018267559238917447610653431235463768839108', 31, 5);
  t('-499311204526771278437755030091270601.471802335', '-499311204526771278437755030091270601.47180233568698638607829334564', 9, 2);
  t('-4793558721695298336734196955569628362250.1', '-4793558721695298336734196955569628362250.107513868618556605590137359591047843592593', 1, 6);
  t('0.0000000000000000000000000000000000000622', '0.000000000000000000000000000000000000062176566496', 40, 5);
  t('-393323198834362857317921391989917230.1575124832953752419421908305674188204', '-393323198834362857317921391989917230.15751248329537524194219083056741882044261538788798', 37, 5);
  t('-0', '-0.000000000000000169092170076859363', 3, 5);
  t('0.00085774283834918184933525579624189945402764', '0.0008577428383491818493352557962418994540276420616048890965876345513', 44, 4);
  t('-127706837731025454069338274697755478243.226555768723254468591', '-127706837731025454069338274697755478243.226555768723254468591', 21, 4);
  t('0.0000000000000000000000000000002', '0.00000000000000000000000000000024', 31, 6);
  t('0', '0.0000000000000000006', 0, 4);
  t('0.000000000000000000000007810237984104', '0.00000000000000000000000781023798410401506609033130277607174', 36, 6);
  t('-0.0000000000000000000000000000000000000000000003', '-0.00000000000000000000000000000000000000000000030032464295099044566372323', 46, 1);
  t('-685966223751248103958158215191994961086468451812432', '-685966223751248103958158215191994961086468451812432', 15, 6);
  t('-342139733926317660019.326340161146875487297', '-342139733926317660019.326340161146875487297346019153178', 21, 6);
  t('0', '0.000000000000000000000000000000000000000000901836202', 15, 4);
  t('54703159147681578.1514852895273075959730711237955491690133829927977209580124', '54703159147681578.1514852895273075959730711237955491690133829927977209580124', 59, 0);
  t('-460718430436988680547605508933197195738591668941440213118174196', '-460718430436988680547605508933197195738591668941440213118174196', 16, 6);
  t('70597943458486911871858911963104830835210711517857117431432573585719054629372', '70597943458486911871858911963104830835210711517857117431432573585719054629372', 17, 3);
  t('0', '0.0000000000000000000000005', 17, 1);
  t('612277653819449429818059108521923195679275819340316389136081740197236376194', '612277653819449429818059108521923195679275819340316389136081740197236376194', 24, 6);
  t('0', '0.000004077002116450599035175933786605407147118579202271612670066923117668943811493201471493894', 0, 3);
  t('0', '0.0000000000000000454362126792715044166595091', 4, 5);
  t('-0.00000000000000000000000247815', '-0.00000000000000000000000247815', 29, 2);
  t('-0.000000000000000000000000000000039578053693', '-0.000000000000000000000000000000039578053693375996216932325600263217353654', 42, 4);
  t('-232816283401672701377791127757043050155711815150567236808118951', '-232816283401672701377791127757043050155711815150567236808118951', 5, 2);
  t('-29071348593675752783607764808066026', '-29071348593675752783607764808066026', 0, 3);
  t('-0', '-0.0000000000000000000000000000001261801374206123908708248209346534624420321535319795165638569', 3, 5);
  t('-400979013779505784551704647545324555644743917317817725', '-400979013779505784551704647545324555644743917317817725', 51, 0);
  t('-707984518604562445981560648691697348187535181109991331112833004096934116229906958', '-707984518604562445981560648691697348187535181109991331112833004096934116229906958', 33, 3);
  t('-0.00000000000000000000054943542078511748325889425', '-0.00000000000000000000054943542078511748325889425029425118', 48, 2);
  t('0.000000000000000000000000000001', '0.0000000000000000000000000000000004', 30, 2);
  t('8361324754302.257', '8361324754302.25608823898722021345099998761427662952277448263515002938433228636937277798222125', 3, 2);
  t('47845474280015515238795364952786480611238289992139357357828.2393536', '47845474280015515238795364952786480611238289992139357357828.23935359', 7, 2);
  t('2549907485257905040787802731022172814.032473410309278713663931353982863019132463', '2549907485257905040787802731022172814.03247341030927871366393135398286301913246263649610180999011', 42, 4);
  t('7245563391265598645357861460253613932139592382610560614764364520097782949512752649', '7245563391265598645357861460253613932139592382610560614764364520097782949512752649', 40, 1);
  t('80140230840302995211398777354070268652682793260175436489292', '80140230840302995211398777354070268652682793260175436489292', 35, 5);
  t('-6237457908203764779831412120415113057397781437576879126960196359736451276', '-6237457908203764779831412120415113057397781437576879126960196359736451276', 46, 3);
  t('-64022435787355811014521281511793708435812347405139910972682589', '-64022435787355811014521281511793708435812347405139910972682589', 59, 4);
  t('23773726397.29160222442891928943538179152516815326677387048397317891529', '23773726397.291602224428919289435381791525168153266773870483973178915287792', 59, 2);
  t('-0.0000000000000000009191736362201691567821986127083610325635', '-0.00000000000000000091917363622016915678219861270836103256344707473557037101545788367584278310776658', 58, 3);
  t('576493832674677623548573635478304255.82263895978273', '576493832674677623548573635478304255.82263895978273', 14, 5);
  t('0.00000000001', '0.00000000000000000000000000000000000000000000000007822968340296738406', 11, 2);
  t('-0', '-0.00000000000000000000000000000000000000000000000803017739', 16, 2);
  t('-76782672919180281245123823777032511965124724736456274885479622075418722', '-76782672919180281245123823777032511965124724736456274885479622075418722', 48, 4);
  t('4455851923984827076883518360355220330356', '4455851923984827076883518360355220330356', 36, 6);
  t('6861599706553109843427643365400432566541688718985576240352998201999416183743', '6861599706553109843427643365400432566541688718985576240352998201999416183743', 2, 2);
  t('0', '0.0000083135366316053183734543904737952651532784316140061929170739473518406297062533554026617147464', 0, 1);
  t('72361127388902796012114362477322144735533135802605580980837229637633107.0925818254603', '72361127388902796012114362477322144735533135802605580980837229637633107.09258182546029609579105130429', 13, 5);
  t('-273219046129778472266.058485499109338596573075', '-273219046129778472266.0584854991093385965730749815531346353045049027336176088162559', 24, 4);
  t('-0.00000000000007280978660680040221854732703892674800762227646', '-0.00000000000007280978660680040221854732703892674800762227646226836240552990665555', 59, 5);
  t('6276464097096605785329824864148.527049815380996985914', '6276464097096605785329824864148.52704981538099698591393138250952524233217779', 21, 0);
  t('-597198', '-597197.628834953506966767991553710700934413500204012426446876175175114500037146677042239668', 0, 0);
  t('-433359038877962603713455049783', '-433359038877962603713455049783', 30, 0);
  t('0.0000000000000000000000000000000006381735336173415547900207', '0.0000000000000000000000000000000006381735336173415547900206847223271181528556195', 58, 0);
  t('807050820.676699481791051456', '807050820.676699481791051455096629111775329549493444751897213743866128850061622892', 18, 2);
  t('0.0000000000000000000000000000489752745584111598026871408099', '0.000000000000000000000000000048975274558411159802687140809907', 58, 3);
  t('0', '0.0000000000000000000000000000000000000000000226067497099004331941912856', 36, 6);
  t('39094507220356523575213839820749561678857032020620050894656716293.67495126324', '39094507220356523575213839820749561678857032020620050894656716293.67495126323710280607325675762434', 11, 2);
  t('-22678769.817248435493696742588538', '-22678769.817248435493696742588538331241538369550386799148219117165563326051964281', 24, 4);
  t('5767307789536064608781837241295188919', '5767307789536064608781837241295188919', 30, 0);
  t('168139421336703751454723348941581.0989620502676347173183006762310303463068390391675336175', '168139421336703751454723348941581.0989620502676347173183006762310303463068390391675336175', 55, 6);
  t('-88504154823150878334701258558002569539793415193610842759120001088201133334307983', '-88504154823150878334701258558002569539793415193610842759120001088201133334307983', 44, 4);
  t('-329655464734888739743767364510089523323', '-329655464734888739743767364510089523323', 25, 1);
  t('0.00000000000000000000084501920385200277918', '0.000000000000000000000845019203852002779189', 41, 1);
  t('-5840123488663376216608124416421102623453621285401805153644515702191', '-5840123488663376216608124416421102623453621285401805153644515702191', 59, 3);
  t('-0.00000062136', '-0.00000062135994705765807424168688040116009865960794', 13, 3);
  t('-0.000000000000000000001', '-0.00000000000000000000000000000000000000001462340018509', 21, 0);
  t('0.006', '0.0059936079684973012978514720463815026319867172', 4, 2);
  t('526400924922583880463185416850358172941032433541198785132036360013561525242705246671523133061757', '526400924922583880463185416850358172941032433541198785132036360013561525242705246671523133061757', 38, 6);
  t('-882873192309626516849737955750920016208815071464396145314', '-882873192309626516849737955750920016208815071464396145314', 46, 6);
  t('-6758735221049379519.2572393', '-6758735221049379519.25723934716782621573177906', 7, 2);
  t('-0.000000790786371520517683432954223230156393', '-0.00000079078637152051768343295422323015639290504929', 42, 4);
  t('-0.00000000000000000000000000000000000091966', '-0.0000000000000000000000000000000000009196610338039484256720548095', 41, 6);
  t('-0.00000000000541933780252974657673566396725809671507', '-0.0000000000054193378025297465767356639672580967150744942399', 50, 4);
  t('-0.000000000000000000000583479626', '-0.000000000000000000000583479626800396501245049473177007318461587644875162633137088', 30, 2);
  t('11604528953141243475', '11604528953141243475', 13, 3);
  t('566807769866890.02801522720838416179840190775794257854696482', '566807769866890.02801522720838416179840190775794257854696482590456963092114076898', 44, 3);
  t('-35620697798492911.0669248410687861643251268323797667576839159303711022', '-35620697798492911.066924841068786164325126832379766757683915930371102255700535220012496346147093317', 52, 1);
  t('-0.0000000000000000000050597138398214172387021051', '-0.000000000000000000005059713839821417238702105087169671933387005', 46, 0);
  t('-0.8174627036499993060703761337876311', '-0.81746270364999930607037613378763105641195817852303184573911882', 34, 4);
  t('0.0000000000000000000016801618027332596946', '0.000000000000000000001680161802733259694523102897059933026814910108114561982575916856344241', 40, 2);
  t('-0.0005550919624693963627417354876271038367574907', '-0.000555091962469396362741735487627103836757490736793688', 46, 6);
  t('0.00000000000001', '0.0000000000000000005989657036', 14, 2);
  t('26923162467831521466200388799932149017792464401239965995848900909703513553682', '26923162467831521466200388799932149017792464401239965995848900909703513553682', 59, 0);
  t('0.000000000000034716604224301619113605162061332208', '0.0000000000000347166042243016191136051620613322078875442915881933', 48, 5);
  t('4554587644116353728395891927482', '4554587644116353728395891927482', 4, 4);
  t('83', '83', 1, 4);
  t('-0.0000000000000000679512312597136188846870750884127001656543', '-0.0000000000000000679512312597136188846870750884127001656543162955358', 58, 5);
  t('-0.000000000000000005843127017405787209162333', '-0.0000000000000000058431270174057872091623337743081992327769648', 42, 2);
  t('698142412071442689875148052035405913655358215178078673989', '698142412071442689875148052035405913655358215178078673989', 31, 2);
  t('-0.000000000000000000000000001', '-0.0000000000000000000000000000000000000009', 27, 3);
  t('0', '0.000000000000000000000000000000000000000000000000086322062431379058693358', 36, 6);
  t('-7097679626212584135194693334505819500.76271239784243114877303953752095973790591', '-7097679626212584135194693334505819500.7627123978424311487730395375209597379059174819443305631091738', 41, 1);
  t('720941616590530465684319461159925340787620861616050215112729354513077297889437424470222725372.4341', '720941616590530465684319461159925340787620861616050215112729354513077297889437424470222725372.43418', 4, 1);
  t('-8565045.0741813', '-8565045.07418120224', 7, 3);
  t('7179182230007440380654240229988748528461622212340003478705', '7179182230007440380654240229988748528461622212340003478705', 16, 1);
  t('128138852434106311723518159896099183377408757231649238006509175039', '128138852434106311723518159896099183377408757231649238006509175039', 51, 0);
  t('0.0000000000000000000000000000000000071444116240971906475', '0.000000000000000000000000000000000007144411624097190647497044019271703768941206', 56, 5);
  t('0', '0.00000000000000000000000000000000000000000000021714481944', 43, 6);
  t('-0.0000000000000001', '-0.0000000000000000000000000034534834', 16, 0);
  t('-0.0000000000000000000008286492885892336366506247591678062602', '-0.00000000000000000000082864928858923363665062475916780626021532507656936043414109352811732', 58, 1);
  t('31161421229261423772494491055755169247634601491928', '31161421229261423772494491055755169247634601491928', 51, 3);
  t('1748715317929813133410156549170209422179478560908330825848622104018934659066', '1748715317929813133410156549170209422179478560908330825848622104018934659066', 57, 4);
  t('-554303811557294466.269761483473739646624314242607077', '-554303811557294466.269761483473739646624314242607077815435340758612837177421989342652', 33, 1);
  t('-0.19004485', '-0.19004485473016995992614957080209680408919713640428488619', 8, 1);
  t('0.000252525605711892', '0.000252525605711891731866212005527221984514215823140269482997380211714402276122070798053', 18, 6);
  t('86245969707619', '86245969707619', 14, 3);
  t('-31435925010862195008998682761', '-31435925010862195008998682761', 9, 3);
  t('-7376.12482208', '-7376.124822087908447175101', 8, 2);
  t('0.000080221434577125714125624728141606555230430450054', '0.0000802214345771257141256247281416065552304304500535613033078792598113626175', 51, 0);
  t('-6050582615205191601389958119203059837835097590785064613410822037914417495686026661', '-6050582615205191601389958119203059837835097590785064613410822037914417495686026661', 31, 1);
  t('0.00000000000000003455493043277403696896050418463562482', '0.0000000000000000345549304327740369689605041846356248273019036250593274409786087865531980510674', 53, 3);
  t('-20967.65067808575', '-20967.6506780857520813447701235001803657407937', 11, 6);
  t('568254966593770.553753276551449605949', '568254966593770.553753276551449605948238816764309803642928261672349658172008375162162314878680613', 21, 0);
  t('-451.149170475956331479335', '-451.1491704759563314793340102771090380475440750267088321862964226523091325726805634622304958123379', 21, 3);
  t('-0.00000000000000000000000089587927281631480799', '-0.00000000000000000000000089587927281631480798176250533957436898566513857011780218162097370714526', 44, 0);
  t('0.00006', '0.00005989898942742447311513559', 6, 2);
  t('0.00000000000000000000000000000000000084666165975', '0.000000000000000000000000000000000000846661659751645', 47, 6);
  t('-274912.8896024699', '-274912.8896024699118787839924993246206752520896053416203239133353705', 10, 1);
  t('2884607226068313798651836226110538860137007975185098848', '2884607226068313798651836226110538860137007975185098848', 55, 6);
  t('-0.00000000000000000002773912168', '-0.000000000000000000027739121678637743521714908420713523555500095414277237781740952561559672', 29, 3);
  t('-2651358523359639', '-2651358523359639', 16, 4);
  t('-4813276596516131663456402092.38944176', '-4813276596516131663456402092.3894417517916213734867', 8, 3);
  t('-0.000000000000000000000000000000000000112895859', '-0.000000000000000000000000000000000000112895858119340820153717620708673416', 45, 0);
  t('-0.0000000000000000021', '-0.0000000000000000020224974226159732231298241899365279396237510862449464734463589', 19, 3);
  t('-7589382547973376572325815568183010749314649708', '-7589382547973376572325815568183010749314649708', 33, 5);
  t('842229243093860852173.05443961588175098377444082861489172139756969332835', '842229243093860852173.0544396158817509837744408286148917213975696933283408713841831638764', 50, 0);
  t('-699708233495.712278374225898965891885496', '-699708233495.71227837422589896589188549642075052667001859282382939797996992686357419809583', 27, 4);
  t('-0.00000000071616892037859054', '-0.000000000716168920378590537721800581109521242491374877', 26, 0);
  t('3951438403.277181863849692687044689923289027507211228628773736', '3951438403.2771818638496926870446899232890275072112286287737359542096', 51, 2);
  t('109559.01297171197941271991562118124015322', '109559.012971711979412719915621181240153223610175595763848035079898263530366', 35, 3);
  t('-0.00000000000000000000000000000000000000000000489005761683947', '-0.00000000000000000000000000000000000000000000489005761683946256390055271579820502403', 59, 3);
  t('-0.00158', '-0.00158276409341184629828973465939702170102740363504722102864514069935682480434491', 5, 2);
  t('-2625562538887919963240549817430379735187837775384', '-2625562538887919963240549817430379735187837775384', 44, 0);
  t('0', '0.00000000000000000000002', 9, 1);
  t('6744808.28630410992583043657159413157574982400492', '6744808.28630410992583043657159413157574982400491999838773235902794700459508120619939892', 42, 6);
  t('0.000000000000000009', '0.000000000000000009', 18, 3);
  t('6067881766683695479556751950119377724336039886809300136812181462', '6067881766683695479556751950119377724336039886809300136812181462', 31, 1);
  t('0.000000000000000000000000000000000000000077241022793', '0.0000000000000000000000000000000000000000772410227935606591033087412064412570098277', 51, 1);
  t('743268323094543466714.5656060177009296968524561226948074051004264', '743268323094543466714.565606017700929696852456122694807405100426400624651576046667459841457817767865', 43, 3);
  t('-596135', '-596135', 3, 2);
  t('0.07662404229928167815820747802086592943344134084819', '0.0766240422992816781582074780208659294334413408481864862625859275536716954542357278357044523255', 50, 4);
  t('-0.000000000000000000000000000885256', '-0.000000000000000000000000000885255222637729340070545710310579917592457286140653', 33, 0);
  t('55893020145100569857309952693924435456669213.356281068124371401302229274073839082240544043386519', '55893020145100569857309952693924435456669213.356281068124371401302229274073839082240544043386519', 51, 0);
  t('0.000000000044398802543439239843437872656117', '0.000000000044398802543439239843437872656117345711426288269229', 42, 1);
  t('0.000000000000000000000000000026311845042475573561274888459', '0.00000000000000000000000000002631184504247557356127488845876295156781061349824020867304', 57, 6);
  t('-127546673151161350153045221729711', '-127546673151161350153045221729711', 2, 5);
  t('0.0000000000000000000000846081', '0.00000000000000000000008460817346743347251678412215465432867047065857', 28, 3);
  t('-51296363216658187515760473402291', '-51296363216658187515760473402291', 27, 4);
  t('-8623967090632480689370959269411792112227821530531202541003992985', '-8623967090632480689370959269411792112227821530531202541003992985', 54, 5);
  t('-966322003490784535731979767036707880939452169502093813823674817588484', '-966322003490784535731979767036707880939452169502093813823674817588484', 56, 5);
  t('-272472379898107893040761485379027824396136886208', '-272472379898107893040761485379027824396136886208', 40, 1);
  t('0.000000000000000000007578294653267877535740172858883482', '0.00000000000000000000757829465326787753574017285888348202441720573692830214583542806201', 55, 6);
  t('25958781094763030494523126276550672249453141421083859868561356127876297714106602172585', '25958781094763030494523126276550672249453141421083859868561356127876297714106602172585', 29, 5);
  t('0.00000000000000000000000000000000000002', '0.000000000000000000000000000000000000015806075051053843417566111132263641553843698646164', 38, 5);
  t('-73099329416955017257739991488405608089647281115099586', '-73099329416955017257739991488405608089647281115099586', 21, 6);
  t('-88307320.90319141093816288808957670297463', '-88307320.903191410938162888089576702974638474154077235587259266824247410860533478169707304792818', 32, 2);
  t('-35236814557361445958969411965214520.30399877405421', '-35236814557361445958969411965214520.303998774054210302477326477', 14, 2);
  t('-2908087206403224796868158372851057.39782067611', '-2908087206403224796868158372851057.3978206761117082535006786132666114643644421715709235528929678', 11, 4);
  t('-19581413994383784948718328954653', '-19581413994383784948718328954653', 28, 1);
  t('0.00000000000000000000000000004', '0.000000000000000000000000000040608230569366379665209245709785291404206510745612419401142658', 29, 3);
  t('-0.906238977426875501362745', '-0.9062389774268755013627459831223515271076867650054627805581400941104277662892230888597201', 24, 2);
  t('0', '0.000000000000000000000025517761823978244291048210421988594612225022695964910425529', 21, 1);
  t('663336.45734367931832199866', '663336.4573436793183219986595282312647796998714487327022132545955984591825466144183', 20, 4);
  t('-461221276.52047063868261544207237644195170184', '-461221276.5204706386826154420723764419517018397461911607', 36, 4);
  t('92664692270788697481952993240101', '92664692270788697481952993240101', 9, 1);
  t('0.00000000000001', '0.0000000000000000417218487798321067688965201563233239322412080713783058725771499175637', 14, 0);
  t('-0.00000000000000291161', '-0.0000000000000029116100944057582762735577555', 21, 6);
  t('3593092835933826522602826541522473977510499517734180584911059518', '3593092835933826522602826541522473977510499517734180584911059518', 39, 2);
  t('0.00000000000240671872382434259', '0.00000000000240671872382434258731759266816542514881094906467645247797685306920193421', 29, 6);
  t('98445608185462908936594271820438358882244286228', '98445608185462908936594271820438358882244286228', 43, 4);
  t('-38275693035627727048820160757435988950513161', '-38275693035627727048820160757435988950513161', 28, 2);
  t('0.000000000000000007838540274247171557849126', '0.000000000000000007838540274247171557849125417291807341828802631329086161031903106930206518314803525', 42, 0);
  t('0', '0.0000000000000000000000000000000000000008760161376', 38, 6);
  t('-274462946120897177140732986024361620867165740004629583369799434.752624497847', '-274462946120897177140732986024361620867165740004629583369799434.7526244978472107528071824755321251', 12, 1);
  t('805407519521180265118391229', '805407519521180265118391229', 27, 0);
  t('4837.60752412303502514', '4837.60752412303502513085517977565448616961234363618524491896285197928079211821305450283483280681236', 17, 0);
  t('19446.966116400627008657626752077217581388920002', '19446.966116400627008657626752077217581388920001650492489914443643730475', 42, 6);
  t('259711114990641', '259711114990641', 1, 3);
  t('-0.0000000001', '-0.0000000000000000002', 10, 0);
  t('80565580.149080509196072203611545842035798415', '80565580.1490805091960722036115458420357984148292066084650845696757793247885015079193577022206528568', 36, 5);
  t('0.000000005126609951384222369644011060208031', '0.00000000512660995138422236964401106020803193692417523731220078957765716642', 42, 3);
  t('1758006742538130240388703498480688686072955030356.7524172233646685', '1758006742538130240388703498480688686072955030356.75241722336466855', 16, 1);
  t('-128086989690.52297791537155595882257011356310571016034760745375196584546', '-128086989690.5229779153715559588225701135631057101603476074537519658454607884909539951', 59, 2);
  t('-361166416734639117275346911473316661252428418964862.401', '-361166416734639117275346911473316661252428418964862.400974469693342990746', 4, 5);
  t('71633752430127836728495483808.07484204148983764432608854793881189', '71633752430127836728495483808.074842041489837644326088547938811892934755621628332271860178432369', 35, 4);
  t('5744453717566208360238616812981884481035389801', '5744453717566208360238616812981884481035389801', 46, 1);
  t('2988347090930431122495200201632971168964831173901728', '2988347090930431122495200201632971168964831173901728', 31, 0);
  t('2320482568655945754105081468655336561175857', '2320482568655945754105081468655336561175857', 13, 6);
  t('0.0000000000000000000000381190632343589292', '0.0000000000000000000000381190632343589291525554226892790057468635150617798724', 40, 6);
  t('-815303438910393610000000000000000000000000000', '-815303438910393610000000000000000000000000000.5', 0, 7);
  t('48079804879135055337410501154945563557501499846191760613365317572636043210233866737200001', '48079804879135055337410501154945563557501499846191760613365317572636043210233866737200000.5', 0, 7);
  t('775141321458031580151353003447938403271713528287267233801607476638641728594600000000001', '775141321458031580151353003447938403271713528287267233801607476638641728594600000000000.5', 0, 7);
  t('-3246099003639468003580507000000000000000000000000000000000000000000000000000000000000000000000000000', '-3246099003639468003580507000000000000000000000000000000000000000000000000000000000000000000000000000.5', 0, 7);
  t('616052744557652711', '616052744557652710.5', 0, 7);
  t('-47298707260000000000000000000000000000000', '-47298707260000000000000000000000000000000.5', 0, 7);
  t('431370739475777039213491701837719630211035950221951900000000000000000001', '431370739475777039213491701837719630211035950221951900000000000000000000.5', 0, 7);
  t('54683100000000000000000000000000000000000000000000000000000000000000000000000000000000000000001', '54683100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.5', 0, 7);
  t('672783487870821678831521822264427999625400000000000000000000000000000000000000001', '672783487870821678831521822264427999625400000000000000000000000000000000000000000.5', 0, 7);
  t('85750000000000000000000000000000000000000001', '85750000000000000000000000000000000000000000.5', 0, 7);
  t('-357280726879877087440504485199000000000000000000000', '-357280726879877087440504485199000000000000000000000.5', 0, 7);
  t('-4341299477000000000000000000000', '-4341299477000000000000000000000.5', 0, 7);
  t('31902000001', '31902000000.5', 0, 7);
  t('333458122140379389691720067000000000000000000000000000000000000000000001', '333458122140379389691720067000000000000000000000000000000000000000000000.5', 0, 7);
  t('-459839025400000000000000000000', '-459839025400000000000000000000.5', 0, 7);
  t('-82390000000000', '-82390000000000.5', 0, 7);
  t('76701', '76700.5', 0, 7);
  t('190430490057932227000000000000000000000000000000000000001', '190430490057932227000000000000000000000000000000000000000.5', 0, 7);
  t('60159411740605592996051862591038032930184607684088677320000000000000000000000001', '60159411740605592996051862591038032930184607684088677320000000000000000000000000.5', 0, 7);
  t('-2234900000', '-2234900000.5', 0, 7);
  t('56189665877093832601689082910000000000000000000000000000000000000001', '56189665877093832601689082910000000000000000000000000000000000000000.5', 0, 7);
  t('2320000000000000000000000000001', '2320000000000000000000000000000.5', 0, 7);
  t('-6305981611547961162835048322675738149574948489012480000000000000', '-6305981611547961162835048322675738149574948489012480000000000000.5', 0, 7);
  t('7135722984978446900000000000000000000000000000000000001', '7135722984978446900000000000000000000000000000000000000.5', 0, 7);
  t('7739620000000000000000000000000000000000000000000000001', '7739620000000000000000000000000000000000000000000000000.5', 0, 7);
  t('-7310071091565097458378697755962864041334940666867342517847595229165394387202247229680000000', '-7310071091565097458378697755962864041334940666867342517847595229165394387202247229680000000.5', 0, 7);
  t('5138337172269533148524367880141880518489245800000000000001', '5138337172269533148524367880141880518489245800000000000000.5', 0, 7);
  t('-6000', '-6000.5', 0, 7);
  t('463879090754017750000000000000001', '463879090754017750000000000000000.5', 0, 7);
  t('-629850000000000000000', '-629850000000000000000.5', 0, 7);
  t('-205429044500000000000000000000', '-205429044500000000000000000000.5', 0, 7);
  t('-5416257015618874559905147873000000000000000000000000000000000000000000000000', '-5416257015618874559905147873000000000000000000000000000000000000000000000000.5', 0, 7);
  t('623364421289248201317000000000000001', '623364421289248201317000000000000000.5', 0, 7);
  t('911141136528601', '911141136528600.5', 0, 7);
  t('-276055672501612195718314543393745315761189100000', '-276055672501612195718314543393745315761189100000.5', 0, 7);
  t('66201703687996196493948073895661219741.79732939050299983848272445', '66201703687996196493948073895661219741.79732939050299983848272444531659415942809827190951', 26, 8);
  t('-432784391834045276975262545157922', '-432784391834045276975262545157922', 28, 8);
  t('1149345737914160007440457748332143986414.9571', '1149345737914160007440457748332143986414.957136799115537152433594986979', 4, 8);
  t('-8955086490844848921210649185442547', '-8955086490844848921210649185442547', 35, 8);
  t('425088038661656538743278817856878424164093767.85670041722429249440202331857043', '425088038661656538743278817856878424164093767.85670041722429249440202331857043013807', 33, 8);
  t('-309644694334054373034963302293381012433965117503313464512444644', '-309644694334054373034963302293381012433965117503313464512444644', 15, 8);
  t('-6113258580590430007589739873373442564851315606055053637944', '-6113258580590430007589739873373442564851315606055053637944', 20, 8);
  t('-79578809228411034521778967729244470830365009197702327546767865195836773388369068481948969.900741', '-79578809228411034521778967729244470830365009197702327546767865195836773388369068481948969.9007405268', 6, 8);
  t('-98635952437161220.96618', '-98635952437161220.9661782723695091452045447927505345126085', 5, 8);
  t('5306244228965561737.62447596491901907069113187489713', '5306244228965561737.62447596491901907069113187489712907837802453330192181391370636667897993', 32, 8);
  t('881494696226260293271264.36459456081728760273917638738994049272140009', '881494696226260293271264.36459456081728760273917638738994049272140008956721', 45, 8);
  t('0', '0.0000000000000000398975254', 1, 8);
  t('-2966907742563204474300609285105763571411556718257633358168823625207636310562902929129639632', '-2966907742563204474300609285105763571411556718257633358168823625207636310562902929129639632', 59, 8);
  t('4815226942078558754202763870371111530259178454324372013168459692655444158537', '4815226942078558754202763870371111530259178454324372013168459692655444158537', 58, 8);
  t('89735736519038061687.396102956878866121243318078603705593756032576774631567136', '89735736519038061687.396102956878866121243318078603705593756032576774631567136', 57, 8);
  t('-5139206863826452924558709317549576110217185', '-5139206863826452924558709317549576110217185', 10, 8);
  t('410799450059.233711597011245238081176283367945619000645947401973880735', '410799450059.23371159701124523808117628336794561900064594740197388073499637579092523992206', 59, 8);
  t('-1861173217597843873200339700375118033056165470698896905908777053211294087744', '-1861173217597843873200339700375118033056165470698896905908777053211294087744', 38, 8);
  t('-0', '-0.00000000000000006595', 11, 8);
  t('-5407783849362963393803124142731051275240080145012', '-5407783849362963393803124142731051275240080145012', 20, 8);
  t('-34168517091385789116719661427034183841563988149', '-34168517091385789116719661427034183841563988149', 17, 8);
  t('5795445846', '5795445846', 2, 8);
  t('8225834668202811700000', '8225834668202811700000.5', 0, 8);
  t('-67268029621398311238261431331851556661886545942854113916050734581000000000001', '-67268029621398311238261431331851556661886545942854113916050734581000000000000.5', 0, 8);
  t('4100000', '4100000.5', 0, 8);
  t('694900000000000', '694900000000000.5', 0, 8);
  t('-2668752017792840000000000000000000000000000000000000000000000000000000000001', '-2668752017792840000000000000000000000000000000000000000000000000000000000000.5', 0, 8);
  t('5138303265393258323808903836559900000000000000000', '5138303265393258323808903836559900000000000000000.5', 0, 8);
  t('-61599472977109463564534878506157000000000000000000000000000000001', '-61599472977109463564534878506157000000000000000000000000000000000.5', 0, 8);
  t('-706579187032566119663804136174620000000000000000001', '-706579187032566119663804136174620000000000000000000.5', 0, 8);
  t('10', '10.5', 0, 8);
  t('903942469098308100136613765218227935820271584538277900367517300000000000000000', '903942469098308100136613765218227935820271584538277900367517300000000000000000.5', 0, 8);
  t('7259090494485579718152684060350290000000000000000000000000000000000000000000000000000000000', '7259090494485579718152684060350290000000000000000000000000000000000000000000000000000000000.5', 0, 8);
  t('50', '50.5', 0, 8);
  t('-336051', '-336050.5', 0, 8);
  t('12.345', '12.345');
  t('12', '12.345', 0);

  tx(function () {new Decimal('12.345').toDP('2')}, ".toDP('2')");
  tx(function () {new Decimal('12.345').toDP(new Decimal('2'))}, ".toDP(new Decimal('2'))");
  tx(function () {new Decimal('12.345').toDP(null)}, ".toDP(null)");
  tx(function () {new Decimal('12.345').toDP(NaN)}, ".toDP(NaN)");
  tx(function () {new Decimal('12.345').toDP('NaN')}, ".toDP('NaN')");
  tx(function () {new Decimal('12.345').toDP([])}, ".toDP([])");
  tx(function () {new Decimal('12.345').toDP({})}, ".toDP({})");
  tx(function () {new Decimal('12.345').toDP('')}, ".toDP('')");
  tx(function () {new Decimal('12.345').toDP(' ')}, ".toDP(' ')");
  tx(function () {new Decimal('12.345').toDP('hello')}, ".toDP('hello')");
  tx(function () {new Decimal('12.345').toDP('\t')}, ".toDP('\t')");
  tx(function () {new Decimal('12.345').toDP(new Date)}, ".toDP(new Date)");
  tx(function () {new Decimal('12.345').toDP(new RegExp)}, ".toDP(new RegExp)");
  tx(function () {new Decimal('12.345').toDP(7.5)}, ".toDP(7.5)");
  tx(function () {new Decimal('12.345').toDP('1.1e1')}, ".toDP('1.1e1')");
  tx(function () {new Decimal('12.345').toDP('-1')}, ".toDP('-1')");
  tx(function () {new Decimal('12.345').toDP(-23)}, ".toDP(-23)");
  tx(function () {new Decimal('12.345').toDP(1e9 + 1)}, ".toDP(1e9 + 1)");
  tx(function () {new Decimal('12.345').toDP(1e9 + 0.1)}, ".toDP(1e9 + 1)");
  tx(function () {new Decimal('12.345').toDP('-0.01')}, ".toDP('-0.01')");
  tx(function () {new Decimal('12.345').toDP('-1e-1')}, ".toDP('-1e-1')");
  tx(function () {new Decimal('12.345').toDP(Infinity)}, ".toDP(Infinity)");
  tx(function () {new Decimal('12.345').toDP('-Infinity')}, ".toDP('-Infinity')");

  tx(function () {new Decimal('12.345').toDP(1, '2')}, ".toDP(1, '2')");
  tx(function () {new Decimal('12.345').toDP(1, new Decimal('2'))}, ".toDP(1, new Decimal('2'))");
  tx(function () {new Decimal('12.345').toDP(1, null)}, ".toDP(1, null)");
  tx(function () {new Decimal('12.345').toDP(1, NaN)}, ".toDP(1, NaN)");
  tx(function () {new Decimal('12.345').toDP(1, 'NaN')}, ".toDP(1, 'NaN')");
  tx(function () {new Decimal('12.345').toDP(1, [])}, ".toDP(1, [])");
  tx(function () {new Decimal('12.345').toDP(1, {})}, ".toDP(1, {})");
  tx(function () {new Decimal('12.345').toDP(1, '')}, ".toDP(1, '')");
  tx(function () {new Decimal('12.345').toDP(1, ' ')}, ".toDP(1, ' ')");
  tx(function () {new Decimal('12.345').toDP(1, 'hello')}, ".toDP(1, 'hello')");
  tx(function () {new Decimal('12.345').toDP(1, '\t')}, ".toDP(1, '\t')");
  tx(function () {new Decimal('12.345').toDP(1, new Date)}, ".toDP(1, new Date)");
  tx(function () {new Decimal('12.345').toDP(1, new RegExp)}, ".toDP(1, new RegExp)");
  tx(function () {new Decimal('12.345').toDP(1, 7.5)}, ".toDP(1, 7.5)");
  tx(function () {new Decimal('12.345').toDP(1, '1.1e1')}, ".toDP(1, '1.1e1')");
  tx(function () {new Decimal('12.345').toDP(1, '-1')}, ".toDP(1, '-1')");
  tx(function () {new Decimal('12.345').toDP(1, -23)}, ".toDP(1, -23)");
  tx(function () {new Decimal('12.345').toDP(1, 9)}, ".toDP(1, 9)");
  tx(function () {new Decimal('12.345').toDP(1, 8.001)}, ".toDP(1, 8.001)");
  tx(function () {new Decimal('12.345').toDP(1, '-0.01')}, ".toDP(1, '-0.01')");
  tx(function () {new Decimal('12.345').toDP(1, '-1e-1')}, ".toDP(1, '-1e-1')");
  tx(function () {new Decimal('12.345').toDP(1, Infinity)}, ".toDP(1, Infinity)");
  tx(function () {new Decimal('12.345').toDP(1, '-Infinity')}, ".toDP(1, '-Infinity')");
});
