# #BASH library
#
# Tags are generated by searching for a keyword in last commit message. Keywords are:
#  - [patch] or [fix] to bump patch number
#  - [minor], [feature] or [feat] to bump minor number
#  - [major] or [breaking change] to bump major number
# All keywords MUST be surrounded with square braces.
#
# Requirements:
#   - GITHUB_TOKEN variable set with GitHub token. Access level: repo.public_repo
#   - git-semver python package (pip install git-semver)
#
# Original script is available at https://github.com/paulfantom/travis-helper/blob/master/releasing/releaser.sh
#
# Copyright: SPDX-License-Identifier: GPL-3.0-or-later
#
# Author  : Pawel Krupa (paulfantom)
# Author  : Pavlos Emm. Katsoulakis (paul@netdata.cloud)

# Figure out what will be new release candidate tag based only on previous ones.
# This assumes that RELEASES are in format of "v0.1.2" and prereleases (RCs) are using "v0.1.2-rc0"
function set_tag_release_candidate() {
	LAST_TAG=$(git semver)
	echo "${0}: Last tag found is: ${LAST_TAG}"

	if [[ $LAST_TAG =~ -rc* ]]; then
		VERSION=$(echo "$LAST_TAG" | cut -d'-' -f 1)
		LAST_RC=$(echo "$LAST_TAG" | cut -d'c' -f 2)
		RC=$((LAST_RC + 1))
	else
		VERSION="$(git semver --next-minor)"
		RC=0
		echo "${0}: Warning: Will set version to ${VERSION} (Last tag: ${LAST_TAG}) while tagged for release candidate generation"
	fi

	GIT_TAG="v${VERSION}-rc${RC}"
	echo "${0}: Generated a new tag, set to: (${GIT_TAG})"
}

function set_tag_for_release() {
	echo "${0}: Checking for tag existence"
	if [ -z "${GIT_TAG}" ]; then
		echo "${0}: No tag was found, generating a new tag"
		git semver

		echo "${0}: Last commit message: ${TRAVIS_COMMIT_MESSAGE}"

		# Figure out next tag based on commit message
		case "${TRAVIS_COMMIT_MESSAGE}" in
		*"[netdata patch release]"*) GIT_TAG="v$(git semver --next-patch)" ;;
		*"[netdata minor release]"*) GIT_TAG="v$(git semver --next-minor)" ;;
		*"[netdata major release]"*) GIT_TAG="v$(git semver --next-major)" ;;
		*"[netdata release candidate]"*) set_tag_release_candidate ;;
		*)
			echo "${0}: Keyword not detected. Nothing to set for GIT_TAG"
			;;
		esac
	else
		echo "${0}: We seem to already have a GIT_TAG set to (${GIT_TAG})"
	fi
}
