
      PROGRAM WMEX09
C
C  A chart of wind speeds.
C
C Define the error file, the Fortran unit number, the workstation type,
C and the workstation ID to be used in calls to GKS routines.
C
C     PARAMETER (IERRF=6, LUNIT=2, IWTYPE=1,  IWKID=1)   ! NCGM
C     PARAMETER (IERRF=6, LUNIT=2, IWTYPE=8,  IWKID=1)   ! X Windows
C     PARAMETER (IERRF=6, LUNIT=2, IWTYPE=11, IWKID=1)   ! PDF
C     PARAMETER (IERRF=6, LUNIT=2, IWTYPE=20, IWKID=1)   ! PostScript
C
      PARAMETER (IERRF=6, LUNIT=2, IWTYPE=1,  IWKID=1)

      PARAMETER (T1=0.90, T2=0.84)
C
      CALL GOPKS (IERRF, ISZDM)
      CALL GOPWK (IWKID, LUNIT, IWTYPE)
      CALL GACWK (IWKID)
C
      CALL GSCR(IWKID,0,1.,1.,1.)
      CALL GSCR(IWKID,1,0.,0.,0.)
      CALL GSCR(IWKID,2,.4,0.,.4)
C
C  Example 01 - chart of wind barbs for various speeds.
C
      CALL PERIM(1,1,1,1)
      CALL LINE(0.000, T1+0.005, 1.000, T1+0.005)
      CALL LINE(0.000, T1-0.005, 1.000, T1-0.005)
      CALL LINE(0.000, T2, 1.000, T2)
      CALL LINE(0.495, 0.000, 0.495, T1-0.005)
      CALL LINE(0.505, 0.000, 0.505, T1-0.005)
C
      CALL PLCHHQ(0.5,0.955,':F25:Wind Speeds',.03,0.,0.)
      CALL PCSETI('FN',21)
      XCL = 0.12
      XCC = 0.26
      XCR = 0.40
      DO 10 I=1,2
        XL = XCL+(I-1)*0.5
        XC = XCC+(I-1)*0.5
        XR = XCR+(I-1)*0.5
        CALL PLCHHQ(XL,0.87,'Symbol',0.022,0.,0.) 
        CALL PLCHHQ(XC,0.87,'Knots',0.022,0.,0.) 
        CALL PLCHHQ(XR,0.87,'Miles/hr.',0.022,0.,0.) 
   10 CONTINUE
      FINC = T2/10.
      SIZE = 0.022
      XCL = 0.16
      CALL GSLWSC(3.)
      CALL NGSETI('WO',1)
      CALL NGSETI('CA',0)
C
      P1 = T2-0.75*FINC
      CALL WMSETR('WBS',0.1)
      CALL WMSETI('COL',1)
      CALL WMGETR('WBS',WSLEN)
      CALL WMBARB(XCL-0.5*WSLEN,P1-0.5*SIZE,0.,0.)
      CALL PLCHHQ(XCC,P1,'Calm',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'Calm',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-1.,0.)
      CALL PLCHHQ(XCC,P1,'1-2',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'1-2',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-5.,0.)
      CALL PLCHHQ(XCC,P1,'3-7',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'3-8',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-10.,0.)
      CALL PLCHHQ(XCC,P1,'8-12',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'9-14',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-15.,0.)
      CALL PLCHHQ(XCC,P1,'13-17',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'15-20',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-20.,0.)
      CALL PLCHHQ(XCC,P1,'18-22',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'21-25',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-25.,0.)
      CALL PLCHHQ(XCC,P1,'23-27',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'26-31',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-30.,0.)
      CALL PLCHHQ(XCC,P1,'28-32',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'32-37',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-35.,0.)
      CALL PLCHHQ(XCC,P1,'33-37',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'38-43',SIZE,0.,0.)
C
      XCL = XCL+0.5
      XCC = XCC+0.5
      XCR = XCR+0.5
      P1 = T2-0.75*FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-40.,0.)
      CALL PLCHHQ(XCC,P1,'38-42',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'44-49',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-45.,0.)
      CALL PLCHHQ(XCC,P1,'43-47',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'50-54',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-50.,0.)
      CALL PLCHHQ(XCC,P1,'48-52',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'55-60',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-55.,0.)
      CALL PLCHHQ(XCC,P1,'53-57',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'61-66',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-60.,0.)
      CALL PLCHHQ(XCC,P1,'58-62',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'67-71',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-65.,0.)
      CALL PLCHHQ(XCC,P1,'63-67',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'72-77',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-70.,0.)
      CALL PLCHHQ(XCC,P1,'68-72',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'78-83',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-75.,0.)
      CALL PLCHHQ(XCC,P1,'73-77',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'84-89',SIZE,0.,0.)
C
      P1 = P1-FINC
      CALL WMBARB(XCL,P1-0.5*SIZE,-105.,0.)
      CALL PLCHHQ(XCC,P1,'103-107',SIZE,0.,0.)
      CALL PLCHHQ(XCR,P1,'119-123',SIZE,0.,0.)
C
      CALL FRAME
C
      CALL GDAWK (IWKID)
      CALL GCLWK (IWKID)
      CALL GCLKS
C
      STOP
      END
